/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceCmdFactory;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.text.NMsg;

public class ConfigNWorkspaceCommandFactory
implements NWorkspaceCmdFactory {
    protected NLog _LOG() {
        return NLog.of(ConfigNWorkspaceCommandFactory.class);
    }

    @Override
    public void configure(NCommandFactoryConfig config) {
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getFactoryId() {
        return "default";
    }

    @Override
    public NCommandConfig findCommand(String name) {
        NCommandConfig c;
        NPath file = this.getCommandsFolder().resolve(name + ".nuts-cmd.json");
        if (file.exists() && (c = NElementParser.ofJson().parse(file, NCommandConfig.class)) != null) {
            c.setName(name);
            return c;
        }
        return null;
    }

    @Override
    public List<NCommandConfig> findCommands() {
        return this.findCommands((Predicate<NCommandConfig>)null);
    }

    public NPath getStoreLocation() {
        return NPath.ofIdStore(NWorkspace.of().getApiId(), NStoreType.BIN);
    }

    private NPath getCommandsFolder() {
        return this.getStoreLocation().resolve("cmd");
    }

    public void uninstallCommand(String name) {
        NPath file = this.getCommandsFolder().resolve(name + ".nuts-cmd.json");
        if (file.exists()) {
            file.delete();
            NWorkspaceExt.of().getConfigModel().fireConfigurationChanged("command", ConfigEventType.MAIN);
        }
    }

    public void installCommand(NCommandConfig command) {
        NPath path = this.getCommandsFolder().resolve(command.getName() + ".nuts-cmd.json");
        NElementWriter.ofJson().setNtf(false).write((Object)command, path);
        NWorkspaceExt.of().getConfigModel().fireConfigurationChanged("command", ConfigEventType.MAIN);
    }

    public List<NCommandConfig> findCommands(NId id) {
        return this.findCommands((NCommandConfig value) -> CoreFilterUtils.matchesSimpleNameStaticVersion(value.getOwner(), id));
    }

    public List<NCommandConfig> findCommands(Predicate<NCommandConfig> filter) {
        ArrayList<NCommandConfig> all = new ArrayList<NCommandConfig>();
        NPath storeLocation = this.getCommandsFolder();
        if (!storeLocation.isDirectory()) {
            return all;
        }
        storeLocation.stream().forEach(file -> {
            String fileName = file.getName();
            if (file.getName().endsWith(".nuts-cmd.json")) {
                NCommandConfig c = null;
                try {
                    c = NElementParser.ofJson().parse((NPath)file, NCommandConfig.class);
                }
                catch (Exception ex) {
                    this._LOG().log(NMsg.ofC("unable to parse %s", file).asFine(ex));
                }
                if (c != null) {
                    c.setName(fileName.substring(0, fileName.length() - ".nuts-cmd.json".length()));
                    if (filter == null || filter.test(c)) {
                        all.add(c);
                    }
                }
            }
        });
        return all;
    }
}

