/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.push;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NPushCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractDefaultNPushCmd
extends NWorkspaceCmdBase<NPushCmd>
implements NPushCmd {
    protected boolean offline = false;
    protected List<String> args;
    protected final List<NId> ids = new ArrayList<NId>();
    protected List<NId> lockedIds;
    protected String repository;

    public AbstractDefaultNPushCmd(NWorkspace workspace) {
        super("push");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NPushCmd addId(String id) {
        return this.addId(id == null ? null : NId.get(id).get());
    }

    @Override
    public NPushCmd addLockedId(String id) {
        return this.addLockedId(id == null ? null : NId.get(id).get());
    }

    @Override
    public NPushCmd addId(NId id) {
        if (id == null) {
            throw new NArtifactNotFoundException(id);
        }
        this.ids.add(id);
        return this;
    }

    @Override
    public NPushCmd removeId(NId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    @Override
    public NPushCmd removeId(String id) {
        if (id != null) {
            this.ids.remove(NId.get(id).get());
        }
        return this;
    }

    @Override
    public NPushCmd removeLockedId(NId id) {
        if (id != null && this.lockedIds != null) {
            this.lockedIds.remove(id);
        }
        return this;
    }

    @Override
    public NPushCmd removeLockedId(String id) {
        if (id != null && this.lockedIds != null) {
            this.lockedIds.remove(NId.get(id).get());
        }
        return this;
    }

    @Override
    public NPushCmd addLockedId(NId id) {
        if (id == null) {
            throw new NArtifactNotFoundException(id);
        }
        if (this.lockedIds == null) {
            this.lockedIds = new ArrayList<NId>();
        }
        this.lockedIds.add(id);
        return this;
    }

    @Override
    public NPushCmd addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NPushCmd addIds(NId ... ids) {
        for (NId id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NPushCmd addLockedIds(String ... values) {
        for (String id : values) {
            this.addLockedId(id);
        }
        return this;
    }

    @Override
    public NPushCmd addLockedIds(NId ... values) {
        for (NId id : values) {
            this.addLockedId(id);
        }
        return this;
    }

    @Override
    public List<String> getArgs() {
        return NCollections.unmodifiableList(this.args);
    }

    @Override
    public NPushCmd addArg(String arg) {
        if (arg != null) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
        }
        return this;
    }

    @Override
    public NPushCmd addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    @Override
    public NPushCmd addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
        return this;
    }

    @Override
    public List<NId> getIds() {
        return NCollections.unmodifiableList(this.ids);
    }

    @Override
    public List<NId> getLockedIds() {
        return NCollections.unmodifiableList(this.lockedIds);
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public NPushCmd setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public NPushCmd setRepository(String repository) {
        this.repository = repository;
        return this;
    }

    @Override
    public NPushCmd args(Collection<String> args) {
        return this.addArgs(args);
    }

    @Override
    public NPushCmd clearArgs() {
        this.args = null;
        return this;
    }

    @Override
    public NPushCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NPushCmd clearLockedIds() {
        this.lockedIds = null;
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        switch (a.key()) {
            case "-o": 
            case "--offline": {
                return cmdLine.matcher().matchFlag(v -> this.setOffline(v.booleanValue())).anyMatch();
            }
            case "-x": 
            case "--freeze": {
                return cmdLine.matcher().matchEntry(v -> {
                    for (String id : v.stringValue().split(",")) {
                        this.addLockedId(id);
                    }
                }).anyMatch();
            }
            case "-r": 
            case "-repository": 
            case "--from": {
                return cmdLine.matcher().matchEntry(v -> this.setRepository(v.stringValue())).anyMatch();
            }
            case "-g": 
            case "--args": {
                return cmdLine.matcher().matchTrueFlag(v -> {
                    this.addArgs(cmdLine.toStringArray());
                    cmdLine.skipAll();
                }).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (!a.isOption()) {
            cmdLine.skip();
            this.addId(a.asString().get());
            return true;
        }
        cmdLine.throwUnexpectedArgument();
        return false;
    }
}

