/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.List;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;

public class InstallIdCacheItem {
    public NId id;
    public boolean optional;
    public NDefinition definition;
    public List<NDependency> dependencies;
    public NDescriptor effectiveDescriptor;
    public NInstallStatus oldInstallStatus;
    public NInstallStatus currentInstallStatus;

    public static NId normalizeId(NDependency id) {
        return id.toId().getLongId();
    }

    public static NId normalizeId(NId id) {
        return id.getLongId();
    }

    public InstallIdCacheItem(NId id) {
        this.id = InstallIdCacheItem.normalizeId(id);
        this.optional = id.toDependency().isOptional();
    }

    public List<NDependency> getDependencies() {
        if (this.dependencies == null) {
            return this.getDefinition().getDependencies().get().transitive().toList();
        }
        return this.dependencies;
    }

    public NInstallStatus getOldInstallStatus() {
        if (this.oldInstallStatus == null) {
            this.oldInstallStatus = NWorkspaceExt.of().getInstalledRepository().getInstallStatus(this.id);
        }
        return this.oldInstallStatus;
    }

    public InstallIdCacheItem setCurrentInstallStatus(NInstallStatus currentInstallStatus) {
        this.currentInstallStatus = currentInstallStatus;
        return this;
    }

    public NInstallStatus getInstallStatus() {
        if (this.currentInstallStatus == null) {
            return this.getOldInstallStatus();
        }
        return this.currentInstallStatus;
    }

    public NDescriptor getEffectiveDescriptor() {
        if (this.effectiveDescriptor == null) {
            this.effectiveDescriptor = this.getDefinition().getEffectiveDescriptor().get();
        }
        return this.effectiveDescriptor;
    }

    public NPath getContent() {
        if (!this.getDefinition().getDescriptor().isNoContent()) {
            return this.getDefinition().getContent().get();
        }
        return null;
    }

    public NDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = NSearchCmd.of(this.id).failFast().setDependencyFilter(NDependencyFilters.of().byRunnable()).latest().getResultDefinitions().findFirst().get();
        }
        return this.definition;
    }

    public void revalidate(NDefinition definition) {
        this.definition = definition;
        this.effectiveDescriptor = null;
        this.dependencies = null;
    }

    public void revalidate(boolean force) {
        this.definition = force ? NSession.of().copy().setCached(false).callWith(() -> NSearchCmd.of(this.id).failFast().setRepositoryFilter(NRepositoryFilters.of().installedRepo().neg()).setDependencyFilter(NDependencyFilters.of().byRunnable()).latest().getResultDefinitions().findFirst().get()) : NSearchCmd.of(this.id).failFast().setDependencyFilter(NDependencyFilters.of().byRunnable()).latest().getResultDefinitions().findFirst().get();
        this.effectiveDescriptor = null;
        this.dependencies = null;
    }
}

