/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.event.DefaultNInstallEvent;
import net.thevpc.nuts.runtime.standalone.event.DefaultNUpdateEvent;
import net.thevpc.nuts.runtime.standalone.extension.NExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.AbstractNInstallCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallCache;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdCacheItem;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdList;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.NRecommendationPhase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.spi.NInstallerComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NReadOnlyException;

public class InstallHelper {
    private DefaultNWorkspace ws;
    private InstallCache cache;
    protected NDefinition[] result;
    protected NId[] failed;
    protected List<String> args;
    protected List<AbstractNInstallCmd.ConditionalArguments> conditionalArguments;
    List<NDefinition> resultList = new ArrayList<NDefinition>();
    List<NId> failedList = new ArrayList<NId>();
    protected final InstallIdList list;
    boolean updateMode;

    public InstallHelper(DefaultNWorkspace ws, InstallIdList list, boolean updateMode, List<String> args, List<AbstractNInstallCmd.ConditionalArguments> conditionalArguments) {
        this.ws = ws;
        this.cache = new InstallCache();
        this.list = list;
        this.updateMode = updateMode;
        this.args = args == null ? new ArrayList<String>() : new ArrayList<String>(args);
        this.conditionalArguments = conditionalArguments == null ? new ArrayList<AbstractNInstallCmd.ConditionalArguments>() : new ArrayList<AbstractNInstallCmd.ConditionalArguments>(conditionalArguments);
    }

    public InstallIdList getList() {
        return this.list;
    }

    public InstallIdCacheItem getCache(NId id) {
        return this.cache.get(id);
    }

    private Map<String, String> prepareInstallVars(NDefinition def) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("nutsIdContentPath", def.getContent().get().toString());
        for (NStoreType st : NStoreType.values()) {
            m.put("nutsId" + NNameFormat.TITLE_CASE.format(st.id()) + "Path", NPath.ofIdStore(def.getId(), st).toString());
        }
        return m;
    }

    private void ensureLoaded(InstallIdInfo info) {
        if (!info.loaded) {
            if (info.cacheItem == null) {
                info.cacheItem = this.cache.get(info.id);
            }
            if (info.flags.force || info.flags.repair) {
                info.cacheItem.revalidate(true);
            } else {
                info.cacheItem.getDefinition();
            }
            if (info.flags.install) {
                info.cacheItem.getEffectiveDescriptor();
                info.cacheItem.getDependencies();
            }
            info.loaded = true;
        }
    }

    private void _revisitRequirements(InstallIdList list) {
        for (InstallIdInfo info : list.infos()) {
            if (info.ignored || info.doError != null) continue;
            this.ensureLoaded(info);
            if (!info.flags.install) continue;
            for (NDependency dependency : info.cacheItem.getDependencies()) {
                InstallIdCacheItem c = this.cache.get(dependency.toId());
                if (!dependency.isOptional() && c.optional) {
                    c.optional = false;
                }
                if (info.flags.deployOnly) {
                    this.ensureLoaded(list.addAsDeployed(c.id, info.flags));
                    continue;
                }
                this.ensureLoaded(list.addAsRequired(c.id, info.id, info.flags));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void installAll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DoInstallOneImplSafeResult doInstallOneImplSafe(InstallIdInfo info, InstallIdList list) {
        try {
            if (this.doInstallOneImplUnsafe(info, list)) {
                this.resultList.add(info.cacheItem.definition);
                return DoInstallOneImplSafeResult.ISTALLED;
            }
            return DoInstallOneImplSafeResult.NON_INSTALLED;
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofC("failed to install %s", info.id).asFine(ex).withIntent(NMsgIntent.ALERT));
            this.failedList.add(info.id);
            if (NSession.of().isPlainTrace()) {
                if (!NIO.of().getDefaultTerminal().ask().forBoolean(NMsg.ofC("%s %s and its dependencies... Continue installation?", NMsg.ofStyledError("failed to install"), info.id)).setDefaultValue(true).getBooleanValue().booleanValue()) {
                    NOut.resetLine().println(NMsg.ofC("%s ```error installation cancelled with error:``` %s%n", info.id, ex));
                    this.result = new NDefinition[0];
                    return DoInstallOneImplSafeResult.EXIT;
                }
            } else {
                throw ex;
            }
            NOut.resetLine().println(NMsg.ofC("%s ```error installation cancelled with error:``` %s%n", info.id, ex));
            return DoInstallOneImplSafeResult.EXIT;
        }
    }

    public boolean doInstallOneImplUnsafe(InstallIdInfo info, InstallIdList list) {
        if (info == null) {
            return false;
        }
        NDefinition def = info.cacheItem.getDefinition();
        if (def == null) {
            return false;
        }
        if (info.ignored) {
            return false;
        }
        if (info.flags.switchVersion) {
            this.ws.getInstalledRepository().setDefaultVersion(info.id);
            return true;
        }
        List<Object> args = new ArrayList();
        if (info.flags.install) {
            args = this.buildArgs(info);
        }
        boolean resolveInstaller = info.resolveInstaller;
        this.fireEventBeforeInstall(def);
        NSession session = this.ws.getModel().workspace.currentSession();
        NPrintStream out = session.out();
        NInstallInformation newNInstallInformation = null;
        boolean remoteRepo = true;
        try {
            boolean reinstall = false;
            NInstalledRepository installedRepository = this.ws.getInstalledRepository();
            NWorkspaceUtils wu = NWorkspaceUtils.of(this.ws.getModel().workspace);
            if (session.isPlainTrace()) {
                NTexts text = NTexts.of();
                if (this.updateMode) {
                    NOut.resetLine().println(NMsg.ofC("%s %s ...", text.ofStyled("update", NTextStyle.warn()), def.getId().getLongId()));
                } else if (info.flags.require) {
                    reinstall = def.getInstallInformation().get().getInstallStatus().isRequired();
                    if (reinstall) {
                        // empty if block
                    }
                } else {
                    reinstall = def.getInstallInformation().get().getInstallStatus().isInstalled();
                    if (reinstall) {
                        session.out().resetLine().println(NMsg.ofC("%s %s ...", text.ofStyled("re-install", NTextStyles.of(NTextStyle.success(), NTextStyle.underlined())), def.getId().getLongId()));
                    } else {
                        session.out().resetLine().println(NMsg.ofC("%s %s ...", text.ofStyled("install", NTextStyle.success()), def.getId().getLongId()));
                    }
                }
            }
            if (reinstall && !info.flags.require && def.getInstallInformation().get().getInstallStatus().isInstalled()) {
                info.cacheItem.revalidate(false);
                this.uninstallImpl(info, resolveInstaller, true, false, false);
            }
            info.oldDef = this.reloadOldDef(info);
            out.flush();
            if (def.getContent().isPresent() || def.getDescriptor().isNoContent()) {
                NInstallerComponent installerComponent;
                NExecutionContextBuilder cc = this.ws.createExecutionContext().setDefinition(def).setArguments(args.toArray(new String[0])).failFast().setTemporary(false).setRunAs(NRunAs.currentUser());
                NArtifactCall installer = def.getDescriptor().getInstaller();
                if (installer != null) {
                    String scriptName = installer.getScriptName();
                    String scriptContent = installer.getScriptContent();
                    NPath installScriptPath = null;
                    if (!NBlankable.isBlank(scriptName) && !NBlankable.isBlank(scriptContent)) {
                        installScriptPath = NPath.ofTempIdFile(scriptName, def.getId());
                    }
                    Map<String, String> installVars = this.prepareInstallVars(def);
                    if (installScriptPath != null) {
                        installScriptPath.writeString(scriptContent == null ? "" : scriptContent, new NPathOption[0]);
                        installVars.put("nutsIdInstallScriptPath", installScriptPath.toString());
                    }
                    Map<String, String> installEnv = installVars.entrySet().stream().map(x -> new AbstractMap.SimpleImmutableEntry<String, String>(NNameFormat.CONST_NAME.format((String)x.getKey()), (String)x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    installEnv.putAll(installVars);
                    cc.setEnv(installEnv);
                    cc.addExecutorOptions(installer.getArguments().stream().map(x -> NMsg.ofV(x, installVars).toString()).collect(Collectors.toList()));
                }
                NExecutionContext executionContext = cc.build();
                if (this.updateMode || info.flags.install) {
                    newNInstallInformation = installedRepository.deploy(executionContext.getDefinition());
                    newNInstallInformation = installedRepository.install(executionContext.getDefinition());
                    if (info.flags.require) {
                        newNInstallInformation = installedRepository.require(executionContext.getDefinition(), info.requiredForIds.toArray(new NId[0]), null);
                    }
                } else if (info.flags.require) {
                    newNInstallInformation = installedRepository.deploy(executionContext.getDefinition());
                    newNInstallInformation = installedRepository.require(executionContext.getDefinition(), info.requiredForIds.toArray(new NId[0]), null);
                } else if (info.flags.deployOnly) {
                    newNInstallInformation = installedRepository.deploy(executionContext.getDefinition());
                    newNInstallInformation = installedRepository.deploy(executionContext.getDefinition());
                }
                if (info.flags.switchVersion) {
                    installedRepository.setDefaultVersion(def.getId());
                }
                NFetchCmd fetch2 = NFetchCmd.of(executionContext.getDefinition().getId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setRepositoryFilter(NRepositoryFilters.of().installedRepo()).failFast();
                if (def.getDependencies().isPresent() && def.getDependencies().get().filter() != null) {
                    fetch2.setDependencyFilter(def.getDependencies().get().filter());
                }
                NDefinition defOnInstallRepo = fetch2.getResultDefinition();
                cc.setDefinition(defOnInstallRepo);
                executionContext = cc.build();
                NRepository rep = this.ws.findRepository(def.getRepositoryUuid()).orNull();
                boolean bl = remoteRepo = rep == null || rep.isRemote();
                if (this.updateMode) {
                    installerComponent = null;
                    if (resolveInstaller) {
                        installerComponent = this.ws.getInstaller(def);
                    }
                    NExecutionException updateError = null;
                    if (installerComponent != null) {
                        try {
                            installerComponent.update(executionContext);
                        }
                        catch (NReadOnlyException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            if (session.isPlainTrace()) {
                                out.resetLine().println(NMsg.ofC("%s ```error failed``` to update : %s.", def.getId(), ex));
                            }
                            updateError = new NExecutionException(NMsg.ofC("unable to update %s", def.getId()), (Throwable)ex);
                        }
                    }
                    this.ws.getModel().recomm.trackRecommendationsAsync(new RequestQueryInfo(defOnInstallRepo.getId().toString(), updateError), NRecommendationPhase.UPDATE, updateError != null);
                    if (updateError != null) {
                        throw updateError;
                    }
                } else if (info.flags.install) {
                    installerComponent = null;
                    if (resolveInstaller) {
                        installerComponent = this.ws.getInstaller(def);
                    }
                    if (installerComponent != null) {
                        NExecutionException updateError = null;
                        try {
                            installerComponent.install(executionContext);
                        }
                        catch (NReadOnlyException ex) {
                            throw ex;
                        }
                        catch (RuntimeException ex) {
                            if (session.isPlainTrace()) {
                                out.resetLine().println(NMsg.ofC("```error error: failed to install``` %s: %s.", def.getId(), ex));
                            }
                            try {
                                installedRepository.uninstall(executionContext.getDefinition());
                            }
                            catch (Exception ex2) {
                                this.ws.getModel().LOG.log(NMsg.ofC("failed to uninstall  %s", executionContext.getDefinition().getId()).asFine(ex));
                            }
                            updateError = new NExecutionException(NMsg.ofC("unable to install %s", def.getId()), (Throwable)ex);
                        }
                        this.ws.getModel().recomm.trackRecommendationsAsync(new RequestQueryInfo(def.getId().toString(), updateError), NRecommendationPhase.INSTALL, updateError != null);
                    }
                }
            } else {
                throw new NExecutionException(NMsg.ofC("unable to install %s: unable to locate content", def.getId()), 2);
            }
            switch (def.getDescriptor().getIdType()) {
                case API: {
                    this.ws.getModel().configModel.prepareBootClassPathConf(NIdType.API, def.getId(), null, null, true, false);
                    break;
                }
                case RUNTIME: 
                case EXTENSION: {
                    this.ws.getModel().configModel.prepareBootClassPathConf(def.getDescriptor().getIdType(), def.getId(), null, null, true, true);
                }
            }
            if (this.updateMode) {
                wu.events().fireOnUpdate(new DefaultNUpdateEvent(info.oldDef, def, session, reinstall));
            } else if (info.flags.install) {
                wu.events().fireOnInstall(new DefaultNInstallEvent(def, session, new NId[0], reinstall));
            } else if (info.flags.require) {
                wu.events().fireOnRequire(new DefaultNInstallEvent(def, session, info.forIds.toArray(new NId[0]), reinstall));
            }
            if (def.getDescriptor().getIdType() == NIdType.EXTENSION) {
                NExtensionListHelper h = new NExtensionListHelper(session.getWorkspace().getApiId(), this.ws.getConfigModel().getStoredConfigBoot().getExtensions()).save();
                NDependencies nDependencies = null;
                nDependencies = !def.getDependencies().isPresent() ? NFetchCmd.of(def.getId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition().getDependencies().get() : def.getDependencies().get();
                h.add(def.getId(), nDependencies.transitiveWithSource().toList());
                this.ws.getConfigModel().getStoredConfigBoot().setExtensions(h.getConfs());
                this.ws.getConfigModel().fireConfigurationChanged("extensions", ConfigEventType.BOOT);
            }
        }
        catch (RuntimeException ex) {
            NDefinition finalDef2 = def;
            this.ws.getModel().recomm.trackRecommendationsAsync(new RequestQueryInfo(finalDef2.getId().toString(), ex), info.flags.update ? NRecommendationPhase.UPDATE : NRecommendationPhase.INSTALL, true);
            throw ex;
        }
        if (session.isPlainTrace()) {
            Object installedString;
            String setAsDefaultString = "";
            NTexts text = NTexts.of();
            if (info.flags.switchVersion) {
                setAsDefaultString = " set as " + text.ofBuilder().append((Object)"default", NTextStyle.primary1()) + ".";
            }
            if (newNInstallInformation != null && (newNInstallInformation.isJustInstalled() || newNInstallInformation.isJustRequired())) {
                installedString = null;
                if (newNInstallInformation != null) {
                    if (newNInstallInformation.isJustReInstalled()) {
                        installedString = text.ofStyled("re-install", NTextStyles.of(NTextStyle.success(), NTextStyle.underlined()));
                    } else if (newNInstallInformation.isJustInstalled()) {
                        installedString = text.ofStyled("install", NTextStyle.success());
                    } else if (newNInstallInformation.isJustReRequired()) {
                        installedString = text.ofStyled("re-require", NTextStyles.of(NTextStyle.info(), NTextStyle.underlined()));
                    } else if (newNInstallInformation.isJustRequired()) {
                        installedString = text.ofStyled("require", NTextStyle.info());
                    }
                }
                if (installedString != null) {
                    if (def.getContent().isNotPresent()) {
                        if (session.isPlainTrace()) {
                            out.resetLine().println(NMsg.ofC("%s %s from %s repository (%s).%s", installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.of(setAsDefaultString)));
                        }
                    } else if (!def.getContent().get().isUserCache()) {
                        if (def.getContent().get().isUserTemporary()) {
                            if (session.isPlainTrace()) {
                                out.resetLine().println(NMsg.ofC("%s %s from %s repository (%s) temporarily file %s.%s", installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getContent().orNull(), text.of(setAsDefaultString)));
                            }
                        } else if (session.isPlainTrace()) {
                            out.resetLine().println(NMsg.ofC("%s %s from %s repository (%s).%s", installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.of(setAsDefaultString)));
                        }
                    } else if (def.getContent().get().isUserTemporary()) {
                        if (session.isPlainTrace()) {
                            out.resetLine().println(NMsg.ofC("%s %s from %s repository (%s) temporarily file %s.%s", installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getContent().orNull(), text.of(setAsDefaultString)));
                        }
                    } else if (session.isPlainTrace()) {
                        out.resetLine().println(NMsg.ofC("%s %s from %s repository (%s).%s", installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.of(setAsDefaultString)));
                    }
                }
            } else {
                installedString = null;
                if (newNInstallInformation != null) {
                    if (newNInstallInformation.isJustReInstalled()) {
                        installedString = "re-installed";
                    } else if (newNInstallInformation.isJustInstalled()) {
                        installedString = "installed";
                    } else if (newNInstallInformation.isJustReRequired()) {
                        installedString = "re-required";
                    } else if (newNInstallInformation.isJustRequired()) {
                        installedString = "required";
                    }
                }
                if (installedString != null && session.isPlainTrace()) {
                    out.resetLine().println(NMsg.ofC("%s  %s %s.%s", installedString, def.getId().getLongId(), text.ofStyled("successfully", NTextStyle.success()), text.of(setAsDefaultString)));
                }
            }
        }
        return true;
    }

    private List<String> buildArgs(InstallIdInfo info) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.addAll(this.args);
        for (AbstractNInstallCmd.ConditionalArguments conditionalArgument : this.conditionalArguments) {
            if (!conditionalArgument.getPredicate().test(info.cacheItem.getDefinition())) continue;
            cmdArgs.addAll(conditionalArgument.getArgs());
        }
        return cmdArgs;
    }

    private NDefinition reloadOldDef(InstallIdInfo info) {
        NDefinition def = info.cacheItem.getDefinition();
        NDefinition oldDef = null;
        if (this.updateMode) {
            switch (def.getDescriptor().getIdType()) {
                case API: {
                    oldDef = NFetchCmd.of(NId.getApi(Nuts.getVersion()).get()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFetchStrategy(NFetchStrategy.ONLINE).setFailFast(false).getResultDefinition();
                    break;
                }
                case RUNTIME: {
                    oldDef = NFetchCmd.of(this.ws.getRuntimeId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFetchStrategy(NFetchStrategy.ONLINE).setFailFast(false).getResultDefinition();
                    break;
                }
                default: {
                    oldDef = NSearchCmd.of().addId(def.getId().getShortId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setDefinitionFilter(NDefinitionFilters.of().byDeployed(true)).setFailFast(false).getResultDefinitions().findFirst().orNull();
                }
            }
        }
        return oldDef;
    }

    private void fireEventBeforeInstall(NDefinition def) {
        try {
            NDefinition finalDef = def;
            this.ws.runWith(() -> new Thread(() -> {
                Map rec = null;
                rec = this.updateMode ? this.ws.getModel().recomm.getRecommendations(new RequestQueryInfo(finalDef.getId().toString()), NRecommendationPhase.UPDATE, false) : this.ws.getModel().recomm.getRecommendations(new RequestQueryInfo(finalDef.getId().toString()), NRecommendationPhase.INSTALL, false);
            }).start());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printList(NPrintStream out, String skind, String saction, List<NId> all) {
        if (!all.isEmpty()) {
            NSession session = NSession.of();
            if (NOut.isPlain()) {
                NTexts text = NTexts.of();
                NText kind = text.ofStyled(skind, NTextStyle.primary2());
                NText action = text.ofStyled(saction, saction.equals("set as default") ? NTextStyle.primary3() : (saction.equals("ignored") ? NTextStyle.pale() : NTextStyle.primary1()));
                NTextBuilder msg = NTextBuilder.of();
                msg.append("the following ").append(kind).append(" ").append(all.size() > 1 ? "artifacts are" : "artifact is").append(" going to be ").append(action).append(" : ").appendJoined(NText.ofPlain(", "), all.stream().map(x -> NText.of(x.builder().build())).collect(Collectors.toList()));
                out.resetLine().println(msg);
            } else {
                session.eout().add(NElement.ofObjectBuilder().set("command", "warning").set("artifact-kind", skind).set("action-warning", saction).set("artifacts", (NElement)NElement.ofArrayBuilder().addAll((String[])all.stream().map(x -> x.toString()).toArray(String[]::new)).build()).build());
            }
        }
    }

    protected NLog _LOG() {
        return NLog.of(this.getClass());
    }

    public void uninstallImpl(InstallIdInfo def, boolean runInstaller, boolean deleteFiles, boolean eraseFiles, boolean traceBeforeEvent) {
        NInstallerComponent installerComponent;
        NPrintStream out = CoreIOUtils.resolveOut();
        NDefinition definition = def.cacheItem.getDefinition();
        if (runInstaller && (installerComponent = this.ws.getInstaller(definition)) != null) {
            NExecutionContext executionContext = this.ws.createExecutionContext().setDefinition(definition).setArguments(this.buildArgs(def).toArray(new String[0])).failFast().setTemporary(false).setRunAs(NRunAs.currentUser()).build();
            installerComponent.uninstall(executionContext, eraseFiles);
        }
        this.ws.getInstalledRepository().uninstall(definition);
        NId id = definition.getId();
        if (deleteFiles) {
            if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.BIN).exists()) {
                this.ws.getLocationModel().getStoreLocation(id, NStoreType.BIN).deleteTree();
            }
            if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.LIB).exists()) {
                this.ws.getLocationModel().getStoreLocation(id, NStoreType.LIB).deleteTree();
            }
            if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.LOG).exists()) {
                this.ws.getLocationModel().getStoreLocation(id, NStoreType.LOG).deleteTree();
            }
            if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.CACHE).exists()) {
                this.ws.getLocationModel().getStoreLocation(id, NStoreType.CACHE).deleteTree();
            }
            if (eraseFiles) {
                if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.VAR).exists()) {
                    this.ws.getLocationModel().getStoreLocation(id, NStoreType.VAR).deleteTree();
                }
                if (this.ws.getLocationModel().getStoreLocation(id, NStoreType.CONF).exists()) {
                    this.ws.getLocationModel().getStoreLocation(id, NStoreType.CONF).deleteTree();
                }
            }
        }
        if (definition.getDescriptor().getIdType() == NIdType.EXTENSION) {
            NExtensionListHelper h = new NExtensionListHelper(this.ws.getApiId(), this.ws.getConfigModel().getStoredConfigBoot().getExtensions()).save();
            h.remove(id);
            this.ws.getConfigModel().getStoredConfigBoot().setExtensions(h.getConfs());
            this.ws.getConfigModel().fireConfigurationChanged("extensions", ConfigEventType.BOOT);
        }
        if (traceBeforeEvent && NSession.of().isPlainTrace()) {
            out.println(NMsg.ofC("%s uninstalled %s", id, NText.ofStyled("successfully", NTextStyle.success())));
        }
        NWorkspaceUtils.of(this.ws.getModel().workspace).events().fireOnUninstall(new DefaultNInstallEvent(definition, NSession.of(), new NId[0], eraseFiles));
    }

    private static /* synthetic */ boolean lambda$installAll$14(InstallIdInfo x) {
        return !x.ignored;
    }

    private static /* synthetic */ boolean lambda$installAll$13(InstallIdInfo x) {
        return x.ignored;
    }

    private static /* synthetic */ boolean lambda$installAll$12(InstallIdInfo x) {
        return x.flags.switchVersion && x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$installAll$11(InstallIdInfo x) {
        return x.flags.install && x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$installAll$10(InstallIdInfo x) {
        return x.flags.install && x.isAlreadyRequired() && !x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$installAll$9(InstallIdInfo x) {
        return !x.flags.install && x.flags.require && x.isAlreadyRequired();
    }

    private static /* synthetic */ boolean lambda$installAll$8(InstallIdInfo x) {
        return x.flags.require && !x.flags.install && !x.isAlreadyExists();
    }

    private static /* synthetic */ boolean lambda$installAll$7(InstallIdInfo x) {
        return x.flags.install && !x.isAlreadyExists();
    }

    private static /* synthetic */ boolean lambda$installAll$6(InstallIdInfo x) {
        return !x.ignored;
    }

    private static /* synthetic */ String lambda$installAll$5(NId x) {
        return NIdFormat.of().setOmitImportedGroupId(true).setValue(x.getLongId()).format().toString();
    }

    private static /* synthetic */ NId lambda$installAll$4(InstallIdInfo x) {
        return x.id;
    }

    private static /* synthetic */ String lambda$installAll$3(NId x) {
        return NIdFormat.of().setOmitImportedGroupId(true).setValue(x.getLongId()).format().toString();
    }

    private static /* synthetic */ NId lambda$installAll$2(InstallIdInfo x) {
        return x.id;
    }

    private static /* synthetic */ String lambda$installAll$1(InstallIdInfo installIdInfo) {
        return installIdInfo.doError;
    }

    private static /* synthetic */ boolean lambda$installAll$0(InstallIdInfo x) {
        return x.doError != null;
    }

    static enum DoInstallOneImplSafeResult {
        ISTALLED,
        NON_INSTALLED,
        EXIT;

    }
}

