/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromList;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.AbstractNInstallCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallFlags;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdList;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NStream;

public class DefaultNInstallCmd
extends AbstractNInstallCmd {
    public DefaultNInstallCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NStream<NDefinition> getResult() {
        if (this.result == null) {
            this.run();
        }
        return new NStreamFromList<NDefinition>(this.ids.isEmpty() ? null : this.ids.keySet().toArray()[0].toString(), Arrays.asList(this.result)).redescribe((Supplier)NElementDescribables.ofDesc("InstallResult"));
    }

    @Override
    public NInstallCmd run() {
        List<NId> allIds;
        NWorkspace ws = NWorkspace.of();
        NWorkspaceExt dws = NWorkspaceExt.of();
        NWorkspaceSecurityManager.of().checkAllowed("install", "install");
        InstallIdList list = new InstallIdList();
        for (Map.Entry entry : this.ids.entrySet()) {
            if (list.isVisited((NId)entry.getKey())) continue;
            allIds = NSearchCmd.of().addId((NId)entry.getKey()).setLatest(true).getResultIds().toList();
            if (allIds.isEmpty()) {
                throw new NArtifactNotFoundException(((NId)entry.getKey()).getLongId());
            }
            for (NId id0 : allIds) {
                list.addAsInstalled(id0, (InstallFlags)entry.getValue());
            }
        }
        if (this.isCompanions()) {
            list.emptyCommand = false;
            for (NId nId : NExtensions.of().getCompanionIds()) {
                if (list.isVisited(nId)) continue;
                allIds = NSearchCmd.of().addId(nId).setLatest(true).setTargetApiVersion(ws.getApiVersion()).getResultIds().toList();
                if (allIds.isEmpty()) {
                    throw new NArtifactNotFoundException(nId.getLongId());
                }
                for (NId id0 : allIds) {
                    list.addAsInstalled(id0.builder().setRepository(null).build(), this.companionsInstallFlags);
                }
            }
        }
        if (this.isInstalled()) {
            list.emptyCommand = false;
            InstallFlags v = this.installedInstallFlags.copy();
            v.force = true;
            for (NId resultId : NSearchCmd.of().setDefinitionFilter(NDefinitionFilters.of().byInstalled(true)).getResultIds()) {
                list.addAsInstalled(resultId, v);
            }
            NInstalledRepository nInstalledRepository = dws.getInstalledRepository();
            for (NInstallInformation y : NIteratorUtils.toList(nInstalledRepository.searchInstallInformation())) {
                if (y == null || !y.getInstallStatus().isInstalled() || y.getId() == null) continue;
                list.addAsInstalled(y.getId(), v);
            }
        }
        InstallHelper h = new InstallHelper((DefaultNWorkspace)dws, list, false, this.args, this.conditionalArguments);
        h.installAll();
        this.result = h.result;
        this.failed = h.failed;
        return this;
    }
}

