/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch;

import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNQueryBaseOptions;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNFetchCmd
extends DefaultNQueryBaseOptions<NFetchCmd>
implements NFetchCmd {
    private NId id;
    private boolean ignoreCurrentEnvironment;

    public AbstractNFetchCmd() {
        super("fetch");
        this.failFast();
    }

    @Override
    public boolean isIgnoreCurrentEnvironment() {
        return this.ignoreCurrentEnvironment;
    }

    @Override
    public NFetchCmd setIgnoreCurrentEnvironment(boolean ignoreCurrentEnvironment) {
        this.ignoreCurrentEnvironment = ignoreCurrentEnvironment;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NFetchCmd setId(String id) {
        NId nid = NId.get(id).get();
        return this.setId(nid);
    }

    @Override
    public NFetchCmd setId(NId id) {
        if (id == null) {
            throw new NParseException(NMsg.ofNtf("invalid Id format to fetch : null"));
        }
        if (id.getVersion().isBlank() || !id.getVersion().isSingleValue()) {
            throw new NParseException(NMsg.ofC("invalid Id format to fetch : %s", id));
        }
        this.id = id;
        return this;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public NFetchCmd copyFrom(NFetchCmd other) {
        super.copyFromDefaultNQueryBaseOptions((DefaultNQueryBaseOptions)((Object)other));
        if (other != null) {
            NFetchCmd o = other;
            this.id = o.getId();
            this.ignoreCurrentEnvironment = o.isIgnoreCurrentEnvironment();
        }
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().orNull();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isUncommented();
        switch (a.key()) {
            case "--not-installed": {
                cmdLine.skip();
                if (enabled) {
                    this.setRepositoryFilter(NRepositoryFilters.of().installedRepo().neg().and(this.getRepositoryFilter()));
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                cmdLine.skip();
                if (enabled) {
                    this.setRepositoryFilter(NRepositoryFilters.of().installedRepo().and(this.getRepositoryFilter()));
                }
                return true;
            }
        }
        return super.configureFirst(cmdLine);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{failFast=" + this.isFailFast() + ", inlineDependencies=" + this.isInlineDependencies() + ", repos=" + this.getRepositoryFilter() + ", displayOptions=" + this.getDisplayOptions() + ", id=" + this.getId() + '}';
    }
}

