/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.remote.ssh.system;

import java.io.IOException;
import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecTargetCommandContext;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NCollections;

public class DefaultNSystemExecutableRemote
extends AbstractNExecutableInformationExt {
    String[] cmd;
    List<String> executorOptions;
    private boolean showCommand = false;
    private NExecTargetSPI commExec;
    private NExecInput in;
    private NExecOutput out;
    private NExecOutput err;

    public DefaultNSystemExecutableRemote(NExecTargetSPI commExec, String[] cmd, List<String> executorOptions, NExecCmd execCommand, NExecInput in, NExecOutput out, NExecOutput err) {
        super(cmd[0], NCmdLine.of(cmd).toString(), NExecutableType.SYSTEM, execCommand);
        this.in = in;
        this.out = out;
        this.err = err;
        this.cmd = cmd;
        this.executorOptions = NCollections.nonNullList(executorOptions);
        this.commExec = commExec;
        NCmdLine cmdLine = NCmdLine.of(this.executorOptions);
        block6: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            switch (aa.key()) {
                case "--show-command": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.showCommand = v.booleanValue();
                    }).anyMatch();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
    }

    @Override
    public NId getId() {
        return null;
    }

    private AbstractSyncIProcessExecHelper resolveExecHelper() {
        return new AbstractSyncIProcessExecHelper(){

            @Override
            public int exec() {
                int n;
                NExecCmd execCommand = DefaultNSystemExecutableRemote.this.getExecCommand();
                DefaultNExecTargetCommandContext d = new DefaultNExecTargetCommandContext(execCommand.getConnectionString(), DefaultNSystemExecutableRemote.this.cmd, DefaultNSystemExecutableRemote.this.in, DefaultNSystemExecutableRemote.this.out, DefaultNSystemExecutableRemote.this.err, execCommand);
                try {
                    n = DefaultNSystemExecutableRemote.this.commExec.exec(d);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            d.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NExecutionException(NMsg.ofC("command failed :%s", ex), (Throwable)ex);
                    }
                }
                d.close();
                return n;
            }
        };
    }

    @Override
    public int execute() {
        return this.resolveExecHelper().exec();
    }

    @Override
    public NText getHelpText() {
        switch (NWorkspace.of().getOsFamily()) {
            case WINDOWS: {
                return NText.ofStyled("No help available. Try " + this.getName() + " /help", NTextStyle.error());
            }
        }
        return NText.ofStyled("No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'", NTextStyle.error());
    }

    public String toString() {
        return this.getExecCommand().getRunAs() + " " + NCmdLine.of(this.cmd).toString();
    }
}

