/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.remote.ssh.artifact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecTargetCommandContext;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NCollections;

public class DefaultSpawnExecutableNutsRemote
extends AbstractNExecutableInformationExt {
    NDefinition def;
    String[] cmd;
    String[] ecmd;
    List<String> executorOptions;
    NConnectionString connectionString;
    private boolean showCommand = false;
    private NExecTargetSPI commExec;
    NExecInput in;
    NExecOutput out;
    NExecOutput err;

    public DefaultSpawnExecutableNutsRemote(NExecTargetSPI commExec, NDefinition def, String name, String value, String[] cmd, List<String> executorOptions, NExecCmd execCommand, NExecInput in, NExecOutput out, NExecOutput err) {
        super(name, value == null ? NCmdLine.of(cmd).toString() : value, NExecutableType.SYSTEM, execCommand);
        this.def = def;
        this.in = in;
        this.out = out;
        this.err = err;
        this.cmd = cmd;
        ArrayList<String> ecmdList = new ArrayList<String>();
        if (def != null) {
            ecmdList.add(def.getId().toString());
        }
        ecmdList.addAll(Arrays.asList(cmd));
        this.ecmd = ecmdList.toArray(new String[0]);
        this.executorOptions = NCollections.nonNullList(executorOptions);
        this.commExec = commExec;
        NCmdLine cmdLine = NCmdLine.of(this.executorOptions);
        block6: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            switch (aa.key()) {
                case "--show-command": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.showCommand = v.booleanValue();
                    }).anyMatch();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
    }

    @Override
    public NId getId() {
        return this.def.getId();
    }

    private AbstractSyncIProcessExecHelper resolveExecHelper() {
        return new AbstractSyncIProcessExecHelper(){

            @Override
            public int exec() {
                return DefaultSpawnExecutableNutsRemote.this.runOnce(DefaultSpawnExecutableNutsRemote.this.ecmd);
            }
        };
    }

    private int runOnce(String[] cmd) {
        int n;
        DefaultNExecTargetCommandContext d = new DefaultNExecTargetCommandContext(this.getExecCommand().getConnectionString(), cmd, this.in, this.out, this.err, this.getExecCommand());
        try {
            n = this.commExec.exec(d);
        }
        catch (Throwable throwable) {
            try {
                try {
                    d.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new NExecutionException(NMsg.ofC("command failed :%s", ex), (Throwable)ex);
            }
        }
        d.close();
        return n;
    }

    @Override
    public int execute() {
        return this.resolveExecHelper().exec();
    }

    @Override
    public NText getHelpText() {
        switch (NWorkspace.of().getOsFamily()) {
            case WINDOWS: {
                return NText.ofStyled("No help available. Try " + this.getName() + " /help", NTextStyle.error());
            }
        }
        return NText.ofStyled("No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'", NTextStyle.error());
    }

    public String toString() {
        return this.getExecCommand().getRunAs() + " " + NCmdLine.of(this.ecmd);
    }
}

