/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.system;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.util.ExtraApiUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NCollections;

public class DefaultNSystemExecutable
extends AbstractNExecutableInformationExt {
    String[] cmd;
    List<String> executorOptions;
    private boolean showCommand = false;

    public DefaultNSystemExecutable(String[] cmd, List<String> executorOptions, NExecCmd execCommand) {
        super(cmd[0], NCmdLine.of(cmd).toString(), NExecutableType.SYSTEM, execCommand);
        this.cmd = cmd;
        this.executorOptions = NCollections.nonNullList(executorOptions);
        NCmdLine cmdLine = NCmdLine.of(this.executorOptions);
        block6: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            switch (aa.key()) {
                case "--show-command": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.showCommand = v.booleanValue();
                    }).anyMatch();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
    }

    @Override
    public NId getId() {
        return null;
    }

    private ProcessExecHelper resolveExecHelper() {
        HashMap<String, String> e2 = null;
        NExecCmd execCommand = this.getExecCommand();
        Map<String, String> env1 = execCommand.getEnv();
        if (env1 != null) {
            e2 = new HashMap<String, String>(env1);
        }
        return ProcessExecHelper.ofArgs(null, execCommand.getCommand().toArray(new String[0]), e2, execCommand.getDirectory() == null ? null : execCommand.getDirectory().toPath().get(), this.showCommand, true, execCommand.getSleepMillis(), execCommand.getIn(), execCommand.getOut(), execCommand.getErr(), execCommand.getRunAs(), this.executorOptions.toArray(new String[0]), ExtraApiUtils.asBooleanOr(execCommand.getDry(), NSession.of().isDry()));
    }

    @Override
    public int execute() {
        return this.resolveExecHelper().exec();
    }

    @Override
    public NText getHelpText() {
        switch (NWorkspace.of().getOsFamily()) {
            case WINDOWS: {
                return NText.ofStyled("No help available. Try " + this.getName() + " /help", NTextStyle.error());
            }
        }
        return NText.ofStyled("No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'", NTextStyle.error());
    }

    public String toString() {
        return this.getExecCommand().getRunAs() + " " + NCmdLine.of(this.cmd).toString();
    }
}

