/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.path;

import java.io.Closeable;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.CharacterizedExecFile;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecCmd;
import net.thevpc.nuts.text.NMsg;

public class DefaultNArtifactPathExecutable
extends AbstractNExecutableInformationExt
implements Closeable {
    String cmdName;
    String[] args;
    List<String> executorOptions;
    List<String> workspaceOptions;
    NExecutionType executionType;
    NRunAs runAs;
    DefaultNExecCmd execCommand;
    NDefinition nutToRun;
    CharacterizedExecFile c;
    String tempFolder;
    DefaultNExecCmd.NExecutorComponentAndContext executorComponentAndContext;

    public DefaultNArtifactPathExecutable(String cmdName, String[] args, List<String> executorOptions, List<String> workspaceOptions, NExecutionType executionType, NRunAs runAs, DefaultNExecCmd execCommand, NDefinition nutToRun, CharacterizedExecFile c, String tempFolder, DefaultNExecCmd.NExecutorComponentAndContext executorComponentAndContext) {
        super(cmdName, NCmdLine.of(args).toString(), NExecutableType.ARTIFACT, execCommand);
        this.c = c;
        this.tempFolder = tempFolder;
        this.runAs = runAs;
        this.nutToRun = nutToRun;
        this.cmdName = cmdName;
        this.args = args;
        this.executionType = executionType;
        this.execCommand = execCommand;
        this.executorOptions = executorOptions;
        this.workspaceOptions = workspaceOptions;
        this.executorComponentAndContext = executorComponentAndContext;
    }

    @Override
    public NId getId() {
        return this.nutToRun.getId();
    }

    @Override
    public int execute() {
        return this.executeHelper();
    }

    public int executeHelper() {
        try {
            int n = this.executorComponentAndContext.getComponent().exec(this.executorComponentAndContext.getExecutionContext());
            return n;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void dispose() {
        if (this.tempFolder != null) {
            try {
                NIOUtils.delete(Paths.get(this.tempFolder, new String[0]));
            }
            catch (UncheckedIOException | NIOException e) {
                this.LOG().log(NMsg.ofC("unable to delete temp folder created for execution : %s", this.tempFolder).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            }
        }
        this.c.close();
    }

    public String toString() {
        return "nuts " + this.cmdName + " " + NCmdLine.of(this.args).toString();
    }
}

