/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.artifact;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecCmd;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NUnexpectedException;

public class DefaultNArtifactExecutable
extends AbstractNExecutableInformationExt {
    NDefinition def;
    String commandName;
    String[] appArgs;
    List<String> executorOptions;
    List<String> workspaceOptions;
    Map<String, String> env;
    NPath dir;
    boolean failFast;
    NExecutionType executionType;
    NRunAs runAs;
    DefaultNExecCmd execCommand;
    boolean autoInstall = true;

    public DefaultNArtifactExecutable(NDefinition def, String commandName, String[] appArgs, List<String> executorOptions, List<String> workspaceOptions, Map<String, String> env, NPath dir, boolean failFast, NExecutionType executionType, NRunAs runAs, DefaultNExecCmd execCommand) {
        super(commandName, def.getId().getLongName(), NExecutableType.ARTIFACT, execCommand);
        this.def = def;
        this.runAs = runAs;
        this.commandName = commandName;
        this.appArgs = appArgs;
        this.env = env;
        this.dir = dir;
        this.failFast = failFast;
        this.executionType = executionType;
        this.execCommand = execCommand;
        ArrayList<String> executorOptionsList = new ArrayList<String>();
        NArtifactCall exc = def.getDescriptor().getExecutor();
        if (exc != null) {
            // empty if block
        }
        for (String option : executorOptions) {
            NArg a = NArg.of(option);
            if (a.key().equals("--nuts-auto-install")) {
                if (a.isKeyValue()) {
                    this.autoInstall = a.isNegated() != a.getBooleanValue().get().booleanValue();
                    continue;
                }
                this.autoInstall = true;
                continue;
            }
            executorOptionsList.add(option);
        }
        this.executorOptions = executorOptionsList;
        this.workspaceOptions = workspaceOptions;
    }

    @Override
    public NId getId() {
        return this.def.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute() {
        NSession session = NSession.of();
        if (session.isDry()) {
            if (this.autoInstall && !this.def.getInstallInformation().get().getInstallStatus().isInstalled()) {
                NWorkspaceSecurityManager.of().checkAllowed("auto-install", this.commandName);
                NPrintStream out = session.out();
                out.println(NMsg.ofC("[dry] ==install== %s", this.def.getId().getLongName()));
            }
            this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.workspaceOptions, this.env, this.dir, this.failFast, false, this.execCommand.getIn(), this.execCommand.getOut(), this.execCommand.getErr(), this.executionType, this.runAs);
            return 0;
        }
        NInstallStatus installStatus = this.def.getInstallInformation().get().getInstallStatus();
        if (!installStatus.isInstalled()) {
            if (!this.autoInstall) throw new NUnexpectedException(NMsg.ofC("you must install %s to be able to run it", this.def.getId()));
            NInstallCmd.of(this.def.getId()).run();
            NInstallStatus st = NFetchCmd.of(this.def.getId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition().getInstallInformation().get().getInstallStatus();
            if (st.isInstalled()) return this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.workspaceOptions, this.env, this.dir, this.failFast, false, this.execCommand.getIn(), this.execCommand.getOut(), this.execCommand.getErr(), this.executionType, this.runAs);
            throw new NUnexpectedException(NMsg.ofC("auto installation of %s failed", this.def.getId()));
        }
        if (!installStatus.isObsolete() || !this.autoInstall) return this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.workspaceOptions, this.env, this.dir, this.failFast, false, this.execCommand.getIn(), this.execCommand.getOut(), this.execCommand.getErr(), this.executionType, this.runAs);
        NInstallCmd.of(this.def.getId()).configure(true, "--reinstall").run();
        return this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.workspaceOptions, this.env, this.dir, this.failFast, false, this.execCommand.getIn(), this.execCommand.getOut(), this.execCommand.getErr(), this.executionType, this.runAs);
    }

    public String toString() {
        return "nuts " + this.getId().toString() + " " + NCmdLine.of(this.appArgs).toString();
    }
}

