/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.format;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.text.NExecCmdFormat;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNExecCmdFormat
extends DefaultFormatBase<NExecCmdFormat>
implements NExecCmdFormat {
    private Predicate<NExecCmdFormat.ArgEntry> argumentFilter;
    private Function<NExecCmdFormat.ArgEntry, String> argumentReplacer;
    private Predicate<NExecCmdFormat.EnvEntry> envFilter;
    private Function<NExecCmdFormat.EnvEntry, String> envReplacer;
    private boolean redirectInput = true;
    private boolean redirectOutput = true;
    private boolean redirectError = true;
    private NExecCmd value;

    public DefaultNExecCmdFormat(NWorkspace workspace) {
        super("exec-command");
    }

    @Override
    public boolean isRedirectInput() {
        return this.redirectInput;
    }

    @Override
    public NExecCmdFormat setRedirectInput(boolean redirectInput) {
        this.redirectInput = redirectInput;
        return this;
    }

    @Override
    public boolean isRedirectOutput() {
        return this.redirectOutput;
    }

    @Override
    public NExecCmdFormat setRedirectOutput(boolean redirectOutput) {
        this.redirectOutput = redirectOutput;
        return this;
    }

    @Override
    public boolean isRedirectError() {
        return this.redirectError;
    }

    @Override
    public NExecCmdFormat setRedirectError(boolean redirectError) {
        this.redirectError = redirectError;
        return this;
    }

    @Override
    public NExecCmd getValue() {
        return this.value;
    }

    @Override
    public NExecCmdFormat setValue(NExecCmd value) {
        this.value = value;
        return this;
    }

    @Override
    public Predicate<NExecCmdFormat.ArgEntry> getArgumentFilter() {
        return this.argumentFilter;
    }

    @Override
    public NExecCmdFormat setArgumentFilter(Predicate<NExecCmdFormat.ArgEntry> filter) {
        this.argumentFilter = filter;
        return this;
    }

    @Override
    public Function<NExecCmdFormat.ArgEntry, String> getArgumentReplacer() {
        return this.argumentReplacer;
    }

    @Override
    public DefaultNExecCmdFormat setArgumentReplacer(Function<NExecCmdFormat.ArgEntry, String> argumentReplacer) {
        this.argumentReplacer = argumentReplacer;
        return this;
    }

    @Override
    public Predicate<NExecCmdFormat.EnvEntry> getEnvFilter() {
        return this.envFilter;
    }

    @Override
    public NExecCmdFormat setEnvFilter(Predicate<NExecCmdFormat.EnvEntry> filter) {
        this.envFilter = filter;
        return this;
    }

    @Override
    public Function<NExecCmdFormat.EnvEntry, String> getEnvReplacer() {
        return this.envReplacer;
    }

    @Override
    public NExecCmdFormat setEnvReplacer(Function<NExecCmdFormat.EnvEntry, String> envReplacer) {
        this.envReplacer = envReplacer;
        return this;
    }

    @Override
    public void print(NPrintStream out) {
        StringBuilder sb = new StringBuilder();
        NExecCmd ec = this.getValue();
        NExecOutput _out = ec.getOut();
        NExecOutput err = ec.getErr();
        NExecInput in = ec.getIn();
        Map<String, String> env = ec.getEnv();
        List<String> command = ec.getCommand();
        if (env != null) {
            for (Map.Entry<String, String> e : env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                DefaultEnvEntry ee = new DefaultEnvEntry(k, v);
                if (this.getEnvFilter() != null && !this.getEnvFilter().test(ee)) continue;
                if (this.getEnvReplacer() != null) {
                    String v2 = this.getEnvReplacer().apply(ee);
                    if (v2 == null) continue;
                    v = v2;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(DefaultNExecCmdFormat.enforceDoubleQuote(k)).append("=").append(DefaultNExecCmdFormat.enforceDoubleQuote(v));
            }
        }
        for (int i = 0; i < command.size(); ++i) {
            String s = command.get(i);
            if (s == null) {
                s = "";
            }
            DefaultArgEntry aa = new DefaultArgEntry(i, s);
            if (this.getArgumentFilter() != null && !this.getArgumentFilter().test(aa)) continue;
            if (this.getArgumentReplacer() != null) {
                String y = this.getArgumentReplacer().apply(aa);
                if (y == null) continue;
                s = y;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(DefaultNExecCmdFormat.enforceDoubleQuote(s));
        }
        if (this.isRedirectError()) {
            if (_out != null) {
                if (this.isRedirectOutput()) {
                    sb.append(" > ").append("{stream}");
                }
                if (this.isRedirectError()) {
                    sb.append(" 2>&1");
                }
            }
            if (in != null && this.isRedirectInput()) {
                sb.append(" < ").append("{stream}");
            }
        } else {
            if (_out != null && this.isRedirectOutput()) {
                sb.append(" > ").append("{stream}");
            }
            if (err != null && this.isRedirectError()) {
                sb.append(" 2> ").append("{stream}");
            }
            if (in != null && this.isRedirectInput()) {
                sb.append(" < ").append("{stream}");
            }
        }
        out.print(sb.toString());
    }

    private static String enforceDoubleQuote(String s) {
        if (s.isEmpty() || s.contains(" ") || s.contains("\"")) {
            s = "\"" + s.replace("\"", "\\\"") + "\"";
        }
        return s;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    private static class DefaultEnvEntry
    implements NExecCmdFormat.EnvEntry {
        private String name;
        private String value;

        public DefaultEnvEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private static class DefaultArgEntry
    implements NExecCmdFormat.ArgEntry {
        private int index;
        private String value;

        public DefaultArgEntry(int index, String value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

