/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NCmdExecOptions;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableInformation;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NCmdLineUtils;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNInstallInfo;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.executor.ArtifactExecutorComponent;
import net.thevpc.nuts.runtime.standalone.executor.NExecutionContextUtils;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.URLBuilder;
import net.thevpc.nuts.runtime.standalone.io.util.ZipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.bundle.DefaultNBundleInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.DefaultNDeployInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.CharacterizedExecFile;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultUnknownExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.alias.DefaultNAliasExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.artifact.DefaultNArtifactExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.DefaultInternalNExecutableCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.NInternalCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.open.DefaultNOpenExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.path.DefaultNArtifactPathExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.system.DefaultNSystemExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.remote.ssh.artifact.DefaultSpawnExecutableNutsRemote;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.remote.ssh.system.DefaultNSystemExecutableRemote;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.DefaultNFetchInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.help.DefaultNHelpInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.info.DefaultNInfoInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.DefaultNInstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.DefaultNReinstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.license.DefaultNLicenseInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.prepare.DefaultNPrepareInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.push.DefaultNPushInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNSearchInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.DefaultNSettingsInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy.DefaultNUndeployInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall.DefaultNUninstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNCheckUpdatesInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNUpdateInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.version.DefaultNVersionInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.welcome.DefaultNWelcomeInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.which.DefaultNWhichInternalExecutable;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NDependencySolver;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NTooManyElementsException;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class DefaultNExecCmd
extends AbstractNExecCmd {
    public DefaultNExecCmd(NWorkspace workspace) {
    }

    private void refactorCommand() {
        if (this.getCommandDefinition() != null) {
            return;
        }
        boolean someUpdates = true;
        while (someUpdates) {
            someUpdates = false;
            ArrayList<String> command0 = new ArrayList<String>(this.getCommand());
            if (command0.isEmpty()) continue;
            String cmd = (String)command0.get(0);
            if ("exec".equals(cmd)) {
                NCmdLine cmdLine = NCmdLine.of(command0);
                cmdLine.skip();
                this.setCommand(new ArrayList<String>());
                while (cmdLine.hasNext()) {
                    this.configureLast(cmdLine);
                }
                someUpdates = true;
                continue;
            }
            if ("-".equals(cmd)) {
                ArrayList<String> newCmd = new ArrayList<String>();
                newCmd.add("net.thevpc.nsh:nsh");
                command0.remove(0);
                if (!command0.isEmpty()) {
                    newCmd.add("-c");
                    newCmd.addAll(command0);
                }
                this.setCommand(newCmd);
                someUpdates = true;
                continue;
            }
            if (!NArg.of(cmd).isOption()) continue;
            ArrayList<String> aa = new ArrayList<String>();
            aa.add("exec");
            aa.addAll(command0);
            this.setCommand(aa);
            someUpdates = true;
        }
    }

    @Override
    public NExecutableInformation which() {
        NSession session = NSession.of();
        this.refactorCommand();
        NExecutableInformationExt exec = null;
        NExecutionType executionType = this.getExecutionType();
        NRunAs runAs = this.getRunAs();
        if (executionType == null) {
            executionType = session.getExecutionType().orDefault();
        }
        if (executionType == null) {
            executionType = NExecutionType.SPAWN;
        }
        switch (executionType) {
            case OPEN: {
                NAssert.requireNonNull(this.getCommandDefinition(), "artifact definition");
                NAssert.requireNonBlank(this.command, "command");
                NConnectionString connectionString = this.getConnectionString();
                if (!NBlankable.isBlank(connectionString)) {
                    throw new NIllegalArgumentException(NMsg.ofC("cannot run %s command remotely", executionType));
                }
                String[] ts = this.command.toArray(new String[0]);
                exec = new DefaultNOpenExecutable(ts, this.getExecutorOptions().toArray(new String[0]), (NExecCmd)this);
                break;
            }
            case SYSTEM: {
                Path p;
                RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                if (remoteInfo0 != null) {
                    NExecutionType finalExecutionType = executionType;
                    NAssert.requireNull((Object)this.getCommandDefinition(), () -> NMsg.ofC("unable to run artifact as %s cmd", finalExecutionType));
                    NAssert.requireNonBlank(this.command, "command");
                    String[] ts = this.command.toArray(new String[0]);
                    return new DefaultNSystemExecutableRemote(remoteInfo0.commExec, ts, this.getExecutorOptions(), this, remoteInfo0.in0, remoteInfo0.out0, remoteInfo0.err0);
                }
                NExecutionType finalExecutionType = executionType;
                NAssert.requireNull((Object)this.getCommandDefinition(), () -> NMsg.ofC("unable to run artifact as %s cmd", finalExecutionType));
                NAssert.requireNonBlank(this.command, "command");
                String[] ts = this.command.toArray(new String[0]);
                ArrayList<String> tsl = new ArrayList<String>(Arrays.asList(ts));
                if (NStringUtils.firstIndexOf(ts[0], '/', '\\') < 0 && (p = NSysExecUtils.sysWhich(ts[0])) != null) {
                    tsl.set(0, p.toString());
                }
                exec = new DefaultNSystemExecutable(tsl.toArray(new String[0]), this.getExecutorOptions(), (NExecCmd)this);
                break;
            }
            case SPAWN: 
            case EMBEDDED: {
                if (this.getCommandDefinition() != null) {
                    RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                    if (remoteInfo0 != null) {
                        String[] ts = this.command == null ? new String[]{} : this.command.toArray(new String[0]);
                        return new DefaultSpawnExecutableNutsRemote(remoteInfo0.commExec, this.getCommandDefinition(), this.getCommandDefinition().getId().toString(), NCmdLine.of(ts).toString(), ts, this.getExecutorOptions(), this, remoteInfo0.in0, remoteInfo0.out0, remoteInfo0.err0);
                    }
                    String[] ts = this.command == null ? new String[]{} : this.command.toArray(new String[0]);
                    return this.ws_execDef(this.getCommandDefinition(), this.getCommandDefinition().getId().getLongName(), ts, this.getExecutorOptions(), this.workspaceOptions, this.env, this.directory, this.failFast, executionType, runAs);
                }
                NAssert.requireNonBlank(this.command, "command");
                String[] ts = this.command.toArray(new String[0]);
                exec = this.execEmbeddedOrExternal(ts, this.getExecutorOptions(), this.getWorkspaceOptions(), session);
                break;
            }
            default: {
                throw new NUnsupportedArgumentException(NMsg.ofC("invalid execution type %s", executionType));
            }
        }
        return exec;
    }

    private void runLoop(NExecutableInformationExt exec) {
        int count = 0;
        NExecutionException err = null;
        while (true) {
            err = null;
            try {
                this.runOnce(exec);
            }
            catch (NExecutionException e) {
                err = e;
            }
            if (this.multipleRunsMaxCount >= 0 && ++count >= this.multipleRunsMaxCount || this.executionTime.toMillis() <= this.multipleRunsMinTimeMs) break;
            if (this.multipleRunsSafeTimeMs <= 0L) continue;
            NWorkspaceProfilerImpl.sleep(this.multipleRunsSafeTimeMs, "DefaultNExecCmd::runLoop");
        }
        if (err != null) {
            throw err;
        }
    }

    private void runOnceOrMultiple(NExecutableInformationExt exec) {
        if (this.multipleRuns || !NBlankable.isBlank(this.multipleRunsCron)) {
            if (NBlankable.isBlank(this.multipleRunsCron)) {
                this.runLoop(exec);
            } else if (this.multipleRuns) {
                this.runLoop(exec);
            } else {
                this.runOnce(exec);
            }
        } else {
            this.runOnce(exec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce(NExecutableInformationExt exec) {
        this.executed = true;
        this.executionTime = null;
        NChronometer chrono = NChronometer.startNow();
        try {
            int exitCode;
            block8: {
                exitCode = 0;
                try {
                    exitCode = exec.execute();
                }
                catch (NExecutionException ex) {
                    String p = this.getExtraErrorMessage();
                    this.resultException = p != null ? new NExecutionException(NMsg.ofC("execution failed with code %s and message : %s", ex.getExitCode(), p), ex, ex.getExitCode()) : ex;
                }
                catch (Exception ex) {
                    String p = this.getExtraErrorMessage();
                    int exceptionExitCode = NExceptions.resolveExitCode(ex).orElse(255);
                    if (exceptionExitCode == 0) break block8;
                    this.resultException = !NBlankable.isBlank(p) ? new NExecutionException(NMsg.ofC("execution of (%s) failed with code %s ; error was : %s ; notes : %s", exec, exceptionExitCode, ex, p), ex, exceptionExitCode) : new NExecutionException(NMsg.ofC("execution of (%s) failed with code %s ; error was : %s", exec, exceptionExitCode, ex), ex, exceptionExitCode);
                }
            }
            if (this.resultException == null && exitCode != 0) {
                this.resultException = new NExecutionException(NMsg.ofC("execution of (%s) failed with code %s", exec, exitCode), exitCode);
            }
            if (this.resultException != null && this.resultException.getExitCode() != 0 && this.failFast) {
                throw this.resultException;
            }
        }
        finally {
            chrono.stop();
            this.executionTime = chrono.getDuration();
        }
    }

    @Override
    public NExecCmd run() {
        try (NExecutableInformationExt exec = (NExecutableInformationExt)this.which();){
            this.runOnceOrMultiple(exec);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NExecutableInformationExt execEmbeddedOrExternal(String[] cmd, List<String> executorOptions, List<String> workspaceOptions, NSession prepareSession) {
        NSession session = NSession.of();
        NAssert.requireNonBlank(cmd, "command");
        String[] args = new String[cmd.length - 1];
        System.arraycopy(cmd, 1, args, 0, args.length);
        String cmdName = cmd[0];
        NExecutionType executionType = this.getExecutionType();
        if (executionType == null) {
            executionType = session.getExecutionType().orDefault();
        }
        if (executionType == null) {
            executionType = NExecutionType.SPAWN;
        }
        NRunAs runAs = this.getRunAs();
        CmdKind cmdKind = null;
        NId goodId = null;
        String goodKw = null;
        boolean forceInstalled = false;
        if (cmdName.endsWith("!")) {
            goodId = NId.get(cmdName.substring(0, cmdName.length() - 1)).orNull();
            if (goodId != null) {
                forceInstalled = true;
            }
        } else {
            goodId = NId.get(cmdName).orNull();
        }
        if (cmdName.equalsIgnoreCase(".") || cmdName.equals("..")) {
            cmdKind = CmdKind.PATH;
        } else if (cmdName.contains("/") || cmdName.contains("\\")) {
            cmdKind = goodId != null ? CmdKind.ID : CmdKind.PATH;
        } else if (cmdName.contains(":") || cmdName.contains("#")) {
            if (goodId == null) throw new NArtifactNotFoundException(null, NMsg.ofC("unable to resolve id %s", cmdName));
            cmdKind = CmdKind.ID;
        } else {
            if (cmdName.endsWith("!")) {
                goodKw = cmdName.substring(0, cmdName.length() - 1);
                forceInstalled = true;
            } else {
                goodKw = cmdName;
            }
            cmdKind = CmdKind.KEYWORD;
        }
        switch (cmdKind.ordinal()) {
            case 0: {
                ArrayList<String> cmdArr;
                RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                if (remoteInfo0 != null) {
                    NAssert.requireNonBlank(this.command, "command");
                    ArrayList<String> ts = new ArrayList<String>(this.command);
                    return new DefaultSpawnExecutableNutsRemote(remoteInfo0.commExec, null, !ts.isEmpty() ? (String)ts.get(0) : "", !NBlankable.isBlank(this.getConnectionString()) && ts.size() == 1 ? (String)ts.get(0) : NCmdLine.of(ts).toString(), ts.toArray(new String[0]), this.getExecutorOptions(), this, remoteInfo0.in0, remoteInfo0.out0, remoteInfo0.err0);
                }
                CharacterizedExecFile c = null;
                NPath path = null;
                try {
                    path = NPath.of(cmdName);
                    c = DefaultNExecCmd.characterizeForExec(path, executorOptions);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (c != null) {
                    NDescriptor descriptor = c.getDescriptor();
                    if (descriptor != null) {
                        try {
                            descriptor = NWorkspace.of().resolveEffectiveDescriptor(descriptor, new NDescriptorEffectiveConfig().setIgnoreCurrentEnvironment(true));
                        }
                        catch (NArtifactNotFoundException ex) {
                            this._LOG().log(NMsg.ofC("executable artifact descriptor found, but one of its parents or dependencies is not: %s : missing %s", descriptor.getId(), ex.getId()).asWarningAlert());
                            throw ex;
                        }
                        NId _id = descriptor.getId();
                        NDefinitionBuilder nutToRun = new DefaultNDefinitionBuilder().setId(_id.getLongId()).setDependency(_id.toDependency()).setDescriptor(descriptor).setContent(NPath.of(c.getContentFile()).setUserCache(false).setUserTemporary(!c.getTemps().isEmpty())).setInstallInformation(DefaultNInstallInfo.notInstalled(_id));
                        NDependencySolver resolver = NDependencySolver.of();
                        NDependencyFilters ff = NDependencyFilters.of();
                        resolver.setRepositoryFilter(null).setDependencyFilter(ff.byScope(NDependencyScopePattern.RUN));
                        for (NDependency dependency : descriptor.getDependencies()) {
                            resolver.add(dependency);
                        }
                        nutToRun.setDependencies(resolver.solve());
                        NDefinition nd = nutToRun.build();
                        try {
                            NExecutorComponentAndContext ec = this.ws_execId2(nd, cmdName, args, executorOptions, workspaceOptions, this.getEnv(), this.getDirectory(), this.isFailFast(), true, this.getIn(), this.getOut(), this.getErr(), executionType, runAs);
                            return new DefaultNArtifactPathExecutable(cmdName, args, executorOptions, workspaceOptions, executionType, runAs, this, nd, c, null, ec);
                        }
                        catch (Exception ex) {
                            c.close();
                        }
                    } else {
                        c.close();
                    }
                }
                if (path == null) throw new NArtifactNotFoundException(goodId, NMsg.ofC("unable to resolve id %s", path));
                if (path.isLocal() && path.isRegularFile()) {
                    cmdArr = new ArrayList();
                    cmdArr.add(cmdName);
                    cmdArr.addAll(Arrays.asList(args));
                    return new DefaultNSystemExecutable(cmdArr.toArray(new String[0]), executorOptions, (NExecCmd)this);
                }
                cmdArr = new ArrayList<String>();
                cmdArr.add(cmdName);
                cmdArr.addAll(Arrays.asList(args));
                return new DefaultUnknownExecutable(cmdArr.toArray(new String[0]), this);
            }
            case 1: {
                NId idToExec = this.findExecId(goodId, prepareSession, forceInstalled, true);
                RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                if (remoteInfo0 != null) {
                    NAssert.requireNonBlank(this.command, "command");
                    ArrayList<String> ts = new ArrayList<String>(this.command);
                    if (ts.isEmpty()) {
                        throw new NUnsupportedArgumentException(NMsg.ofPlain("missing command"));
                    }
                    String id = (String)ts.get(0);
                    ts.remove(0);
                    NDefinition def2 = NSearchCmd.of().addId(id).latest().setDependencyFilter(NDependencyFilters.of().byRunnable()).failFast().getResultDefinitions().findFirst().get();
                    return new DefaultSpawnExecutableNutsRemote(remoteInfo0.commExec, def2, id, NCmdLine.of(ts).toString(), ts.toArray(new String[0]), this.getExecutorOptions(), this, remoteInfo0.in0, remoteInfo0.out0, remoteInfo0.err0);
                }
                if (idToExec == null) throw new NArtifactNotFoundException(goodId.getLongId());
                return this.ws_execId(idToExec, cmdName, args, executorOptions, workspaceOptions, executionType, runAs);
            }
            case 2: {
                Map<String, NInternalCommand> internalCommands = NWorkspaceExt.of().getCommandModel().getInternalCommands();
                NInternalCommand ic = internalCommands.get(goodKw);
                if (ic != null) {
                    RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                    if (remoteInfo0 == null) return new DefaultInternalNExecutableCommand(ic, args, (NExecCmd)this);
                    return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                }
                switch (goodKw) {
                    case "update": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNUpdateInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "check-updates": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNCheckUpdatesInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "install": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNInstallInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "reinstall": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNReinstallInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "uninstall": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNUninstallInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "deploy": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNDeployInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "undeploy": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNUndeployInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "push": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNPushInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "fetch": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNFetchInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "search": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNSearchInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "version": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNVersionInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "prepare": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNPrepareInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "license": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNLicenseInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "bundle": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNBundleInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "help": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNHelpInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "welcome": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNWelcomeInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "info": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNInfoInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "which": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNWhichInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "exec": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNExecInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                    case "settings": {
                        RemoteInfo0 remoteInfo0 = this.resolveRemoteInfo0();
                        if (remoteInfo0 == null) return new DefaultNSettingsInternalExecutable(args, this);
                        return this._runRemoteInternalCommand(goodKw, remoteInfo0);
                    }
                }
                Object remoteInfo0 = this.resolveRemoteInfo0();
                if (remoteInfo0 != null) {
                    NExecutionType finalExecutionType = executionType;
                    NAssert.requireNull((Object)this.getCommandDefinition(), () -> NMsg.ofC("unable to run artifact as %s cmd", finalExecutionType));
                    NAssert.requireNonBlank(this.command, "command");
                    String[] ts = this.command.toArray(new String[0]);
                    return new DefaultNSystemExecutableRemote(((RemoteInfo0)remoteInfo0).commExec, ts, this.getExecutorOptions(), this, ((RemoteInfo0)remoteInfo0).in0, ((RemoteInfo0)remoteInfo0).out0, ((RemoteInfo0)remoteInfo0).err0);
                }
                NCustomCmd command = null;
                command = NWorkspace.of().findCommand(goodKw);
                if (command != null) {
                    NCmdExecOptions o = new NCmdExecOptions().setExecutorOptions(executorOptions).setDirectory(this.directory).setFailFast(this.failFast).setExecutionType(executionType).setEnv(this.env);
                    return new DefaultNAliasExecutable(command, o, args, (NExecCmd)this);
                }
                NId idToExec = null;
                if (goodId != null) {
                    idToExec = this.findExecId(goodId, prepareSession, forceInstalled, true);
                }
                if (idToExec != null) return this.ws_execId(idToExec, cmdName, args, executorOptions, workspaceOptions, executionType, runAs);
                Path sw = NSysExecUtils.sysWhich(cmdName);
                if (sw != null) {
                    ArrayList<String> cmdArr = new ArrayList<String>();
                    cmdArr.add(sw.toString());
                    cmdArr.addAll(Arrays.asList(args));
                    return new DefaultNSystemExecutable(cmdArr.toArray(new String[0]), executorOptions, (NExecCmd)this);
                }
                ArrayList<String> cmdArr = new ArrayList<String>();
                cmdArr.add(cmdName);
                cmdArr.addAll(Arrays.asList(args));
                return new DefaultUnknownExecutable(cmdArr.toArray(new String[0]), this);
            }
        }
        throw new NArtifactNotFoundException(goodId, NMsg.ofC("unable to resolve id %s", cmdName));
    }

    private NExecutableInformationExt _runRemoteInternalCommand(String goodKw, RemoteInfo0 remoteInfo0) {
        return new DefaultSpawnExecutableNutsRemote(remoteInfo0.commExec, null, goodKw, NCmdLine.of(this.command).toString(), this.command.toArray(new String[0]), this.getExecutorOptions(), this, remoteInfo0.in0, remoteInfo0.out0, remoteInfo0.err0);
    }

    protected NId findExecId(NId nid, NSession traceSession, boolean forceInstalled, boolean ignoreIfUserCommand) {
        if (nid == null) {
            return null;
        }
        switch (NStringUtils.firstNonNull(nid.getShortName(), "")) {
            case "nuts-app": {
                nid = nid.builder().setGroupId("net.thevpc.nuts").build();
                break;
            }
            case "net.thevpc.nuts:nuts": 
            case "net.thevpc.nuts:nuts-runtime": 
            case "nuts": 
            case "nuts-runtime": 
            case "net.thevpc.nuts:nuts-boot": 
            case "nuts-boot": 
            case "net.thevpc.nuts:nuts-lib": 
            case "nuts-lib": {
                throw new NArtifactNotFoundException(nid, NMsg.ofC("%s is not executable", nid));
            }
        }
        if ("nuts-app".equals(nid.getShortName())) {
            nid = nid.builder().setGroupId("net.thevpc.nuts").build();
        }
        NSession.of().getTerminal().printProgress(NMsg.ofC("start searching for %s", nid));
        NId ff = NSearchCmd.of(nid).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).setFailFast(false).setDefinitionFilter(NDefinitionFilters.of().byDeployed(true)).getResultDefinitions().stream().sorted(Comparator.comparing(x -> !x.getInstallInformation().get().isDefaultVersion())).map(NDefinition::getId).findFirst().orElse(null);
        if (ff == null && !forceInstalled) {
            if (ignoreIfUserCommand && NWorkspace.of().findSysCommand(nid.toString()).isPresent()) {
                return null;
            }
            if (traceSession.isPlainTrace()) {
                traceSession.out().resetLine().println(NMsg.ofC("%s is %s, will search for it...", nid, NText.ofStyledError("not installed")));
                traceSession.out().flush();
            }
            if ((ff = (NId)NSearchCmd.of(nid).setFetchStrategy(NFetchStrategy.OFFLINE).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFailFast(false).setLatest(true).getResultIds().findFirst().orElse(null)) == null && NSession.of().getFetchStrategy().orElse(NFetchStrategy.ONLINE) != NFetchStrategy.OFFLINE) {
                if (traceSession.isPlainTrace()) {
                    traceSession.out().resetLine().println(NMsg.ofC("%s is %s, will search for it online. Type %s to stop...", nid, NText.ofStyledError("not installed"), NText.ofStyledError("CTRL^C")));
                    traceSession.out().flush();
                }
                ff = NSearchCmd.of(nid).setFetchStrategy(NFetchStrategy.ONLINE).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFailFast(false).setLatest(true).getResultIds().findFirst().orElse(null);
            }
        }
        if (ff == null) {
            return null;
        }
        return ff;
    }

    public boolean isUserCommand(String s) {
        return NWorkspace.of().findSysCommand(s).isPresent();
    }

    protected NExecutableInformationExt ws_execId(NId goodId, String commandName, String[] appArgs, List<String> executorOptions, List<String> workspaceOptions, NExecutionType executionType, NRunAs runAs) {
        NDefinition def = null;
        try {
            def = NFetchCmd.of(goodId).failFast().setDependencyFilter(NDependencyFilters.of().byRunnable()).setRepositoryFilter(NRepositoryFilters.of().installedRepo()).getResultDefinition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (def == null) {
            def = NFetchCmd.of(goodId).failFast().setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
        }
        return this.ws_execDef(def, commandName, appArgs, executorOptions, this.workspaceOptions, this.env, this.directory, this.failFast, executionType, runAs);
    }

    protected NExecutableInformationExt ws_execDef(NDefinition def, String commandName, String[] appArgs, List<String> executorOptions, List<String> workspaceOptions, Map<String, String> env, NPath dir, boolean failFast, NExecutionType executionType, NRunAs runAs) {
        return new DefaultNArtifactExecutable(def, commandName, appArgs, executorOptions, workspaceOptions, env, dir, failFast, executionType, runAs, this);
    }

    public int ws_execId(NDefinition def, String commandName, String[] appArgs, List<String> executorOptions, List<String> workspaceOptions, Map<String, String> env, NPath dir, boolean failFast, boolean temporary, NExecInput in, NExecOutput out, NExecOutput err, NExecutionType executionType, NRunAs runAs) {
        NExecutorComponentAndContext e = this.ws_execId2(def, commandName, appArgs, executorOptions, workspaceOptions, env, dir, failFast, temporary, in, out, err, executionType, runAs);
        return e.component.exec(e.executionContext);
    }

    public NExecutorComponentAndContext ws_execId2(NDefinition def, String commandName, String[] appArgs, List<String> executorOptions, List<String> workspaceOptions, Map<String, String> env, NPath dir, boolean failFast, boolean temporary, NExecInput in, NExecOutput out, NExecOutput err, NExecutionType executionType, NRunAs runAs) {
        NSession session = NSession.of();
        NWorkspaceSecurityManager.of().checkAllowed("exec", commandName);
        if (def != null && def.getContent().isPresent()) {
            Object eid;
            NDescriptor descriptor = def.getDescriptor();
            if (!descriptor.isExecutable()) {
                // empty if block
            }
            NArtifactCall executorCall = descriptor.getExecutor();
            NExecutorComponent execComponent = null;
            ArrayList<String> executorArgs = new ArrayList<String>();
            if (executorCall != null && (eid = executorCall.getId()) != null) {
                if (eid.getGroupId() == null) {
                    if (eid.getArtifactId().equals("nuts")) {
                        eid = eid.builder().setGroupId("net.thevpc.nuts").build();
                    } else if (eid.getArtifactId().equals("nsh")) {
                        eid = eid.builder().setGroupId("net.thevpc.nsh").build();
                    }
                }
                if (eid.getGroupId() != null) {
                    NStream<NDefinition> q = NSearchCmd.of().addId((NId)eid).setLatest(true).setDistinct(true).getResultDefinitions();
                    NDefinition[] availableExecutors = (NDefinition[])q.stream().limit(2L).toArray(NDefinition[]::new);
                    if (availableExecutors.length > 1) {
                        throw new NTooManyElementsException(NMsg.ofC("too many results for executor %s", eid));
                    }
                    if (availableExecutors.length == 1) {
                        execComponent = new ArtifactExecutorComponent(availableExecutors[0].getId());
                    } else {
                        throw new NArtifactNotFoundException((NId)eid, NMsg.ofC("executor not found %s", eid));
                    }
                }
            }
            if (execComponent == null) {
                execComponent = NExtensions.of().createComponent(NExecutorComponent.class, def).get();
            }
            if (executorCall != null) {
                for (String argument : executorCall.getArguments()) {
                    executorArgs.add(StringPlaceHolderParser.replaceDollarPlaceHolders(argument, def, NExecutionContextUtils.DEFINITION_PLACEHOLDER));
                }
            }
            NCmdLineUtils.OptionsAndArgs optionsAndArgs = NCmdLineUtils.parseOptionsFirst(executorArgs.toArray(new String[0]));
            executorArgs.clear();
            executorArgs.addAll(Arrays.asList(optionsAndArgs.getOptions()));
            executorArgs.addAll(executorOptions);
            executorArgs.addAll(Arrays.asList(optionsAndArgs.getArgs()));
            NExecutionContextBuilder ecb = NWorkspaceExt.of().createExecutionContext();
            NExecutionContext executionContext = ecb.setDefinition(def).setArguments(appArgs).setExecutorOptions(executorArgs.toArray(new String[0])).setWorkspaceOptions(workspaceOptions).setEnv(env).setDirectory(dir).setFailFast(failFast).setTemporary(temporary).setExecutionType(executionType).setRunAs(runAs).setCommandName(commandName).setSleepMillis(this.getSleepMillis()).setIn(in).setOut(out).setErr(err).setDry(session.isDry()).build();
            return new NExecutorComponentAndContext(execComponent, executionContext);
        }
        throw new NArtifactNotFoundException(def == null ? null : def.getId().getLongId());
    }

    public static CharacterizedExecFile characterizeForExec(NInputSource contentFile, List<String> execOptions) {
        CharacterizedExecFile c;
        block28: {
            String classifier = null;
            c = new CharacterizedExecFile();
            try {
                c.setStreamOrPath(contentFile);
                c.setContentFile(CoreIOUtils.toPathInputSource(contentFile, c.getTemps(), true));
                Path fileSource = c.getContentFile();
                if (!Files.exists(fileSource, new LinkOption[0])) {
                    throw new NIllegalArgumentException(NMsg.ofC("file does not exists %s", fileSource));
                }
                if (Files.isDirectory(fileSource, new LinkOption[0])) {
                    Path ext = fileSource.resolve("nuts.json");
                    if (Files.exists(ext, new LinkOption[0])) {
                        c.setDescriptor(NDescriptorParser.of().parse(ext).get());
                    } else {
                        c.setDescriptor(NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.getContentFile(), execOptions));
                    }
                    if (c.getDescriptor() == null) break block28;
                    if ("zip".equals(c.getDescriptor().getPackaging())) {
                        Path zipFilePath = NPath.of(fileSource + ".zip").toAbsolute().toPath().get();
                        ZipUtils.zip(fileSource.toString(), new ZipOptions(), zipFilePath.toString());
                        c.setContentFile(zipFilePath);
                        c.addTemp(zipFilePath);
                        break block28;
                    }
                    throw new NIllegalArgumentException(NMsg.ofPlain("invalid nuts folder source. expected 'zip' ext in descriptor"));
                }
                if (Files.isRegularFile(fileSource, new LinkOption[0])) {
                    if (c.getContentFile().getFileName().toString().endsWith("nuts.json")) {
                        try (InputStream in = Files.newInputStream(c.getContentFile(), new OpenOption[0]);){
                            c.setDescriptor(NDescriptorParser.of().parse(in).get());
                        }
                        c.setContentFile(null);
                        if (c.getStreamOrPath() instanceof NPath && ((NPath)c.getStreamOrPath()).isURL()) {
                            URLBuilder ub = new URLBuilder(((NPath)c.getStreamOrPath()).toURL().toString());
                            try {
                                c.setContentFile(CoreIOUtils.toPathInputSource(NPath.of(ub.resolveSibling(NWorkspace.of().getDefaultIdFilename(c.getDescriptor().getId())).toURL()), c.getTemps(), true));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (c.getContentFile() == null) {
                            for (NIdLocation location0 : c.getDescriptor().getLocations()) {
                                if (!CoreFilterUtils.acceptClassifier(location0, classifier)) continue;
                                String location = location0.getUrl();
                                if (NPath.of(location).isHttp()) {
                                    try {
                                        c.setContentFile(CoreIOUtils.toPathInputSource(NPath.of(CoreIOUtils.urlOf(location)), c.getTemps(), true));
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                } else {
                                    URLBuilder ub = new URLBuilder(((NPath)c.getStreamOrPath()).toURL().toString());
                                    try {
                                        c.setContentFile(CoreIOUtils.toPathInputSource(NPath.of(ub.resolveSibling(NWorkspace.of().getDefaultIdFilename(c.getDescriptor().getId())).toURL()), c.getTemps(), true));
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (c.getContentFile() != null) continue;
                                break;
                            }
                        }
                        if (c.getContentFile() == null) {
                            throw new NIllegalArgumentException(NMsg.ofC("unable to locale package for %s", c.getStreamOrPath()));
                        }
                        break block28;
                    }
                    c.setDescriptor(NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.getContentFile(), execOptions));
                    if (c.getDescriptor() == null) {
                        CoreDigestHelper d = new CoreDigestHelper();
                        d.append(c.getContentFile());
                        String artifactId = d.getDigest();
                        c.setDescriptor(new DefaultNDescriptorBuilder().setId("temp:" + artifactId + "#1.0").setPackaging(NIOUtils.getFileExtension(contentFile.getMetaData().getName().orElse(""))).build());
                    }
                    break block28;
                }
                throw new NIllegalArgumentException(NMsg.ofC("path does not denote a valid file or folder %s", c.getStreamOrPath()));
            }
            catch (IOException | UncheckedIOException ex) {
                throw new NIOException(ex);
            }
        }
        return c;
    }

    private RemoteInfo0 resolveRemoteInfo0() {
        NConnectionString connectionString = this.getConnectionString();
        if (!NBlankable.isBlank(connectionString)) {
            if ("ssh".equals(connectionString.getProtocol())) {
                NExtensions.of().loadExtension(NId.get("net.thevpc.nuts:nuts-ssh").get());
            }
            if ("nagent".equals(connectionString.getProtocol())) {
                NExtensions.of().loadExtension(NId.get("com.cts.nuts.enterprise:next-agent").get());
            }
            RemoteInfo0 ii = new RemoteInfo0();
            ii.commExec = NExtensions.of().createComponent(NExecTargetSPI.class, connectionString).orElseThrow(() -> new NIllegalArgumentException(NMsg.ofC("invalid execution target string : %s", connectionString)));
            ii.in0 = CoreIOUtils.validateIn(this.in);
            ii.out0 = CoreIOUtils.validateOut(this.out);
            ii.err0 = CoreIOUtils.validateOut(this.err);
            return ii;
        }
        return null;
    }

    private static class RemoteInfo0 {
        NExecTargetSPI commExec;
        NExecInput in0;
        NExecOutput out0;
        NExecOutput err0;

        private RemoteInfo0() {
        }
    }

    static enum CmdKind {
        PATH,
        ID,
        KEYWORD;

    }

    public static class NExecutorComponentAndContext {
        NExecutorComponent component;
        NExecutionContext executionContext;

        public NExecutorComponentAndContext(NExecutorComponent component, NExecutionContext executionContext) {
            this.component = component;
            this.executionContext = executionContext;
        }

        public NExecutorComponent getComponent() {
            return this.component;
        }

        public NExecutionContext getExecutionContext() {
            return this.executionContext;
        }
    }
}

