/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;

public class CharacterizedExecFile
implements AutoCloseable {
    private Path contentFile;
    private NInputSource streamOrPath;
    private List<Path> temps = new ArrayList<Path>();
    private NDescriptor descriptor;
    private NId executor;

    public void addTemp(Path f) {
        this.temps.add(f);
    }

    public Path getContentFile() {
        return this.contentFile;
    }

    public CharacterizedExecFile setContentFile(Path contentFile) {
        this.contentFile = contentFile;
        return this;
    }

    public NInputSource getStreamOrPath() {
        return this.streamOrPath;
    }

    public CharacterizedExecFile setStreamOrPath(NInputSource streamOrPath) {
        this.streamOrPath = streamOrPath;
        return this;
    }

    public List<Path> getTemps() {
        return this.temps;
    }

    public CharacterizedExecFile setTemps(List<Path> temps) {
        this.temps = temps;
        return this;
    }

    public NDescriptor getDescriptor() {
        return this.descriptor;
    }

    public CharacterizedExecFile setDescriptor(NDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public NId getExecutor() {
        return this.executor;
    }

    public CharacterizedExecFile setExecutor(NId executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public void close() {
        Iterator<Path> it = this.temps.iterator();
        while (it.hasNext()) {
            Path temp = it.next();
            try {
                Files.delete(temp);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            it.remove();
        }
    }
}

