/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd;

import java.time.Instant;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspaceCmd;
import net.thevpc.nuts.runtime.standalone.dependency.NDependencyFilterUtils;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public abstract class DefaultNQueryBaseOptions<T extends NWorkspaceCmd>
extends NWorkspaceCmdBase<T> {
    protected NDependencyFilter dependencyFilter;
    private boolean failFast = false;
    private boolean inlineDependencies = false;
    private NFetchDisplayOptions displayOptions = new NFetchDisplayOptions();
    private NRepositoryFilter repositoryFilter;
    private NFetchStrategy fetchStrategy;
    private Boolean transitive;
    private Instant expireTime;

    public DefaultNQueryBaseOptions(String name) {
        super(name);
        NSession s = NSession.of();
        this.fetchStrategy = s.getFetchStrategy().orNull();
        this.transitive = s.getTransitive().orNull();
        this.expireTime = s.getExpireTime().orNull();
    }

    public T copyFromDefaultNQueryBaseOptions(DefaultNQueryBaseOptions other) {
        if (other != null) {
            super.copyFromWorkspaceCommandBase(other);
            this.failFast = other.isFailFast();
            this.inlineDependencies = other.isInlineDependencies();
            this.dependencyFilter = other.getDependencyFilter();
            this.repositoryFilter = other.getRepositoryFilter();
            this.fetchStrategy = other.getFetchStrategy().orNull();
            this.transitive = other.getTransitive().orNull();
            this.expireTime = other.getExpireTime().orNull();
        }
        return (T)this;
    }

    public NOptional<Instant> getExpireTime() {
        return NOptional.ofNamed(this.expireTime, "expireTime").orElseUse(() -> NSession.of().getExpireTime());
    }

    public NOptional<NFetchStrategy> getFetchStrategy() {
        return NOptional.ofNamed(this.fetchStrategy, "fetchStrategy").orElseUse(() -> NSession.of().getFetchStrategy());
    }

    public NOptional<Boolean> getTransitive() {
        return NOptional.ofNamed(this.transitive, "transitive").orElseUse(() -> NSession.of().getTransitive());
    }

    public T setFetchStrategy(NFetchStrategy fetchStrategy) {
        this.fetchStrategy = fetchStrategy;
        return (T)this;
    }

    public T setTransitive(Boolean transitive) {
        this.transitive = transitive;
        return (T)this;
    }

    public T setExpireTime(Instant transitive) {
        this.expireTime = this.expireTime;
        return (T)this;
    }

    public boolean isInlineDependencies() {
        return this.inlineDependencies;
    }

    public T setInlineDependencies(boolean include) {
        this.inlineDependencies = include;
        return (T)this;
    }

    public T failFast() {
        this.setFailFast(true);
        return (T)this;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public T setFailFast(boolean enable) {
        this.failFast = enable;
        return (T)this;
    }

    public NFetchDisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (this.getDisplayOptions().configureFirst(cmdLine)) {
            return true;
        }
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        switch (a.key()) {
            case "--failfast": {
                return cmdLine.matcher().matchFlag(v -> this.setFailFast(v.booleanValue())).anyMatch();
            }
            case "-r": 
            case "--repository": {
                return cmdLine.matcher().matchEntry(v -> this.addRepositoryFilter(NRepositoryFilters.of().bySelector(v.stringValue()))).anyMatch();
            }
            case "--scope": {
                return cmdLine.matcher().matchEntry(v -> NDependencyFilterUtils.addScope(this.getDependencyFilter(), NDependencyScopePattern.parse(v.stringValue()).orElse(NDependencyScopePattern.API))).anyMatch();
            }
            case "--optional": {
                return cmdLine.matcher().matchEntry(v -> this.setDependencyFilter(((NDependencyFilter)NDependencyFilters.of().nonnull(this.getDependencyFilter())).and(NDependencyFilters.of().byOptional(NLiteral.of(v.asString().get()).asBoolean().orNull())))).anyMatch();
            }
        }
        return false;
    }

    public NRepositoryFilter getRepositoryFilter() {
        return this.repositoryFilter;
    }

    public T setRepositoryFilter(NRepositoryFilter filter) {
        this.repositoryFilter = filter;
        return (T)this;
    }

    public T addRepositoryFilter(NRepositoryFilter filter) {
        if (filter != null) {
            this.repositoryFilter = this.repositoryFilter == null ? filter : this.repositoryFilter.and(filter);
        }
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(failFast=" + this.failFast + ", dependencyFilter=" + this.dependencyFilter + ", inlineDependencies=" + this.inlineDependencies + ", displayOptions=" + this.displayOptions + ')';
    }

    public T setDependencyFilter(NDependencyFilter filter) {
        this.dependencyFilter = filter;
        return (T)this;
    }

    public T addDependencyFilter(NDependencyFilter filter) {
        if (filter != null) {
            if (this.dependencyFilter == null) {
                this.dependencyFilter = filter;
            } else {
                this.dependencyFilter.and(filter);
            }
        }
        return (T)this;
    }

    public NDependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public T setDependencyFilter(String filter) {
        this.dependencyFilter = (NDependencyFilter)NDependencyFilters.of().parse(filter);
        return (T)this;
    }
}

