/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class ServerNWorkspaceArchetypeComponent
implements NWorkspaceArchetypeComponent {
    @Override
    public String getName() {
        return "server";
    }

    @Override
    public void initializeWorkspace() {
        NRepositoryLocation[] br;
        for (NRepositoryLocation s : br = NWorkspaceExt.of().getConfigModel().resolveBootRepositoriesList().resolve(new NRepositoryLocation[]{NRepositoryLocation.ofName("maven-local"), NRepositoryLocation.ofName("maven-central"), NRepositoryLocation.ofName("local")}, NRepositoryDB.of())) {
            NWorkspace.of().addRepository(s.toString());
        }
        NWorkspaceSecurityManager sec = NWorkspaceSecurityManager.of();
        sec.addUser("guest").setCredentials("user".toCharArray()).addPermissions("fetch-desc", "fetch-content", "deploy").run();
        sec = NWorkspaceSecurityManager.of();
        sec.addUser("contributor").setCredentials("user".toCharArray()).addPermissions("fetch-desc", "fetch-content", "deploy", "undeploy").run();
    }

    @Override
    public void startWorkspace() {
        NId api;
        NWorkspace workspace = NWorkspace.of();
        boolean initializeScripts = workspace.getBootOptions().getInitScripts().ifEmpty(true).get();
        boolean initializeLaunchers = workspace.getBootOptions().getInitLaunchers().ifEmpty(true).get();
        Boolean installCompanions = workspace.getBootOptions().getInstallCompanions().orElse(false);
        if ((initializeScripts || initializeLaunchers || installCompanions.booleanValue()) && (api = NFetchCmd.of().setId(workspace.getApiId()).setFailFast(false).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultId()) != null) {
            if (initializeScripts || initializeLaunchers) {
                NWorkspaceUtils.of(workspace).installScriptsAndLaunchers(initializeLaunchers);
            }
            if (installCompanions.booleanValue() && api != null) {
                NWorkspaceUtils.of(workspace).installCompanions();
            }
        }
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }
}

