/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.function.Function;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInfoCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NText;

public class NWorkspaceVarExpansionFunction
implements Function<String, String> {
    private final NWorkspace workspace;

    public static NWorkspaceVarExpansionFunction of() {
        NWorkspace ws = NWorkspace.of();
        return NApp.of().getOrComputeProperty(NWorkspaceVarExpansionFunction.class.getName(), NScopeType.SESSION, () -> new NWorkspaceVarExpansionFunction(ws));
    }

    public NWorkspaceVarExpansionFunction(NWorkspace workspace) {
        this.workspace = workspace;
    }

    private String str(Object p) {
        return p == null ? null : p.toString();
    }

    @Override
    public String apply(String from) {
        switch (from) {
            case "home.conf": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.CONF));
            }
            case "home.bin": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.BIN));
            }
            case "home.lib": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.LIB));
            }
            case "home.temp": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.TEMP));
            }
            case "home.var": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.VAR));
            }
            case "home.cache": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.CACHE));
            }
            case "home.log": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.LOG));
            }
            case "home.run": {
                return this.str(NWorkspace.of().getHomeLocation(NStoreType.RUN));
            }
            case "workspace.hash-name": {
                return this.workspace.getDigestName();
            }
            case "workspace.name": {
                return this.workspace.getName();
            }
            case "workspace.location": 
            case "workspace": {
                return this.str(NWorkspace.of().getWorkspaceLocation());
            }
            case "user.home": {
                return System.getProperty("user.home");
            }
            case "workspace.config": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.CONF));
            }
            case "workspace.lib": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.LIB));
            }
            case "workspace.apps": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.BIN));
            }
            case "workspace.cache": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.CACHE));
            }
            case "workspace.run": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.RUN));
            }
            case "workspace.temp": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.TEMP));
            }
            case "workspace.log": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.LOG));
            }
            case "workspace.var": {
                return this.str(NPath.ofWorkspaceStore(NStoreType.VAR));
            }
            case "nuts.boot.version": {
                return this.str(this.workspace.getApiVersion());
            }
            case "nuts.boot.id": 
            case "nuts.api.id": {
                return this.str(this.workspace.getApiId());
            }
            case "nuts.api.version": {
                return this.workspace.getApiId().getVersion().toString();
            }
            case "nuts.runtime.id": {
                return this.str(this.workspace.getRuntimeId());
            }
            case "nuts.runtime.artifact": 
            case "nuts.runtime.artifactId": {
                return this.str(this.workspace.getRuntimeId());
            }
            case "nuts.runtime.version": {
                return this.str(this.workspace.getRuntimeId().getVersion());
            }
            case "nuts.workspace-boot.version": {
                return this.str(Nuts.getVersion());
            }
            case "nuts.workspace-boot.id": {
                return this.str(NId.getApi(Nuts.getVersion()).orNull());
            }
            case "nuts.workspace-runtime.version": {
                String rt = NWorkspace.of().getBootOptions().getRuntimeId().map(this::str).orNull();
                return rt == null ? this.str(this.workspace.getRuntimeId().getVersion()) : (rt.contains("#") ? rt.substring(rt.indexOf("#") + 1) : rt);
            }
            case "nuts.workspace-runtime.id": {
                String rt = NWorkspace.of().getBootOptions().getRuntimeId().map(this::str).orNull();
                return rt == null ? this.str(this.workspace.getRuntimeId().getVersion()) : (rt.contains("#") ? rt : "net.thevpc.nuts:nuts-runtime#" + rt);
            }
        }
        Object v = NInfoCmd.of().getPropertyValue(from).orNull();
        if (v != null) {
            return NText.of(v).filteredText();
        }
        String v2 = System.getProperty(from);
        if (v2 != null) {
            return v2;
        }
        return "${" + from + "}";
    }
}

