/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.extension.CoreServiceUtils;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NClassClassMap;
import net.thevpc.nuts.util.NRef;

class IdCache {
    private final NId id;
    final Map<Class<?>, NClassClassMap> classes = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> cacheExtensionTypes = new HashMap();
    private final NWorkspace workspace;
    URL url;

    public IdCache(NId id, NWorkspace workspace) {
        this.id = id;
        this.workspace = workspace;
    }

    public IdCache(NId id, URL url, ClassLoader bootClassLoader, NLog LOG, Class<?>[] extensionPoints, NWorkspace workspace) {
        NAssert.requireNonBlank(extensionPoints, "extensionPoints");
        if (id == null != (url == null)) {
            NAssert.requireNonNull(id, "id");
            NAssert.requireNonNull(url, "url");
        }
        Set extensionPointStrings = Arrays.stream(extensionPoints).map(x -> x.getName()).collect(Collectors.toSet());
        this.id = id;
        this.url = url;
        this.workspace = workspace;
        Class<NComponent> serviceClass = NComponent.class;
        NRef<Boolean> logStart = NRef.of(false);
        int count = 0;
        if (url != null) {
            for (String n : CoreServiceUtils.loadZipServiceClassNames(url, serviceClass)) {
                count += this._addOne(n, bootClassLoader, extensionPoints, LOG, logStart, serviceClass);
            }
            LOG.log(NMsg.ofC("found %s extensions from %s (id=%s) (classloader %s). looking for %s", count, url, id, bootClassLoader, extensionPointStrings).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
        } else {
            for (String n : CoreServiceUtils.loadZipServiceClassNamesFromClassLoader(bootClassLoader, serviceClass)) {
                count += this._addOne(n, bootClassLoader, extensionPoints, LOG, logStart, serviceClass);
            }
            LOG.log(NMsg.ofC("found %s extensions from classloader %s (id=%s) . looking for %s", count, bootClassLoader, id, extensionPointStrings).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
        }
    }

    private int _addOne(String className, ClassLoader bootClassLoader, Class<?>[] extensionPoints, NLog LOG, NRef<Boolean> logStart, Class<?> serviceClass) {
        int count = 0;
        for (Class<?> extensionPoint : extensionPoints) {
            Class<?> c = null;
            try {
                c = Class.forName(className, false, bootClassLoader);
            }
            catch (ClassNotFoundException x2) {
                LOG.log(NMsg.ofC("not a valid type %s", c).asFineAlert(x2));
            }
            if (c == null) continue;
            if (!logStart.get().booleanValue()) {
                Set extensionPointStrings = Arrays.stream(extensionPoints).map(x -> x.getName()).collect(Collectors.toSet());
                if (this.id == null) {
                    LOG.log(NMsg.ofC("discover extensions from current classloader %s. looking for %s", bootClassLoader, extensionPointStrings).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
                } else {
                    LOG.log(NMsg.ofC("discover extensions from %s (id=%s) (classloader %s). looking for %s", this.url, this.id, bootClassLoader, extensionPointStrings).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
                }
                logStart.set(true);
            }
            if (!serviceClass.isAssignableFrom(c)) {
                if ("net.thevpc.nuts.spi.NComponent".equals(serviceClass.getName())) {
                    LOG.log(NMsg.ofC("not a valid type %s <> %s, ignore...", c, serviceClass).withIntent(NMsgIntent.ALERT).withLevel(Level.FINE));
                    continue;
                }
                LOG.log(NMsg.ofC("not a valid type %s, ignore...", c).withIntent(NMsgIntent.ALERT).withLevel(Level.FINE));
                continue;
            }
            NClassClassMap cc = this.classes.computeIfAbsent(extensionPoint, r -> new NClassClassMap());
            cc.add(c);
            if ("net.thevpc.nuts.spi.NComponent".equals(extensionPoint.getName())) {
                LOG.log(NMsg.ofC("discovered %s in %s", c, this.url == null ? "default classloader" : this.url).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
            } else {
                LOG.log(NMsg.ofC("discovered %s as %s in %s", c, extensionPoint, this.url == null ? "default classloader" : this.url).withIntent(NMsgIntent.NOTICE).withLevel(Level.FINE));
            }
            ++count;
        }
        return count;
    }

    void add(Class<?> extensionPoint, Class<?> implementation) {
        NClassClassMap y = this.getClassClassMap(extensionPoint, true);
        if (!y.containsExactKey(implementation)) {
            y.add(implementation);
            this.invalidateCache();
        }
    }

    private void invalidateCache() {
        this.cacheExtensionTypes.clear();
    }

    private NClassClassMap getClassClassMap(Class extensionPoint, boolean create) {
        NClassClassMap r = this.classes.get(extensionPoint);
        if (r == null && create) {
            r = new NClassClassMap();
            this.classes.put(extensionPoint, r);
        }
        return r;
    }

    public NId getId() {
        return this.id;
    }

    public URL getUrl() {
        return this.url;
    }

    public Set<Class<?>> getExtensionPoints() {
        return new LinkedHashSet(this.classes.keySet());
    }

    public <T> Set<Class<? extends T>> getExtensionTypesNoCache(Class<T> extensionPoint) {
        LinkedHashSet<Class<T>> all = new LinkedHashSet<Class<T>>();
        for (Map.Entry<Class<?>, NClassClassMap> rr : this.classes.entrySet()) {
            if (!rr.getKey().isAssignableFrom(extensionPoint)) continue;
            all.addAll(Arrays.asList((Class[])rr.getValue().getAll(extensionPoint)));
        }
        return all;
    }

    public <T> Set<Class<? extends T>> getExtensionTypesNoCache2(Class<T> extensionPoint) {
        LinkedHashSet<Class<T>> all = new LinkedHashSet<Class<T>>();
        for (Map.Entry<Class<?>, NClassClassMap> rr : this.classes.entrySet()) {
            all.addAll(Arrays.asList((Class[])rr.getValue().getAll(extensionPoint)));
        }
        return all;
    }

    public <T> Set<Class<? extends T>> getExtensionTypes(Class<T> extensionPoint) {
        Set<Class<Object>> r = this.cacheExtensionTypes.get(extensionPoint);
        if (r != null) {
            return r;
        }
        r = Collections.unmodifiableSet(this.getExtensionTypesNoCache(extensionPoint));
        this.cacheExtensionTypes.put(extensionPoint, r);
        return r;
    }
}

