/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootWorkspaceAlreadyExistsException;
import net.thevpc.nuts.boot.NBootWorkspaceFactory;
import net.thevpc.nuts.boot.NBootWorkspaceNotFoundException;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.concurrent.NScopedValue;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NOpenMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceBootConfig;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.core.NWorkspaceStoredConfig;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementFactory;
import net.thevpc.nuts.elem.NElementNotFoundException;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.internal.NScopedWorkspace;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NDigestName;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogFactorySPI;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NDesktopIntegrationItem;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NLauncherOptions;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.boot.NBootConfig;
import net.thevpc.nuts.runtime.standalone.dependency.util.NClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.event.DefaultNWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.installer.CommandForIdNInstallerComponent;
import net.thevpc.nuts.runtime.standalone.repository.NRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepositoryModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNInstalledRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.security.DefaultNWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.runtime.standalone.session.DefaultNSession;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.ExtraApiUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.runtime.standalone.util.NBootHelper;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.DefaultNFilterModel;
import net.thevpc.nuts.runtime.standalone.workspace.AbstractNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.NRecommendationPhase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NSettingsNdiSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.SystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultCustomCommandsModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNPlatformModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceLocationModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceModel;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NDependencySolver;
import net.thevpc.nuts.spi.NIndexStoreFactory;
import net.thevpc.nuts.spi.NInstallerComponent;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositorySelectorList;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgBuilder;
import net.thevpc.nuts.text.NTableModel;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArt;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.text.NVersionFormat;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.DefaultNProperties;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NPropsTransformer;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NSupportMode;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNWorkspace
extends AbstractNWorkspace
implements NWorkspaceExt {
    public static final Pattern UNIX_USER_DIRS_PATTERN = Pattern.compile("^\\s*(?<k>[A-Z_]+)\\s*=\\s*(?<v>.*)$");
    public static final NVersion VERSION_INSTALL_INFO_CONFIG = NVersion.get("0.8.0").get();
    public static final NVersion VERSION_SDK_LOCATION = NVersion.get("0.8.0").get();
    public static final NVersion VERSION_REPOSITORY_CONFIG = NVersion.get("0.8.0").get();
    public static final String VERSION_REPOSITORY_REF = "0.8.0";
    public static final String VERSION_WS_CONFIG_API = "0.8.0";
    public static final NVersion VERSION_WS_CONFIG_BOOT = NVersion.get("0.8.7").get();
    public static final String VERSION_WS_CONFIG_MAIN = "0.8.0";
    public static final String VERSION_WS_CONFIG_RUNTIME = "0.8.0";
    public static final String VERSION_WS_CONFIG_SECURITY = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG_FACTORY = "0.8.0";
    public static final String VERSION_USER_CONFIG = "0.8.0";
    public static final String RUNTIME_VERSION = "0.8.9.0";
    public static final String RUNTIME_VERSION_STRING = "net.thevpc.nuts:nuts-runtime#0.8.9.0";
    public static final NId RUNTIME_ID = NId.get("net.thevpc.nuts:nuts-runtime#0.8.9.0").get();
    private NWorkspaceModel wsModel;

    public DefaultNWorkspace(NBootOptionsInfo callerBootOptionsInfo, NBootOptions info) {
        super(callerBootOptionsInfo);
        this.initWorkspace(info);
    }

    @Override
    public NWorkspaceStore store() {
        return this.wsModel.store;
    }

    private static Set<NId> toIds(List<NDescriptor> all) {
        LinkedHashSet<NId> set = new LinkedHashSet<NId>();
        for (NDescriptor i : all) {
            set.add(i.getId());
            set.addAll(i.getDependencies().stream().map(NDependency::toId).collect(Collectors.toList()));
        }
        return set;
    }

    private void initWorkspace(NBootOptions initialBootOptions0) {
        NAssert.requireNonNull(initialBootOptions0, "boot options");
        InitWorkspaceData data = new InitWorkspaceData();
        data.initialBootOptions = initialBootOptions0.readOnly();
        try {
            this.wsModel = new NWorkspaceModel(this, data.initialBootOptions);
            this.runWith(() -> {
                this.wsModel.init();
                this._preloadWorkspace(data);
                if (!this.loadWorkspace(data.effectiveBootOptions.getExcludedExtensions().orElseGet(Collections::emptyList), null)) {
                    this._createWorkspaceFirstBoot(data);
                } else {
                    this._createWorkspaceNonFirstBoot(data);
                }
                this._postCreateWorkspace(data);
            });
        }
        catch (RuntimeException ex) {
            if (this.wsModel != null && this.wsModel.recomm != null) {
                this.runWith(() -> new Thread(() -> {
                    try {
                        NId runtimeId = this.getRuntimeId();
                        String sRuntimeId = runtimeId == null ? NId.getRuntime("").get().toString() : runtimeId.toString();
                        this.runWith(() -> this.displayRecommendations(this.wsModel.recomm.getRecommendations(new RequestQueryInfo(sRuntimeId, ex), NRecommendationPhase.BOOTSTRAP, true)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start());
            }
            throw ex;
        }
        finally {
            if (this.wsModel != null && this.wsModel.bootModel != null) {
                this.wsModel.bootModel.setInitializing(false);
            }
        }
    }

    private void _preloadWorkspace(InitWorkspaceData data) {
        this.wsModel.LOG.debug(NMsg.ofC(NI18n.of("detected terminal flags %s"), this.wsModel.bootModel.getBootTerminal().getFlags()));
        data.effectiveBootOptions = this.wsModel.bootModel.getBootEffectiveOptions();
        this.wsModel.configModel = new DefaultNWorkspaceConfigModel(this);
        String workspaceLocation = data.effectiveBootOptions.getWorkspace().orNull();
        data.bootRepositories = data.effectiveBootOptions.getBootRepositories().orNull();
        NBootWorkspaceFactory bootFactory = data.effectiveBootOptions.getBootWorkspaceFactory().orNull();
        ClassLoader bootClassLoader = data.effectiveBootOptions.getClassWorldLoader().orNull();
        this.wsModel.extensionModel = new DefaultNWorkspaceExtensionModel(this, bootFactory, data.effectiveBootOptions.getExcludedExtensions().orElse(Collections.emptyList()));
        this.wsModel.filtersModel = new DefaultNFilterModel(this);
        this.wsModel.envModel = new DefaultNWorkspaceEnvManagerModel(this);
        this.wsModel.installedRepository = new DefaultNInstalledRepository(data.effectiveBootOptions);
        this.wsModel.sdkModel = new DefaultNPlatformModel(this.wsModel.envModel);
        this.wsModel.location = data.effectiveBootOptions.getWorkspace().orNull();
        this.wsModel.locationsModel = new DefaultNWorkspaceLocationModel(this, this.wsModel.location == null ? null : Paths.get(this.wsModel.location, new String[0]).toString());
        this.wsModel.extensionModel.onInitializeWorkspace(data.effectiveBootOptions, bootClassLoader);
        this.wsModel.logModel.setFactorySPI(NExtensions.of().createComponent(NLogFactorySPI.class, null).orElse(this.wsModel.logModel.getFactorySPI()));
        this.wsModel.textModel.loadExtensions();
        data.cfg = new NBootConfig();
        data.cfg.setWorkspace(workspaceLocation);
        data.cfg.setApiVersion(this.wsModel.askedApiVersion);
        data.cfg.setRuntimeId(this.wsModel.askedRuntimeId);
        data.cfg.setRuntimeBootDescriptor(NBootHelper.toDescriptor(data.effectiveBootOptions.getRuntimeBootDescriptor().orNull()));
        data.cfg.setExtensionBootDescriptors(NBootHelper.toDescriptorList(data.effectiveBootOptions.getExtensionBootDescriptors().orNull()));
        this.wsModel.bootModel.onInitializeWorkspace();
        NSystemTerminalBase termb = this.wsModel.extensions.createComponent(NSystemTerminalBase.class).get();
        data.terminals = NIO.of();
        data.terminals.setSystemTerminal(termb).setDefaultTerminal(NTerminal.of());
        this.wsModel.bootModel.bootSession().setTerminal(NTerminal.of());
        this.wsModel.logModel.getTermHandler().resumeTerminal();
        for (NPathFactorySPI nPathFactorySPI : this.wsModel.extensions.createServiceLoader(NPathFactorySPI.class, NWorkspace.class).loadAll(this)) {
            this.wsModel.configModel.addPathFactory(nPathFactorySPI);
        }
        data.text = NTexts.of();
        try {
            data.text.getTheme();
        }
        catch (Exception ex) {
            this.wsModel.LOG.log(NMsg.ofJ("unable to load theme {0}. Reset to default!", data.effectiveBootOptions.getTheme()).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            data.text.setTheme("");
        }
        data.elems = NElementFactory.of();
        this._initLog(data);
        this.wsModel.securityModel = new DefaultNWorkspaceSecurityModel(this);
        Instant now = Instant.now();
        if (data.effectiveBootOptions.getCreationTime().get().compareTo(now) > 0) {
            this.wsModel.configModel.setStartCreateTime(now);
        } else {
            this.wsModel.configModel.setStartCreateTime(data.effectiveBootOptions.getCreationTime().get());
        }
        boolean exists = this.wsModel.store.isValidWorkspaceFolder();
        NOpenMode openMode = data.effectiveBootOptions.getOpenMode().orNull();
        if (openMode != null) {
            switch (openMode) {
                case OPEN_OR_ERROR: {
                    if (exists) break;
                    throw new NBootWorkspaceNotFoundException(workspaceLocation);
                }
                case CREATE_OR_ERROR: {
                    if (!exists) break;
                    throw new NBootWorkspaceAlreadyExistsException(workspaceLocation);
                }
            }
        }
        this.wsModel.configModel.onExtensionsPrepared();
    }

    private void _postCreateWorkspace(InitWorkspaceData data) {
        if (!this.isReadOnly()) {
            this.saveConfig(false);
        }
        this.wsModel.configModel.setEndCreateTime(Instant.now());
        NSession session = this.currentSession();
        if (data.justInstalled) {
            NLiteral enableRecommendations = this.wsModel.bootModel.getCustomBootOptions().get("---recommendations");
            if (enableRecommendations == null || enableRecommendations.asBoolean().orElse(true).booleanValue()) {
                this.runWith(() -> new Thread(() -> {
                    try {
                        List recommendedCompanions;
                        Map rec = this.wsModel.recomm.getRecommendations(new RequestQueryInfo(this.getApiId().toString(), ""), NRecommendationPhase.BOOTSTRAP, false);
                        if (rec != null && rec.get("companions") instanceof List && (recommendedCompanions = (List)rec.get("companions")) != null) {
                            this.wsModel.recommendedCompanions.addAll(recommendedCompanions);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start());
            }
            data.justInstalledArchetype.startWorkspace();
            DefaultNWorkspaceEvent workspaceCreatedEvent = new DefaultNWorkspaceEvent(session, null, null, null, null);
            for (NWorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
                workspaceListener.onCreateWorkspace(workspaceCreatedEvent);
            }
        }
        if (data.effectiveBootOptions.getUserName().orElse("").trim().length() > 0) {
            char[] password = data.effectiveBootOptions.getCredentials().orNull();
            if (password == null || NBlankable.isBlank(new String(password))) {
                password = data.terminals.getDefaultTerminal().readPassword(NMsg.ofPlain("Password : "));
            }
            NWorkspaceSecurityManager.of().login(data.effectiveBootOptions.getUserName().get(), password);
        }
        this.wsModel.configModel.setEndCreateTime(Instant.now());
        this.wsModel.LOG.log(NMsg.ofC("%s workspace loaded in %s", NMsg.ofCode("nuts"), this.getCreationDuration()).asFine().withIntent(NMsgIntent.SUCCESS));
        if (data.effectiveBootOptions.getSharedInstance().orElse(false).booleanValue()) {
            NWorkspace o = NScopedWorkspace.setSharedWorkspaceInstance(this);
            if (o != null) {
                this.wsModel.LOG.log(NMsg.ofC("%s workspace set as main instance overriding existing workspace", NMsg.ofCode("nuts")).withLevel(Level.WARNING).withIntent(NMsgIntent.SUCCESS));
            } else {
                this.wsModel.LOG.log(NMsg.ofC("%s workspace set as main instance", NMsg.ofCode("nuts")).asFine().withIntent(NMsgIntent.SUCCESS));
            }
        }
        if (CoreNUtils.isCustomFalse("---perf")) {
            if (session.isPlainOut()) {
                NOut.println(NMsg.ofC("%s workspace loaded in %s", NMsg.ofCode("nuts"), this.getCreationDuration()));
            } else {
                session.eout().add(data.elems.ofObjectBuilder().set("workspace-loaded-in", (NElement)data.elems.ofObjectBuilder().set("ms", (double)this.getCreationDuration().toMillis()).set("text", this.getCreationDuration().normalize().toString()).build()).build());
            }
        }
        NWorkspaceProfilerImpl.debug();
    }

    private void _createWorkspaceNonFirstBoot(InitWorkspaceData data) {
        NBootConfig cfg = data.cfg;
        NBootOptions effectiveBootOptions = data.effectiveBootOptions;
        this.wsModel.bootModel.setFirstBoot(false);
        this.wsModel.uuid = this.wsModel.configModel.getStoreModelBoot().getUuid();
        if (NBlankable.isBlank(this.wsModel.uuid)) {
            this.wsModel.uuid = UUID.randomUUID().toString();
            this.wsModel.configModel.getStoreModelBoot().setUuid(this.wsModel.uuid);
        }
        if (effectiveBootOptions.getRecover().orElse(false).booleanValue()) {
            this.wsModel.configModel.setBootApiVersion(cfg.getApiVersion());
            this.wsModel.configModel.setBootRuntimeId(cfg.getRuntimeId(), effectiveBootOptions.getRuntimeBootDescriptor().isEmpty() ? "" : NBootHelper.toDependencyList(effectiveBootOptions.getRuntimeBootDescriptor().get().getDependencies()).stream().map((Function<NDependency, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lnet/thevpc/nuts/artifact/NDependency;)Ljava/lang/String;)()).collect(Collectors.joining(";")));
            this.wsModel.configModel.setBootRepositories(cfg.getBootRepositories());
            try {
                NInstallCmd.of().setInstalled(true).getResult();
            }
            catch (Exception ex) {
                this.wsModel.LOG.log(NMsg.ofJ("reinstall artifacts failed : {0}", ex).asError(ex));
            }
        }
        if (this.getRepositories().isEmpty()) {
            this.wsModel.LOG.log(NMsg.ofPlain("workspace has no repositories. Will re-create defaults").withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            data.justInstalledArchetype = this.initializeWorkspace(effectiveBootOptions.getArchetype().orNull());
        }
        List<String> transientRepositoriesSet = NCollections.nonNullList(effectiveBootOptions.getRepositories().orElseGet(Collections::emptyList));
        NRepositoryDB repoDB = NRepositoryDB.of();
        NRepositorySelectorList expected = NRepositorySelectorList.of(transientRepositoriesSet, repoDB).get();
        for (NRepositoryLocation loc : expected.resolve(null, repoDB)) {
            NAddRepositoryOptions d = NRepositorySelectorHelper.createRepositoryOptions(loc, false);
            String n = d.getName();
            String ruuid = (NBlankable.isBlank(n) ? "temporary" : n) + "_" + UUID.randomUUID().toString().replace("-", "");
            d.setName(ruuid);
            d.setTemporary(true);
            d.setEnabled(true);
            d.setFailSafe(false);
            if (d.getConfig() != null) {
                d.getConfig().setName(NBlankable.isBlank(n) ? ruuid : n);
                d.getConfig().setStoreStrategy(NStoreStrategy.STANDALONE);
            }
            this.addRepository(d);
        }
    }

    private void _createWorkspaceFirstBoot(InitWorkspaceData data) {
        NSession session;
        NBootOptions effectiveBootOptions = data.effectiveBootOptions;
        this.wsModel.bootModel.setFirstBoot(true);
        if (this.wsModel.uuid == null) {
            this.wsModel.uuid = UUID.randomUUID().toString();
        }
        data.justInstalled = true;
        NWorkspaceUtils.of(this).checkReadOnly();
        this.wsModel.LOG.log(NMsg.ofC("creating %s workspace at %s", data.text.ofStyled("new", NTextStyle.info()), this.getWorkspaceLocation()).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
        NWorkspaceConfigBoot bconfig = new NWorkspaceConfigBoot();
        bconfig.setUuid(this.wsModel.uuid);
        NWorkspaceConfigApi aconfig = new NWorkspaceConfigApi();
        aconfig.setApiVersion(this.wsModel.askedApiVersion);
        aconfig.setRuntimeId(this.wsModel.askedRuntimeId);
        aconfig.setJavaCommand(effectiveBootOptions.getJavaCommand().orNull());
        aconfig.setJavaOptions(effectiveBootOptions.getJavaOptions().orNull());
        NWorkspaceConfigRuntime rconfig = new NWorkspaceConfigRuntime();
        rconfig.setDependencies(effectiveBootOptions.getRuntimeBootDescriptor().isEmpty() ? "" : NBootHelper.toDependencyList(effectiveBootOptions.getRuntimeBootDescriptor().get().getDependencies()).stream().map((Function<NDependency, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lnet/thevpc/nuts/artifact/NDependency;)Ljava/lang/String;)()).collect(Collectors.joining(";")));
        rconfig.setId(this.wsModel.askedRuntimeId);
        bconfig.setBootRepositories(data.bootRepositories);
        bconfig.setStoreStrategy(effectiveBootOptions.getStoreStrategy().orNull());
        bconfig.setRepositoryStoreStrategy(effectiveBootOptions.getRepositoryStoreStrategy().orNull());
        bconfig.setStoreLayout(effectiveBootOptions.getStoreLayout().orNull());
        bconfig.setSystem(effectiveBootOptions.getSystem().orElse(false));
        bconfig.setStoreLocations(new NStoreLocationsMap(effectiveBootOptions.getStoreLocations().orNull()).toMapOrNull());
        bconfig.setHomeLocations(new NHomeLocationsMap(effectiveBootOptions.getHomeLocations().orNull()).toMapOrNull());
        boolean namedWorkspace = CoreNUtils.isValidWorkspaceName(effectiveBootOptions.getWorkspace().orNull());
        if (bconfig.getStoreStrategy() == null) {
            bconfig.setStoreStrategy(namedWorkspace ? NStoreStrategy.EXPLODED : NStoreStrategy.STANDALONE);
        }
        if (bconfig.getRepositoryStoreStrategy() == null) {
            bconfig.setRepositoryStoreStrategy(NStoreStrategy.EXPLODED);
        }
        bconfig.setName(CoreNUtils.resolveValidWorkspaceName(effectiveBootOptions.getWorkspace().orNull()));
        this.wsModel.configModel.setCurrentConfig(new DefaultNWorkspaceCurrentConfig(this).merge(aconfig).merge(bconfig).build(this.getWorkspaceLocation()));
        this.wsModel.configModel.setConfigBoot(bconfig);
        this.wsModel.configModel.setConfigApi(aconfig);
        this.wsModel.configModel.setConfigRuntime(rconfig);
        for (String customOption : effectiveBootOptions.getCustomOptions().orElseGet(Collections::emptyList)) {
            NArg a = NArg.of(customOption);
            if (!a.getKey().asString().get().startsWith("config.") || !a.isUncommented()) continue;
            this.setConfigProperty(a.getKey().asString().orElse("").substring("config.".length()), a.getStringValue().orNull());
        }
        data.justInstalledArchetype = this.initializeWorkspace(effectiveBootOptions.getArchetype().orNull());
        NVersion nutsVersion = this.getRuntimeId().getVersion();
        if (this.wsModel.LOG.isLoggable(Level.CONFIG)) {
            this.wsModel.LOG.log(NMsg.ofJ("nuts workspace v{0} created.", nutsVersion).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
        }
        if ((session = this.currentSession()).isPlainTrace() && !this.getBootOptions().getSkipWelcome().orElse(false).booleanValue()) {
            NPrintStream out = session.out();
            out.resetLine();
            StringBuilder version = new StringBuilder(nutsVersion.toString());
            CoreStringUtils.fillString(' ', 25 - version.length(), version);
            NPath p = NPath.of("classpath:/net/thevpc/nuts/runtime/includes/standard-header.ntf", this.getClass().getClassLoader());
            NText n = data.text.parser().parse(p);
            n = data.text.transform(n, new NTextTransformConfig().setCurrentDir(p.getParent()).setImportClassLoader(this.getClass().getClassLoader()).setProcessAll(true));
            out.println(n == null ? "no help found" : n);
            NIsolationLevel il = this.wsModel.bootModel.getBootUserOptions().getIsolationLevel().orElse(NIsolationLevel.USER);
            if (il != NIsolationLevel.MEMORY) {
                if (NWorkspaceUtils.isUserDefaultWorkspace()) {
                    out.println(data.text.ofBuilder().append((Object)"location", NTextStyle.underlined()).append(":").append(this.getWorkspaceLocation()).append(" ").append(" (").append(this.getDigestName()).append(")"));
                } else {
                    out.println(data.text.ofBuilder().append((Object)"location", NTextStyle.underlined()).append(":").append(this.getWorkspaceLocation()).append(" ").append(" (").append(this.getDigestName()).append(")"));
                }
            }
            switch (il) {
                case USER: {
                    out.println(NTextArt.of().getTableRenderer().get().render(NTableModel.of().addCell(data.text.ofBuilder().append(" This is the first time ").appendCode("sh", "nuts").append(" is launched for this workspace "))));
                    break;
                }
                case SYSTEM: {
                    out.println(NTextArt.of().getTableRenderer().get().render(NTableModel.of().addCell(data.text.ofBuilder().append(" This is the first time ").appendCode("sh", "nuts").append(" is launched as system for this workspace "))));
                    break;
                }
                case CONFINED: {
                    out.println(NTextArt.of().getTableRenderer().get().render(NTableModel.of().addCell(data.text.ofBuilder().append(" This is a confined workspace "))));
                    break;
                }
                case SANDBOX: {
                    out.println(NTextArt.of().getTableRenderer().get().render(NTableModel.of().addCell(data.text.ofBuilder().append(" This is a sandbox workspace "))));
                    break;
                }
                case MEMORY: {
                    out.println(NTextArt.of().getTableRenderer().get().render(NTableModel.of().addCell(data.text.ofBuilder().append(" This is an in-memory workspace "))));
                }
            }
            out.println();
        }
        if (this.wsModel.bootModel.getBootUserOptions().getIsolationLevel().orNull() != NIsolationLevel.MEMORY) {
            // empty if block
        }
    }

    private void _initLog(InitWorkspaceData data) {
        NMsgBuilder mread = NMsgBuilder.of().withLevel(Level.CONFIG).withIntent(NMsgIntent.READ);
        NMsgBuilder mstart = NMsgBuilder.of().withLevel(Level.CONFIG).withIntent(NMsgIntent.START);
        if (this.wsModel.LOG.isLoggable(Level.CONFIG)) {
            NTexts text = data.text;
            NBootOptions effectiveBootOptions = data.effectiveBootOptions;
            NBootOptions userBootOptions = data.initialBootOptions;
            NCmdLines.of();
            NIO.of();
            NVersionFormat.of();
            NIdFormat.of();
            this.wsModel.LOG.log(mstart.withMsgPlain(" ==============================================================================="));
            String s = NIOUtils.loadString(this.getClass().getResourceAsStream("/net/thevpc/nuts/runtime/includes/standard-header.ntf"), true);
            s = s.replace("${nuts.workspace-runtime.version}", Nuts.getVersion().toString());
            for (String s1 : s.split("\n")) {
                this.wsModel.LOG.log(mstart.withMsgNtf(s1));
            }
            this.wsModel.LOG.log(mstart.withMsgPlain(" "));
            this.wsModel.LOG.log(mstart.withMsgPlain(" = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ="));
            this.wsModel.LOG.log(mstart.withMsgPlain(" "));
            this.wsModel.LOG.log(mstart.withMsgC("start ```sh nuts``` %s at %s", Nuts.getVersion(), CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format(data.initialBootOptions.getCreationTime().get())));
            this.wsModel.LOG.log(mread.withMsgC("open Nuts Workspace               : %s", effectiveBootOptions.toCmdLine()));
            this.wsModel.LOG.log(mread.withMsgC("open Nuts Workspace (compact)     : %s", effectiveBootOptions.toCmdLine(new NWorkspaceOptionsConfig().setCompact(true))));
            this.wsModel.LOG.log(mread.withMsgPlain("open Workspace with config        : "));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-workspace-uuid            : %s", NTextUtils.desc(effectiveBootOptions.getUuid().orNull(), text)));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-workspace-name            : %s", NTextUtils.desc(effectiveBootOptions.getName().orNull(), text)));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-api-version               : %s", Nuts.getVersion()));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-api-url                   : %s", NPath.of(this.getApiURL())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-api-digest                : %s", text.ofStyled(this.getApiDigest(), NTextStyle.version())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-boot-repositories         : %s", NTextUtils.desc(effectiveBootOptions.getBootRepositories().orNull(), text)));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-runtime                   : %s", this.getRuntimeId()));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-runtime-digest            : %s", text.ofStyled(new CoreDigestHelper().append(effectiveBootOptions.getClassWorldURLs().orNull()).getDigest(), NTextStyle.version())));
            if (effectiveBootOptions.getRuntimeBootDescriptor().isPresent()) {
                this.wsModel.LOG.log(mread.withMsgC("   nuts-runtime-dependencies      : %s", text.ofBuilder().appendJoined(text.ofStyled(";", NTextStyle.separator()), effectiveBootOptions.getRuntimeBootDescriptor().get().getDependencies().stream().map(x -> NId.get(x.toString()).get()).collect(Collectors.toList()))));
            }
            this.wsModel.LOG.log(mread.withMsgC("   nuts-runtime-urls              : %s", text.ofBuilder().appendJoined(text.ofStyled(";", NTextStyle.separator()), effectiveBootOptions.getClassWorldURLs().get().stream().map(x -> NPath.of(x.toString())).collect(Collectors.toList()))));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-extension-dependencies    : %s", text.ofBuilder().appendJoined(text.ofStyled(";", NTextStyle.separator()), DefaultNWorkspace.toIds(NBootHelper.toDescriptorList(effectiveBootOptions.getExtensionBootDescriptors().orElseGet(Collections::emptyList))).stream().map(x -> NId.get(x.toString()).get()).collect(Collectors.toList()))));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-workspace                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getWorkspace().orNull(), effectiveBootOptions.getWorkspace().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-hash-name                 : %s", this.getDigestName()));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-bin                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.BIN).orNull(), effectiveBootOptions.getStoreType(NStoreType.BIN).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-conf                : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.CONF).orNull(), effectiveBootOptions.getStoreType(NStoreType.CONF).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-var                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.VAR).orNull(), effectiveBootOptions.getStoreType(NStoreType.VAR).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-log                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.LOG).orNull(), effectiveBootOptions.getStoreType(NStoreType.LOG).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-temp                : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.TEMP).orNull(), effectiveBootOptions.getStoreType(NStoreType.TEMP).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-cache               : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.CACHE).orNull(), effectiveBootOptions.getStoreType(NStoreType.CACHE).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-run                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.RUN).orNull(), effectiveBootOptions.getStoreType(NStoreType.RUN).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-lib                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreType(NStoreType.LIB).orNull(), effectiveBootOptions.getStoreType(NStoreType.LIB).orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-strategy            : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreStrategy().orNull(), effectiveBootOptions.getStoreStrategy().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-repos-store-strategy      : %s", NTextUtils.formatLogValue(text, userBootOptions.getRepositoryStoreStrategy().orNull(), effectiveBootOptions.getRepositoryStoreStrategy().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-store-layout              : %s", NTextUtils.formatLogValue(text, userBootOptions.getStoreLayout().orNull(), effectiveBootOptions.getStoreLayout().isNotPresent() ? "system" : effectiveBootOptions.getStoreLayout().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-username                  : %s", NTextUtils.formatLogValue(text, userBootOptions.getUserName().orNull(), effectiveBootOptions.getUserName().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-read-only                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getReadOnly().orNull(), effectiveBootOptions.getReadOnly().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-trace                     : %s", NTextUtils.formatLogValue(text, userBootOptions.getTrace().orNull(), effectiveBootOptions.getTrace().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-progress                  : %s", NTextUtils.formatLogValue(text, userBootOptions.getProgressOptions().orNull(), effectiveBootOptions.getProgressOptions().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-bot                       : %s", NTextUtils.formatLogValue(text, userBootOptions.getBot().orNull(), effectiveBootOptions.getBot().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-cached                    : %s", NTextUtils.formatLogValue(text, userBootOptions.getCached().orNull(), effectiveBootOptions.getCached().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-transitive                : %s", NTextUtils.formatLogValue(text, userBootOptions.getTransitive().orNull(), effectiveBootOptions.getTransitive().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-confirm                   : %s", NTextUtils.formatLogValue(text, userBootOptions.getConfirm().orNull(), effectiveBootOptions.getConfirm().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-debug                     : %s", NTextUtils.formatLogValue(text, userBootOptions.getDebug().orNull(), effectiveBootOptions.getDebug().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-dry                       : %s", NTextUtils.formatLogValue(text, userBootOptions.getDry().orNull(), effectiveBootOptions.getDry().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-execution-type            : %s", NTextUtils.formatLogValue(text, userBootOptions.getExecutionType().orNull(), effectiveBootOptions.getExecutionType().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-out-line-prefix           : %s", NTextUtils.formatLogValue(text, userBootOptions.getOutLinePrefix().orNull(), effectiveBootOptions.getOutLinePrefix().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-err-line-prefix           : %s", NTextUtils.formatLogValue(text, userBootOptions.getErrLinePrefix().orNull(), effectiveBootOptions.getErrLinePrefix().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-init-platforms            : %s", NTextUtils.formatLogValue(text, userBootOptions.getInitPlatforms().orNull(), effectiveBootOptions.getInitPlatforms().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-init-java                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getInitJava().orNull(), effectiveBootOptions.getInitJava().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-init-launchers            : %s", NTextUtils.formatLogValue(text, userBootOptions.getInitLaunchers().orNull(), effectiveBootOptions.getInitLaunchers().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-init-scripts              : %s", NTextUtils.formatLogValue(text, userBootOptions.getInitScripts().orNull(), effectiveBootOptions.getInitScripts().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-init-scripts              : %s", NTextUtils.formatLogValue(text, userBootOptions.getInitScripts().orNull(), effectiveBootOptions.getInitScripts().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-desktop-launcher          : %s", NTextUtils.formatLogValue(text, userBootOptions.getDesktopLauncher().orNull(), effectiveBootOptions.getDesktopLauncher().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-menu-launcher             : %s", NTextUtils.formatLogValue(text, userBootOptions.getMenuLauncher().orNull(), effectiveBootOptions.getMenuLauncher().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-user-launcher             : %s", NTextUtils.formatLogValue(text, userBootOptions.getUserLauncher().orNull(), effectiveBootOptions.getUserLauncher().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-isolation-level           : %s", NTextUtils.formatLogValue(text, userBootOptions.getIsolationLevel().orNull(), effectiveBootOptions.getIsolationLevel().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-open-mode                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getOpenMode().orNull(), effectiveBootOptions.getOpenMode().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-inherited                 : %s", NTextUtils.formatLogValue(text, userBootOptions.getInherited().orNull(), effectiveBootOptions.getInherited().orNull())));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-inherited-nuts-boot-args  : %s", System.getProperty("nuts.boot.args") == null ? NTextUtils.desc(null, text) : NTextUtils.desc(NCmdLine.of(System.getProperty("nuts.boot.args"), NShellFamily.SH), text)));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-inherited-nuts-args       : %s", System.getProperty("nuts.args") == null ? NTextUtils.desc(null, text) : NTextUtils.desc(text.of(NCmdLine.of(System.getProperty("nuts.args"), NShellFamily.SH)), text)));
            this.wsModel.LOG.log(mread.withMsgC("   nuts-open-mode                 : %s", NTextUtils.formatLogValue(text, effectiveBootOptions.getOpenMode().orNull(), effectiveBootOptions.getOpenMode().orElse(NOpenMode.OPEN_OR_CREATE))));
            DefaultNWorkspace senvs = this;
            this.wsModel.LOG.log(mread.withMsgC("   java-home                      : %s", System.getProperty("java.home")));
            this.wsModel.LOG.log(mread.withMsgC("   java-classpath                 : %s", System.getProperty("java.class.path")));
            this.wsModel.LOG.log(mread.withMsgC("   java-library-path              : %s", System.getProperty("java.library.path")));
            this.wsModel.LOG.log(mread.withMsgC("   os-name                        : %s", System.getProperty("os.name")));
            this.wsModel.LOG.log(mread.withMsgC("   os-family                      : %s", senvs.getOsFamily()));
            this.wsModel.LOG.log(mread.withMsgC("   os-dist                        : %s", senvs.getOsDist().getArtifactId()));
            this.wsModel.LOG.log(mread.withMsgC("   os-arch                        : %s", System.getProperty("os.arch")));
            this.wsModel.LOG.log(mread.withMsgC("   os-shell                       : %s", senvs.getShellFamily()));
            this.wsModel.LOG.log(mread.withMsgC("   os-shells                      : %s", text.ofBuilder().appendJoined(",", senvs.getShellFamilies())));
            NWorkspaceTerminalOptions b = this.getModel().bootModel.getBootTerminal();
            this.wsModel.LOG.log(mread.withMsgC("   os-terminal-flags              : %s", String.join((CharSequence)", ", b.getFlags())));
            NTerminalMode terminalMode = this.wsModel.bootModel.getBootUserOptions().getTerminalMode().orElse(NTerminalMode.DEFAULT);
            this.wsModel.LOG.log(mread.withMsgC("   os-terminal-mode               : %s", terminalMode));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktop                     : %s", senvs.getDesktopEnvironment()));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktop-family              : %s", senvs.getDesktopEnvironmentFamily()));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktops                    : %s", text.ofBuilder().appendJoined(",", senvs.getDesktopEnvironments())));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktop-families            : %s", text.ofBuilder().appendJoined(",", senvs.getDesktopEnvironmentFamilies())));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktop-path                : %s", senvs.getDesktopPath()));
            this.wsModel.LOG.log(mread.withMsgC("   os-desktop-integration         : %s", senvs.getDesktopIntegrationSupport(NDesktopIntegrationItem.DESKTOP)));
            this.wsModel.LOG.log(mread.withMsgC("   os-menu-integration            : %s", senvs.getDesktopIntegrationSupport(NDesktopIntegrationItem.MENU)));
            this.wsModel.LOG.log(mread.withMsgC("   os-shortcut-integration        : %s", senvs.getDesktopIntegrationSupport(NDesktopIntegrationItem.USER)));
            this.wsModel.LOG.log(mread.withMsgC("   os-version                     : %s", senvs.getOsDist().getVersion()));
            this.wsModel.LOG.log(mread.withMsgC("   os-username                    : %s", System.getProperty("user.name")));
            this.wsModel.LOG.log(mread.withMsgC("   os-user-dir                    : %s", NPath.of(System.getProperty("user.dir"))));
            this.wsModel.LOG.log(mread.withMsgC("   os-user-home                   : %s", NPath.of(System.getProperty("user.home"))));
            this.wsModel.LOG.log(mread.withMsgC("   os-user-locale                 : %s", Locale.getDefault()));
            this.wsModel.LOG.log(mread.withMsgC("   os-user-time-zone              : %s", TimeZone.getDefault()));
        }
    }

    private void displayRecommendations(Object r) {
        HashMap<String, Object> a = new HashMap<String, Object>();
        a.put("recommendations", r);
        NOut.println(a);
    }

    private URL getApiURL() {
        NId nid = NId.getApi(Nuts.getVersion()).get();
        return ExtraApiUtils.findClassLoaderJar(nid, NClassLoaderUtils.resolveClasspathURLs(Thread.currentThread().getContextClassLoader()));
    }

    private String getApiDigest() {
        if (NBlankable.isBlank(this.wsModel.apiDigest)) {
            this.wsModel.apiDigest = new CoreDigestHelper().append(this.getApiURL()).getDigest();
        }
        return this.wsModel.apiDigest;
    }

    protected NDescriptor _applyParentDescriptors(NDescriptor descriptor) {
        List<NId> parents = descriptor.getParents();
        ArrayList<NDescriptor> parentDescriptors = new ArrayList<NDescriptor>();
        for (NId parent : parents) {
            parentDescriptors.add(this._applyParentDescriptors(NFetchCmd.of(parent).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor()));
        }
        if (parentDescriptors.size() > 0) {
            NDescriptorBuilder descrWithParents = descriptor.builder();
            NDescriptorUtils.applyParents(descrWithParents, parentDescriptors);
            return descrWithParents.build();
        }
        return descriptor;
    }

    protected NDescriptor _resolveEffectiveDescriptor(NDescriptor descriptor, NDescriptorEffectiveConfig effectiveNDescriptorConfig) {
        this.wsModel.LOG.log(NMsg.ofC("resolve effective %s using %s", descriptor.getId(), effectiveNDescriptorConfig).withLevel(Level.FINEST).withIntent(NMsgIntent.START));
        NDescriptorBuilder descrWithParents = this._applyParentDescriptors(descriptor).builder();
        List<NDescriptorProperty> properties = descrWithParents.getProperties().stream().filter(x -> effectiveNDescriptorConfig.isIgnoreCurrentEnvironment() || CoreFilterUtils.acceptCondition(x.getCondition(), false)).collect(Collectors.toList());
        if (!properties.isEmpty()) {
            DefaultNProperties pp = new DefaultNProperties();
            if (!effectiveNDescriptorConfig.isIgnoreCurrentEnvironment()) {
                ArrayList<NDescriptorProperty> n = new ArrayList<NDescriptorProperty>();
                pp.addAll(properties);
                for (String s : pp.keySet()) {
                    NDescriptorProperty[] a = pp.getAll(s);
                    if (a.length == 1) {
                        n.add(a[0].builder().setCondition((NEnvCondition)null).build());
                        continue;
                    }
                    NDescriptorProperty z = null;
                    for (NDescriptorProperty zz : a) {
                        boolean wasZZ;
                        if (z == null) {
                            z = zz;
                            boolean wasZZ2 = NBlankable.isBlank(zz);
                            if (wasZZ2) continue;
                            break;
                        }
                        boolean wasZ = NBlankable.isBlank(z);
                        if (wasZ == (wasZZ = NBlankable.isBlank(zz)) || !wasZ) {
                            z = zz;
                        }
                        if (!wasZZ) break;
                    }
                    if (z == null) continue;
                    n.add(z.builder().setCondition((NEnvCondition)null).build());
                }
                properties = n;
            }
        }
        descrWithParents.setProperties(properties);
        NDescriptor effectiveDescriptor = NDescriptorUtils.applyProperties(descrWithParents).build();
        ArrayList<NDependency> oldDependencies = new ArrayList<NDependency>();
        if (!effectiveNDescriptorConfig.isIgnoreCurrentEnvironment()) {
            for (NDependency d : effectiveDescriptor.getDependencies()) {
                if (!CoreFilterUtils.acceptDependency(d)) continue;
                oldDependencies.add(d.builder().setCondition((NEnvCondition)null).build());
            }
        } else {
            oldDependencies.addAll(effectiveDescriptor.getDependencies());
        }
        ArrayList<NDependency> newDeps = new ArrayList<NDependency>();
        boolean someChange = false;
        LinkedHashSet<NDependency> effStandardDeps = new LinkedHashSet<NDependency>();
        for (NDependency standardDependency : effectiveDescriptor.getStandardDependencies()) {
            if ("import".equals(standardDependency.getScope())) {
                NDescriptor dd = NFetchCmd.of(standardDependency.toId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultEffectiveDescriptor();
                for (NDependency dependency : dd.getStandardDependencies()) {
                    if (!effectiveNDescriptorConfig.isIgnoreCurrentEnvironment() && !CoreFilterUtils.acceptDependency(dependency)) continue;
                    effStandardDeps.add(dependency);
                }
                continue;
            }
            if (!effectiveNDescriptorConfig.isIgnoreCurrentEnvironment() && !CoreFilterUtils.acceptDependency(standardDependency)) continue;
            effStandardDeps.add(standardDependency);
        }
        for (NDependency d : oldDependencies) {
            if (NBlankable.isBlank(d.getScope()) || d.getVersion().isBlank() || NBlankable.isBlank(d.getOptional())) {
                NDependency standardDependencyOk = null;
                for (NDependency standardDependency : effStandardDeps) {
                    if (!standardDependency.getShortName().equals(d.toId().getShortName())) continue;
                    standardDependencyOk = standardDependency;
                    break;
                }
                if (standardDependencyOk != null) {
                    if (NBlankable.isBlank(d.getScope()) && !NBlankable.isBlank(standardDependencyOk.getScope())) {
                        someChange = true;
                        d = d.builder().setScope(standardDependencyOk.getScope()).build();
                    }
                    if (NBlankable.isBlank(d.getOptional()) && !NBlankable.isBlank(standardDependencyOk.getOptional())) {
                        someChange = true;
                        d = d.builder().setOptional(standardDependencyOk.getOptional()).build();
                    }
                    if (d.getVersion().isBlank() && !standardDependencyOk.getVersion().isBlank()) {
                        someChange = true;
                        d = d.builder().setVersion(standardDependencyOk.getVersion()).build();
                    }
                }
                if (d.getVersion().isBlank()) {
                    this.wsModel.LOG.log(NMsg.ofC("failed to resolve effective version for %s", d).asFineFail());
                }
            }
            if ("import".equals(d.getScope())) {
                someChange = true;
                newDeps.addAll(NFetchCmd.of(d.toId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor().getDependencies());
                continue;
            }
            newDeps.add(d);
        }
        effectiveDescriptor = effectiveDescriptor.builder().setDependencies(newDeps).build();
        return effectiveDescriptor;
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }

    @Override
    public String toString() {
        return "NutsWorkspace{" + (this.wsModel == null ? null : this.wsModel.configModel) + '}';
    }

    protected NWorkspaceArchetypeComponent initializeWorkspace(String archetype) {
        if (NBlankable.isBlank(archetype)) {
            archetype = "default";
        }
        NWorkspaceArchetypeComponent archetypeInstance = null;
        TreeSet<String> validValues = new TreeSet<String>();
        for (NWorkspaceArchetypeComponent ac : this.wsModel.extensions.createComponents(NWorkspaceArchetypeComponent.class, archetype)) {
            if (archetype.equals(ac.getName())) {
                archetypeInstance = ac;
                break;
            }
            validValues.add(ac.getName());
        }
        if (archetypeInstance == null) {
            throw new NException(NMsg.ofC("invalid archetype %s. Valid values are : %s", archetype, validValues));
        }
        NWorkspaceSecurityManager.of().updateUser("admin").setCredentials("admin".toCharArray()).run();
        archetypeInstance.initializeWorkspace();
        if (!this.isReadOnly()) {
            this.saveConfig();
        }
        return archetypeInstance;
    }

    private NId resolveApiId(NId id, Set<NId> visited) {
        if (visited.contains(id.getLongId())) {
            return null;
        }
        visited.add(id.getLongId());
        if (NId.getApi("").get().equalsShortId(id)) {
            return id;
        }
        for (NDependency dependency : NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor().getDependencies()) {
            NId q = this.resolveApiId(dependency.toId(), visited);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    public String resolveCommandName(NId id) {
        DefaultNWorkspace aliases = this;
        String nn = id.getArtifactId();
        NCustomCmd c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getGroupId() + "." + id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        throw new NElementNotFoundException(NMsg.ofC("unable to resolve command name for %s", id));
    }

    protected boolean loadWorkspace(List<String> excludedExtensions, String[] excludedRepositories) {
        if (this.wsModel.configModel.loadWorkspace()) {
            for (NId nId : this.wsModel.extensions.getConfigExtensions()) {
                if (this.wsModel.extensionModel.isExcludedExtension(nId)) continue;
                this.wsModel.extensionModel.wireExtension(nId, NFetchCmd.of());
            }
            NUserConfig adminSecurity = this.getConfigModel().getUser("admin");
            if (adminSecurity == null || NBlankable.isBlank(adminSecurity.getCredentials())) {
                if (this.wsModel.LOG.isLoggable(Level.CONFIG)) {
                    this.wsModel.LOG.log(NMsg.ofC("%s user has no credentials. reset to default", "admin").withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
                }
                NWorkspaceSecurityManager.of().updateUser("admin").credentials("admin".toCharArray()).run();
            }
            for (NCommandFactoryConfig commandFactory : this.getCommandFactories()) {
                try {
                    this.addCommandFactory(commandFactory);
                }
                catch (Exception e) {
                    this.wsModel.LOG.log(NMsg.ofJ("unable to instantiate Command Factory {0} : {1}", commandFactory, e).asError(e));
                }
            }
            DefaultNWorkspaceEvent defaultNWorkspaceEvent = new DefaultNWorkspaceEvent(this.currentSession(), null, null, null, null);
            for (NWorkspaceListener listener : this.getWorkspaceListeners()) {
                listener.onReloadWorkspace(defaultNWorkspaceEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public NText getWelcomeText() {
        return this.callWith(() -> {
            NTexts txt = NTexts.of();
            NPath p = NPath.of("classpath:/net/thevpc/nuts/runtime/nuts-welcome.ntf", this.getClass().getClassLoader());
            NText n = txt.parser().parse(p);
            return (n = txt.transform(n, new NTextTransformConfig().setProcessAll(true).setImportClassLoader(this.getClass().getClassLoader()).setCurrentDir(p.getParent()))) == null ? txt.ofStyled("no welcome found!", NTextStyle.error()) : n;
        });
    }

    @Override
    public NText getHelpText() {
        return this.callWith(() -> {
            NTexts txt = NTexts.of();
            NPath path = NPath.of("classpath:/net/thevpc/nuts/runtime/nuts-help.ntf", this.getClass().getClassLoader());
            NText n = txt.parser().parse(path);
            return (n = txt.transform(n, new NTextTransformConfig().setProcessAll(true).setRootLevel(1))) == null ? txt.ofStyled("no help found", NTextStyle.error()) : n;
        });
    }

    @Override
    public NText resolveDefaultHelp(Class<?> clazz) {
        return this.callWith(() -> {
            NId nutsId = NId.getForClass(clazz).orNull();
            if (nutsId != null) {
                NPath urlPath = NPath.of("classpath:/" + nutsId.getShortId().getMavenFolder() + ".ntf", clazz == null ? null : clazz.getClassLoader());
                NTexts txt = NTexts.of();
                NText n = txt.parser().parse(urlPath);
                if ((n = txt.transform(n, new NTextTransformConfig().setProcessAll(true).setImportClassLoader(clazz == null ? null : clazz.getClassLoader()).setCurrentDir(urlPath.getParent()).setRootLevel(1))) == null) {
                    return txt.ofStyled(NMsg.ofC("no default help found at %s for %s", urlPath, clazz == null ? null : clazz.getName()), NTextStyle.error());
                }
                return n;
            }
            return null;
        });
    }

    @Override
    public NText getLicenseText() {
        return this.callWith(() -> {
            NTexts txt = NTexts.of();
            NPath p = NPath.of("classpath:/net/thevpc/nuts/runtime/nuts-license.ntf", this.getClass().getClassLoader());
            NText n = txt.parser().parse(p);
            return n == null ? NText.ofStyled("no license found", NTextStyle.error()) : n;
        });
    }

    @Override
    public NId resolveEffectiveId(NDescriptor descriptor) {
        if (descriptor == null) {
            throw new NArtifactNotFoundException(null);
        }
        NId thisId = descriptor.getId();
        String a = thisId.getArtifactId();
        String g = thisId.getGroupId();
        String v = thisId.getVersion().getValue();
        if (NBlankable.isBlank(g) || NBlankable.isBlank(v)) {
            List<NId> parents = descriptor.getParents();
            for (NId parent : parents) {
                NId p = NFetchCmd.of(parent).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultId();
                if (NBlankable.isBlank(g)) {
                    g = p.getGroupId();
                }
                if (NBlankable.isBlank(v)) {
                    v = p.getVersion().getValue();
                }
                if (NBlankable.isBlank(g) || NBlankable.isBlank(v)) continue;
                break;
            }
            if (NBlankable.isBlank(g) || NBlankable.isBlank(v)) {
                throw new NArtifactNotFoundException(thisId, NMsg.ofC("unable to fetchEffective for %s. best Result is %s", thisId, thisId), null);
            }
        }
        if (CoreStringUtils.containsVars(g) || CoreStringUtils.containsVars(v) || CoreStringUtils.containsVars(a)) {
            Map<String, String> p = NDescriptorUtils.getPropertiesMap(descriptor.getProperties());
            NId bestId = NIdBuilder.of(g, thisId.getArtifactId()).setVersion(v).build();
            if (CoreNUtils.isEffectiveId(bestId = NDescriptorUtils.applyProperties(bestId.builder(), new MapToFunction<String, String>(p)).build())) {
                return bestId;
            }
            Stack<NId> all = new Stack<NId>();
            List<NId> parents = descriptor.getParents();
            all.addAll(parents);
            while (!all.isEmpty()) {
                NId parent = (NId)all.pop();
                NDescriptor dd = NFetchCmd.of(parent).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor();
                if (CoreNUtils.isEffectiveId(bestId = NDescriptorUtils.applyProperties(bestId.builder(), new MapToFunction<String, String>(NDescriptorUtils.getPropertiesMap(dd.getProperties()))).build())) {
                    return bestId;
                }
                all.addAll(dd.getParents());
            }
            throw new NArtifactNotFoundException(bestId, NMsg.ofC("unable to fetchEffective for %s. best Result is %s", bestId, bestId), null);
        }
        NId bestId = NIdBuilder.of(g, thisId.getArtifactId()).setVersion(v).build();
        if (!CoreNUtils.isEffectiveId(bestId)) {
            throw new NArtifactNotFoundException(bestId, NMsg.ofC("unable to fetchEffective for %s. best Result is %s", thisId, bestId), null);
        }
        return bestId;
    }

    @Override
    public NIdType resolveNutsIdType(NId id) {
        NIdType idType = NIdType.REGULAR;
        String shortName = id.getShortName();
        if (shortName.equals("net.thevpc.nuts:nuts")) {
            idType = NIdType.API;
        } else if (shortName.equals("net.thevpc.nuts:nuts-runtime")) {
            idType = NIdType.RUNTIME;
        } else {
            for (NId companionTool : this.wsModel.extensions.getCompanionIds()) {
                if (!companionTool.getShortName().equals(shortName)) continue;
                idType = NIdType.COMPANION;
            }
        }
        return idType;
    }

    @Override
    public NInstallerComponent getInstaller(NDefinition nutToInstall) {
        if (nutToInstall != null && nutToInstall.getContent().isPresent()) {
            NInstallerComponent best;
            NId installerId;
            NDescriptor descriptor = nutToInstall.getDescriptor();
            NArtifactCall installerDescriptor = descriptor.getInstaller();
            NDefinition runnerFile = null;
            if (installerDescriptor != null && (installerId = installerDescriptor.getId()) != null) {
                if (NBlankable.isBlank(installerId.getGroupId()) && "nsh".equals(installerId.getArtifactId())) {
                    installerId = installerId.builder().setGroupId("net.thevpc.nsh").build();
                }
                CoreNIdUtils.checkShortId(installerId);
                runnerFile = NSearchCmd.of().setId(installerId).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).setDistinct(true).getResultDefinitions().findFirst().orNull();
            }
            if ((best = this.wsModel.extensions.createComponent(NInstallerComponent.class, runnerFile == null ? nutToInstall : runnerFile).orNull()) != null) {
                return best;
            }
            return new CommandForIdNInstallerComponent(runnerFile);
        }
        return new CommandForIdNInstallerComponent(null);
    }

    @Override
    public boolean requiresRuntimeExtension() {
        boolean coreFound = false;
        for (NId ext : this.wsModel.extensions.getConfigExtensions()) {
            if (!ext.equalsShortId(this.getRuntimeId())) continue;
            coreFound = true;
            break;
        }
        return !coreFound;
    }

    @Override
    public NDescriptor resolveEffectiveDescriptor(NDescriptor descriptor) {
        return this.resolveEffectiveDescriptor(descriptor, null);
    }

    @Override
    public NDescriptor resolveEffectiveDescriptor(NDescriptor descriptor, NDescriptorEffectiveConfig effectiveNDescriptorConfig) {
        if (effectiveNDescriptorConfig == null) {
            effectiveNDescriptorConfig = new NDescriptorEffectiveConfig();
        }
        String cacheId = null;
        if (effectiveNDescriptorConfig.equals(new NDescriptorEffectiveConfig())) {
            cacheId = "eff-nuts.cache";
        }
        if (cacheId != null && !descriptor.getId().getVersion().isBlank() && descriptor.getId().getVersion().isSingleValue() && descriptor.getId().toString().indexOf(36) < 0) {
            try {
                NDescriptor d = this.store().loadLocationKey(NLocationKey.ofCacheFaced(descriptor.getId(), null, cacheId), NDescriptor.class);
                if (d != null) {
                    return d;
                }
            }
            catch (Exception ex) {
                this.wsModel.LOG.log(NMsg.ofC("failed to load eff-nuts.cache for %s", descriptor.getId()).asError(ex));
            }
        }
        NDescriptor effectiveDescriptor = this._resolveEffectiveDescriptor(descriptor, effectiveNDescriptorConfig);
        NDescriptorUtils.checkValidEffectiveDescriptor(effectiveDescriptor);
        if (cacheId != null) {
            try {
                this.store().saveLocationKey(NLocationKey.ofCacheFaced(effectiveDescriptor.getId(), null, cacheId), effectiveDescriptor);
            }
            catch (Exception ex) {
                this.wsModel.LOG.log(NMsg.ofC("failed to save eff-nuts.cache for %s", effectiveDescriptor.getId()).asError(ex));
            }
        }
        return effectiveDescriptor;
    }

    @Override
    public NInstalledRepository getInstalledRepository() {
        return this.wsModel.installedRepository;
    }

    @Override
    public NInstallStatus getInstallStatus(NId id, boolean checkDependencies) {
        NDefinition nutToInstall;
        try {
            nutToInstall = NSearchCmd.of().setTransitive(false).addId(id).setInlineDependencies(checkDependencies).setDefinitionFilter(NDefinitionFilters.of().byDeployed(true)).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinitions().findFirst().orNull();
            if (nutToInstall == null) {
                return NInstallStatus.NONE;
            }
        }
        catch (NArtifactNotFoundException e) {
            return NInstallStatus.NONE;
        }
        catch (Exception ex) {
            this.wsModel.LOG.log(NMsg.ofJ("error: %s", ex).asError(ex));
            return NInstallStatus.NONE;
        }
        return this.getInstalledRepository().getInstallStatus(nutToInstall.getId());
    }

    @Override
    public NExecutionContextBuilder createExecutionContext() {
        NSession session = NSession.of();
        return new DefaultNExecutionContextBuilder().setDry(session.isDry()).setBot(session.isBot()).setExecutionType(this.getBootOptions().getExecutionType().orNull());
    }

    @Override
    public void deployBoot(NId id, boolean withDependencies) {
        this.runWith(() -> {
            HashMap<NId, NDefinition> defs = new HashMap<NId, NDefinition>();
            NDependencyFilter dependencyRunFilter = NDependencyFilters.of().byRunnable();
            NDefinition m = NFetchCmd.of(id).setFailFast(false).setDependencyFilter(dependencyRunFilter).getResultDefinition();
            LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
            a.put("configVersion", Nuts.getVersion().toString());
            a.put("id", id.getLongName());
            a.put("dependencies", ((NStream)m.getDependencies().get().transitive().map(NDependency::getLongName).redescribe(NElementDescribables.ofDesc("getLongName"))).collect(Collectors.joining(";")));
            defs.put(m.getId().getLongId(), m);
            if (withDependencies) {
                for (NDependency dependency : m.getDependencies().get()) {
                    if (defs.containsKey(dependency.toId().getLongId())) continue;
                    m = NFetchCmd.of(id).setFailFast(false).setDependencyFilter(dependencyRunFilter).getResultDefinition();
                    defs.put(m.getId().getLongId(), m);
                }
            }
            for (NDefinition def : defs.values()) {
                NPath bootstrapFolder = this.getLocationModel().getStoreLocation(NStoreType.LIB).resolve("id");
                NId id2 = def.getId();
                NCp.of().from(def.getContent().get()).to(bootstrapFolder.resolve(this.getDefaultIdBasedir(id2)).resolve(this.getDefaultIdFilename(id2.builder().setFaceContent().setPackaging("jar").build()))).run();
                NDescriptorFormat.of(NFetchCmd.of(id2).setDependencyFilter(dependencyRunFilter).getResultDescriptor()).setNtf(false).print(bootstrapFolder.resolve(this.getDefaultIdBasedir(id2)).resolve(this.getDefaultIdFilename(id2.builder().setFaceDescriptor().build())));
                LinkedHashMap<String, String> pr = new LinkedHashMap<String, String>();
                pr.put("file.updated.date", Instant.now().toString());
                pr.put("project.id", def.getId().getShortId().toString());
                pr.put("project.name", def.getId().getShortId().toString());
                pr.put("project.version", def.getId().getVersion().toString());
                NRepositoryDB repoDB = NRepositoryDB.of();
                pr.put("repositories", "~/.m2/repository;" + NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("vpc-public-maven", repoDB).get(), true).getConfig().getLocation() + ";" + NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("maven-central", repoDB).get(), true).getConfig().getLocation() + ";" + NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("nuts-public", repoDB).get(), true).getConfig().getLocation());
                pr.put("project.dependencies.compile", String.join((CharSequence)";", ((NStream)((NStream)def.getDependencies().get().transitive().filter(x -> !x.isOptional() && dependencyRunFilter.acceptDependency((NDependency)x, def.getId())).redescribe(NElementDescribables.ofDesc("isOptional && runnable"))).map(x -> x.toId().getLongName()).redescribe(NElementDescribables.ofDesc("toId.getLongName"))).toList()));
                try {
                    Writer writer = bootstrapFolder.resolve(this.getDefaultIdBasedir(def.getId().getLongId())).resolve("nuts.properties").getWriter();
                    try {
                        NPropsTransformer.storeProperties(pr, writer, false);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
        });
    }

    @Override
    public NSession defaultSession() {
        return this.wsModel.bootModel.bootSession();
    }

    @Override
    public NWorkspaceModel getModel() {
        return this.wsModel;
    }

    @Override
    public String getUuid() {
        return this.wsModel.uuid;
    }

    @Override
    public String getName() {
        return this.wsModel.name;
    }

    @Override
    public String getDigestName() {
        if (this.wsModel.hashName == null) {
            this.runWith(() -> {
                this.wsModel.hashName = NDigestName.of().getDigestName(this);
            });
        }
        return this.wsModel.hashName;
    }

    @Override
    public NVersion getApiVersion() {
        return Nuts.getVersion();
    }

    @Override
    public NVersion getBootVersion() {
        return Nuts.getBootVersion();
    }

    @Override
    public NId getApiId() {
        return this.wsModel.apiId;
    }

    @Override
    public NId getAppId() {
        return NId.get(this.wsModel.apiId.getGroupId(), "nuts-app", Nuts.getBootVersion()).get();
    }

    @Override
    public NId getRuntimeId() {
        return this.wsModel.runtimeId;
    }

    @Override
    public NPath getLocation() {
        return this.wsModel.location == null ? null : NPath.of(this.wsModel.location);
    }

    @Override
    public NSession createSession() {
        return this.callWith(() -> {
            DefaultNSession nSession = new DefaultNSession(this);
            nSession.setTerminal(NTerminal.of());
            nSession.setExpireTime(this.getBootOptions().getExpireTime().orNull());
            return nSession;
        });
    }

    @Override
    public DefaultNWorkspaceEnvManagerModel getEnvModel() {
        return this.wsModel.envModel;
    }

    @Override
    public DefaultCustomCommandsModel getCommandModel() {
        return this.wsModel.commandModel;
    }

    @Override
    public DefaultNWorkspaceConfigModel getConfigModel() {
        return this.wsModel.configModel;
    }

    @Override
    public DefaultImportModel getImportModel() {
        return this.wsModel.importModel;
    }

    @Override
    public String getInstallationDigest() {
        return this.wsModel.installationDigest;
    }

    @Override
    public void setInstallationDigest(String value) {
        this.wsModel.installationDigest = value;
        this.store().saveLocationKey(NLocationKey.ofConf(this.getApiId(), null, "installation-digest"), NStringUtils.trimToNull(value));
    }

    @Override
    public NExtensions extensions() {
        return this.wsModel.extensions;
    }

    @Override
    public NSession currentSession() {
        NSession old = this.wsModel.sessionScopes.get();
        if (old == null) {
            return this.defaultSession();
        }
        return old;
    }

    @Override
    public NScopedValue<NSession> sessionScopes() {
        return this.wsModel.sessionScopes;
    }

    @Override
    public DefaultNRepositoryModel getRepositoryModel() {
        return this.wsModel.repositoryModel;
    }

    @Override
    public List<NRepository> getRepositories() {
        return Arrays.stream(this.getRepositoryModel().getRepositories()).collect(Collectors.toList());
    }

    @Override
    public NOptional<NRepository> findRepositoryById(String repositoryNameOrId) {
        return this.getRepositoryModel().findRepositoryById(repositoryNameOrId);
    }

    @Override
    public NOptional<NRepository> findRepositoryByName(String repositoryNameOrId) {
        return this.getRepositoryModel().findRepositoryByName(repositoryNameOrId);
    }

    @Override
    public NOptional<NRepository> findRepository(String repositoryNameOrId) {
        return this.getRepositoryModel().findRepository(repositoryNameOrId);
    }

    @Override
    public NWorkspace removeRepository(String repositoryId) {
        this.getRepositoryModel().removeRepository(repositoryId);
        return this;
    }

    @Override
    public NWorkspace removeAllRepositories() {
        this.getRepositoryModel().removeAllRepositories();
        return this;
    }

    @Override
    public NRepository addRepository(NAddRepositoryOptions options) {
        return this.getRepositoryModel().addRepository(options);
    }

    @Override
    public NRepository addRepository(String repositoryNamedUrl) {
        return this.getRepositoryModel().addRepository(repositoryNamedUrl);
    }

    public DefaultNWorkspaceLocationModel getLocationsModel() {
        return this.wsModel.locationsModel;
    }

    public DefaultNPlatformModel getSdkModel() {
        return this.wsModel.sdkModel;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.getEnvModel().getProperties();
    }

    @Override
    public NOptional<Object> getProperty(String property) {
        return this.getEnvModel().getProperty(property);
    }

    @Override
    public <T> NOptional<T> getProperty(Class<T> propertyTypeAndName) {
        if (propertyTypeAndName == null) {
            return NOptional.ofNamedEmpty("<empty-type>");
        }
        return this.getProperty(propertyTypeAndName.getName()).instanceOf(propertyTypeAndName);
    }

    @Override
    public <T> T getOrComputeProperty(Class<T> property, Supplier<T> supplier) {
        return this.getOrComputeProperty(property.getName(), supplier);
    }

    @Override
    public <T> T getOrComputeProperty(String property, Supplier<T> supplier) {
        return this.getEnvModel().getOrCreateProperty(property, supplier);
    }

    @Override
    public NWorkspace setProperty(String property, Object value) {
        this.getEnvModel().setProperty(property, value);
        return this;
    }

    @Override
    public NOsFamily getOsFamily() {
        return this.getEnvModel().getOsFamily();
    }

    @Override
    public String getHostName() {
        return this.getEnvModel().getHostName();
    }

    @Override
    public String getPid() {
        return this.getEnvModel().getPid();
    }

    @Override
    public Set<NShellFamily> getShellFamilies() {
        return this.getEnvModel().getShellFamilies();
    }

    @Override
    public NShellFamily getShellFamily() {
        return this.getEnvModel().getShellFamily();
    }

    @Override
    public NId getDesktopEnvironment() {
        return (NId)this.getDesktopEnvironments().stream().findFirst().get();
    }

    @Override
    public Set<NId> getDesktopEnvironments() {
        return this.getEnvModel().getDesktopEnvironments();
    }

    @Override
    public NDesktopEnvironmentFamily getDesktopEnvironmentFamily() {
        return this.getEnvModel().getDesktopEnvironmentFamily();
    }

    @Override
    public Set<NDesktopEnvironmentFamily> getDesktopEnvironmentFamilies() {
        return this.getEnvModel().getDesktopEnvironmentFamilies();
    }

    @Override
    public NId getPlatform() {
        return this.getEnvModel().getPlatform();
    }

    @Override
    public NId getOs() {
        return this.getEnvModel().getOs();
    }

    @Override
    public NId getOsDist() {
        return this.getEnvModel().getOsDist();
    }

    @Override
    public NId getArch() {
        return this.getEnvModel().getArch();
    }

    @Override
    public NArchFamily getArchFamily() {
        return this.getEnvModel().getArchFamily();
    }

    @Override
    public boolean isGraphicalDesktopEnvironment() {
        return this.getEnvModel().isGraphicalDesktopEnvironment();
    }

    @Override
    public NSupportMode getDesktopIntegrationSupport(NDesktopIntegrationItem item) {
        NAssert.requireNonBlank(item, "item");
        switch (item) {
            case DESKTOP: {
                NSupportMode a = this.getBootOptions().getDesktopLauncher().orNull();
                if (a == null) break;
                return a;
            }
            case MENU: {
                NSupportMode a = this.getBootOptions().getMenuLauncher().orNull();
                if (a == null) break;
                return a;
            }
            case USER: {
                NSupportMode a = this.getBootOptions().getUserLauncher().orNull();
                if (a == null) break;
                return a;
            }
        }
        switch (this.getOsFamily()) {
            case LINUX: {
                switch (item) {
                    case DESKTOP: {
                        return NSupportMode.SUPPORTED;
                    }
                    case MENU: {
                        return NSupportMode.PREFERRED;
                    }
                    case USER: {
                        return NSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case UNIX: {
                return NSupportMode.NEVER;
            }
            case WINDOWS: {
                switch (item) {
                    case DESKTOP: {
                        if (Files.isDirectory(this.getDesktopPath(), new LinkOption[0])) {
                            return NSupportMode.PREFERRED;
                        }
                        return NSupportMode.SUPPORTED;
                    }
                    case MENU: {
                        return NSupportMode.PREFERRED;
                    }
                    case USER: {
                        return NSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case MACOS: {
                return NSupportMode.NEVER;
            }
            case UNKNOWN: {
                return NSupportMode.NEVER;
            }
        }
        return NSupportMode.NEVER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path getDesktopPath() {
        switch (this.getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case MACOS: {
                File f = new File(System.getProperty("user.home"), ".config/user-dirs.dirs");
                if (f.exists()) {
                    try (BufferedReader r = new BufferedReader(new FileReader(f));){
                        String line;
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#")) continue;
                            Matcher m = UNIX_USER_DIRS_PATTERN.matcher(line);
                            if (m.find()) {
                                String k = m.group("k");
                                if (!k.equals("XDG_DESKTOP_DIR")) continue;
                                String v = m.group("v");
                                if ((v = v.trim()).startsWith("\"")) {
                                    int last = v.indexOf(34, 1);
                                    String s = v.substring(1, last);
                                    s = s.replace("$HOME", System.getProperty("user.home"));
                                    Path path = Paths.get(s, new String[0]);
                                    return path;
                                }
                                Path path = Paths.get(v, new String[0]);
                                return path;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
            case WINDOWS: {
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
        }
        return new File(System.getProperty("user.home"), "Desktop").toPath();
    }

    @Override
    public void addLauncher(NLauncherOptions launcher) {
        SystemNdi ndi;
        NIsolationLevel isolation = this.getBootOptions().getIsolationLevel().orElse(NIsolationLevel.SYSTEM);
        if (isolation.compareTo(NIsolationLevel.CONFINED) >= 0) {
            launcher.setCreateDesktopLauncher(NSupportMode.NEVER);
            launcher.setCreateMenuLauncher(NSupportMode.NEVER);
            launcher.setCreateUserLauncher(NSupportMode.NEVER);
            launcher.setSwitchWorkspace(false);
            launcher.setSwitchWorkspaceLocation(null);
        }
        if ((ndi = NSettingsNdiSubCommand.createNdi()) != null) {
            ndi.addScript(new NdiScriptOptions().setLauncher(launcher.copy()), new String[]{launcher.getId().builder().getFullName()});
        }
    }

    @Override
    public List<String> buildEffectiveCommand(String[] cmd, NRunAs runAsMode, Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich, Boolean gui, String rootName, String userName, String[] executorOptions) {
        return NSysExecUtils.buildEffectiveCommand(cmd, runAsMode, de, sysWhich, gui, rootName, userName, executorOptions);
    }

    @Override
    public NPath getHomeLocation(NStoreType folderType) {
        return this.getLocationModel().getHomeLocation(folderType);
    }

    @Override
    public DefaultNWorkspaceLocationModel getLocationModel() {
        return NWorkspaceExt.of().getModel().locationsModel;
    }

    @Override
    public NPath getStoreLocation(NStoreType folderType) {
        return this.getLocationModel().getStoreLocation(folderType);
    }

    @Override
    public NPath getStoreLocation(NId id, NStoreType folderType) {
        return this.getLocationModel().getStoreLocation(id, folderType);
    }

    @Override
    public NPath getStoreLocation(NStoreType folderType, String repositoryIdOrName) {
        return this.getLocationModel().getStoreLocation(folderType, repositoryIdOrName);
    }

    @Override
    public NPath getStoreLocation(NId id, NStoreType folderType, String repositoryIdOrName) {
        return this.getLocationModel().getStoreLocation(id, folderType, repositoryIdOrName);
    }

    @Override
    public NPath getStoreLocation(NLocationKey nLocationKey) {
        return this.getLocationModel().getStoreLocation(nLocationKey);
    }

    @Override
    public NStoreStrategy getStoreStrategy() {
        return this.getLocationModel().getStoreStrategy();
    }

    @Override
    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.getLocationModel().getRepositoryStoreStrategy();
    }

    @Override
    public NOsFamily getStoreLayout() {
        return this.getLocationModel().getStoreLayout();
    }

    @Override
    public Map<NStoreType, String> getStoreLocations() {
        return this.getLocationModel().getStoreLocations();
    }

    @Override
    public String getDefaultIdFilename(NId id) {
        return this.getLocationModel().getDefaultIdFilename(id);
    }

    @Override
    public NPath getDefaultIdBasedir(NId id) {
        return this.getLocationModel().getDefaultIdBasedir(id);
    }

    @Override
    public String getDefaultIdContentExtension(String packaging) {
        return this.getLocationModel().getDefaultIdContentExtension(packaging);
    }

    @Override
    public String getDefaultIdExtension(NId id) {
        return this.getLocationModel().getDefaultIdExtension(id);
    }

    @Override
    public Map<NHomeLocation, String> getHomeLocations() {
        return this.getLocationModel().getHomeLocations();
    }

    @Override
    public NPath getHomeLocation(NHomeLocation location) {
        return this.getLocationModel().getHomeLocation(location);
    }

    @Override
    public NPath getWorkspaceLocation() {
        return this.getLocationModel().getWorkspaceLocation();
    }

    @Override
    public NWorkspace setStoreLocation(NStoreType folderType, String location) {
        this.getLocationModel().setStoreLocation(folderType, location);
        return this;
    }

    @Override
    public NWorkspace setStoreStrategy(NStoreStrategy strategy) {
        this.getLocationModel().setStoreStrategy(strategy);
        return this;
    }

    @Override
    public NWorkspace setStoreLayout(NOsFamily storeLayout) {
        this.getLocationModel().setStoreLayout(storeLayout);
        return this;
    }

    @Override
    public NWorkspace setHomeLocation(NHomeLocation homeType, String location) {
        this.getLocationModel().setHomeLocation(homeType, location);
        return this;
    }

    @Override
    public boolean addPlatform(NPlatformLocation location) {
        return this.getSdkModel().addPlatform(location);
    }

    @Override
    public boolean updatePlatform(NPlatformLocation oldLocation, NPlatformLocation newLocation) {
        return this.getSdkModel().updatePlatform(oldLocation, newLocation);
    }

    @Override
    public boolean removePlatform(NPlatformLocation location) {
        return this.getSdkModel().removePlatform(location);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatformByName(NPlatformFamily platformType, String locationName) {
        return this.getSdkModel().findPlatformByName(platformType, locationName);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatformByPath(NPlatformFamily platformType, NPath path) {
        return this.getSdkModel().findPlatformByPath(platformType, path);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily platformType, String version) {
        return this.getSdkModel().findPlatformByVersion(platformType, version);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatform(NPlatformLocation location) {
        return this.getSdkModel().findPlatform(location);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily platformType, NVersionFilter requestedVersion) {
        return this.getSdkModel().findPlatformByVersion(platformType, requestedVersion);
    }

    @Override
    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily platformFamily) {
        return this.getSdkModel().searchSystemPlatforms(platformFamily);
    }

    @Override
    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily platformFamily, NPath path) {
        return this.getSdkModel().searchSystemPlatforms(platformFamily, path);
    }

    @Override
    public NOptional<NPlatformLocation> resolvePlatform(NPlatformFamily platformFamily, NPath path, String preferredName) {
        return this.getSdkModel().resolvePlatform(platformFamily, path, preferredName);
    }

    @Override
    public NOptional<NPlatformLocation> findPlatform(NPlatformFamily platformFamily, Predicate<NPlatformLocation> filter) {
        return this.getSdkModel().findOnePlatform(platformFamily, filter);
    }

    @Override
    public NStream<NPlatformLocation> findPlatforms(NPlatformFamily platformFamily, Predicate<NPlatformLocation> filter) {
        return this.getSdkModel().findPlatforms(platformFamily, filter);
    }

    @Override
    public NStream<NPlatformLocation> findPlatforms() {
        return this.findPlatforms(null, null);
    }

    @Override
    public NWorkspace addDefaultPlatforms(NPlatformFamily type) {
        if (type == NPlatformFamily.JAVA) {
            NWorkspaceUtils.of(this).installAllJVM();
        }
        return this;
    }

    @Override
    public NWorkspace addDefaultPlatform(NPlatformFamily type) {
        if (type == NPlatformFamily.JAVA) {
            NWorkspaceUtils.of(this).installCurrentJVM();
        }
        return this;
    }

    @Override
    public NOptional<String> findSysCommand(String commandName) {
        char pathSeparatorChar = File.pathSeparatorChar;
        if (!(NBlankable.isBlank(commandName) || commandName.contains("/") || commandName.contains("\\") || commandName.equals(".") || commandName.equals(".."))) {
            switch (NWorkspace.of().getOsFamily()) {
                case WINDOWS: {
                    List<String> paths = NStringUtils.split(NWorkspace.of().getSysEnv("PATH").orNull(), "" + pathSeparatorChar, true, true);
                    List<String> execExtensions = NStringUtils.split(NWorkspace.of().getSysEnv("PATHEXT").orNull(), "" + pathSeparatorChar, true, true);
                    if (paths.isEmpty()) {
                        paths.addAll(Arrays.asList("C:\\Windows\\system32", "C:\\Windows"));
                    }
                    if (execExtensions.isEmpty()) {
                        execExtensions.addAll(Arrays.asList(".COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC"));
                    }
                    for (String z : paths) {
                        NPath t = NPath.of(z);
                        NPath p = t.resolve(commandName);
                        if (p.isRegularFile()) {
                            return NOptional.of(p.toString());
                        }
                        for (String ext : execExtensions) {
                            ext = ext.toLowerCase();
                            if (commandName.toLowerCase().endsWith(ext) || !(p = t.resolve(commandName + ext)).isRegularFile()) continue;
                            return NOptional.of(p.toString());
                        }
                    }
                    break;
                }
                default: {
                    List<String> paths = NStringUtils.split(NWorkspace.of().getSysEnv("PATH").orNull(), "" + pathSeparatorChar, true, true);
                    for (String z : paths) {
                        NPath t = NPath.of(z);
                        NPath p = t.resolve(commandName);
                        if (!p.isRegularFile()) continue;
                        return NOptional.of(p.toString());
                    }
                }
            }
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("command %s", commandName));
    }

    @Override
    public NOptional<String> getSysEnv(String name) {
        return NOptional.of(this.getSysEnv().get(name));
    }

    @Override
    public Map<String, String> getSysEnv() {
        return this.getConfigModel().sysEnv();
    }

    @Override
    public NStream<NPlatformLocation> findPlatforms(NPlatformFamily type) {
        return this.getSdkModel().findPlatforms(type, null);
    }

    @Override
    public NWorkspace addImports(String ... importExpressions) {
        this.getImportModel().add(importExpressions);
        return this;
    }

    @Override
    public NWorkspace clearImports() {
        this.getImportModel().removeAll();
        return this;
    }

    @Override
    public NWorkspace removeImports(String ... importExpressions) {
        this.getImportModel().remove(importExpressions);
        return this;
    }

    @Override
    public NWorkspace updateImports(String[] imports) {
        this.getImportModel().set(imports);
        return this;
    }

    @Override
    public boolean isImportedGroupId(String groupId) {
        return this.getImportModel().isImportedGroupId(groupId);
    }

    @Override
    public Set<String> getAllImports() {
        return this.getImportModel().getAll();
    }

    @Override
    public NWorkspaceStoredConfig getStoredConfig() {
        return this.getConfigModel().stored();
    }

    @Override
    public boolean isReadOnly() {
        return this.getConfigModel().isReadOnly();
    }

    @Override
    public boolean saveConfig(boolean force) {
        return this.getConfigModel().save(force);
    }

    @Override
    public boolean saveConfig() {
        return this.getConfigModel().save();
    }

    @Override
    public NWorkspaceBootConfig loadBootConfig(String _ws, boolean global, boolean followLinks) {
        String _ws0 = _ws;
        String effWorkspaceName = null;
        String lastConfigPath = null;
        NWorkspaceConfigBoot lastConfigLoaded = null;
        boolean defaultLocation = false;
        NPlatformHome plocs = NPlatformHome.of(null, global);
        if (_ws != null && _ws.matches("[a-z-]+://.*")) {
            effWorkspaceName = "remote-bootstrap";
            lastConfigPath = plocs.getWorkspaceLocation(CoreNUtils.resolveValidWorkspaceName(effWorkspaceName));
            lastConfigLoaded = this.store().loadWorkspaceConfigBoot(NPath.of(lastConfigPath));
            defaultLocation = true;
            return new DefaultNWorkspaceBootConfig(_ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        if (followLinks) {
            defaultLocation = CoreNUtils.isValidWorkspaceName(_ws);
            int maxDepth = 36;
            for (int i = 0; i < maxDepth; ++i) {
                lastConfigPath = CoreNUtils.isValidWorkspaceName(_ws) ? plocs.getWorkspaceLocation(CoreNUtils.resolveValidWorkspaceName(_ws)) : NIOUtils.getAbsolutePath(_ws);
                NWorkspaceConfigBoot configLoaded = this.store().loadWorkspaceConfigBoot(NPath.of(lastConfigPath));
                if (configLoaded == null) break;
                if (NBlankable.isBlank(configLoaded.getWorkspace())) {
                    lastConfigLoaded = configLoaded;
                    break;
                }
                _ws = configLoaded.getWorkspace();
                if (i < maxDepth - 1) continue;
                throw new NIllegalArgumentException(NMsg.ofPlain("cyclic workspace resolution"));
            }
            if (lastConfigLoaded == null) {
                return null;
            }
            effWorkspaceName = CoreNUtils.resolveValidWorkspaceName(_ws);
            return new DefaultNWorkspaceBootConfig(_ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        defaultLocation = CoreNUtils.isValidWorkspaceName(_ws);
        lastConfigPath = CoreNUtils.isValidWorkspaceName(_ws) ? plocs.getWorkspaceLocation(CoreNUtils.resolveValidWorkspaceName(_ws)) : NIOUtils.getAbsolutePath(_ws);
        lastConfigLoaded = this.store().loadWorkspaceConfigBoot(NPath.of(lastConfigPath));
        if (lastConfigLoaded == null) {
            return null;
        }
        effWorkspaceName = CoreNUtils.resolveValidWorkspaceName(_ws);
        return new DefaultNWorkspaceBootConfig(_ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
    }

    @Override
    public boolean isSupportedRepositoryType(String repositoryType) {
        return this.getConfigModel().isSupportedRepositoryType(repositoryType);
    }

    @Override
    public List<NAddRepositoryOptions> getDefaultRepositories() {
        return this.getConfigModel().getDefaultRepositories();
    }

    @Override
    public Set<String> getAvailableArchetypes() {
        return this.getConfigModel().getAvailableArchetypes();
    }

    @Override
    public NPath resolveRepositoryPath(String repositoryLocation) {
        return this.getConfigModel().resolveRepositoryPath(NPath.of(repositoryLocation));
    }

    @Override
    public NIndexStoreFactory getIndexStoreClientFactory() {
        return this.getConfigModel().getIndexStoreClientFactory();
    }

    @Override
    public String getJavaCommand() {
        return this.getConfigModel().getJavaCommand();
    }

    @Override
    public String getJavaOptions() {
        return this.getConfigModel().getJavaOptions();
    }

    @Override
    public boolean isSystemWorkspace() {
        return this.getConfigModel().isSystem();
    }

    @Override
    public List<String> getDependencySolverNames() {
        return this.getConfigModel().getDependencySolverNames();
    }

    @Override
    public NDependencySolver createDependencySolver(String name) {
        return this.getConfigModel().createDependencySolver(name);
    }

    @Override
    public Map<String, String> getConfigMap() {
        return this.getConfigModel().getConfigMap();
    }

    @Override
    public NOptional<NLiteral> getConfigProperty(String property) {
        return this.getConfigModel().getConfigProperty(property);
    }

    @Override
    public NWorkspace setConfigProperty(String property, String value) {
        this.getConfigModel().setConfigProperty(property, value);
        this.getConfigModel().save();
        return this;
    }

    @Override
    public List<NCommandFactoryConfig> getCommandFactories() {
        return Arrays.asList(this.getCommandModel().getFactories());
    }

    @Override
    public void addCommandFactory(NCommandFactoryConfig commandFactoryConfig) {
        this.getCommandModel().addFactory(commandFactoryConfig);
    }

    @Override
    public void removeCommandFactory(String commandFactoryId) {
        this.getCommandModel().removeFactory(commandFactoryId);
    }

    @Override
    public boolean removeCommandFactoryIfExists(String commandFactoryId) {
        return this.getCommandModel().removeFactoryIfExists(commandFactoryId);
    }

    @Override
    public boolean commandExists(String command) {
        return this.findCommand(command) != null;
    }

    @Override
    public boolean commandFactoryExists(String factoryId) {
        return this.getCommandModel().commandFactoryExists(factoryId);
    }

    @Override
    public boolean addCommand(NCommandConfig command) {
        return this.getCommandModel().add(command);
    }

    @Override
    public boolean updateCommand(NCommandConfig command) {
        return this.getCommandModel().update(command);
    }

    @Override
    public void removeCommand(String command) {
        this.getCommandModel().remove(command);
    }

    @Override
    public boolean removeCommandIfExists(String name) {
        if (this.getCommandModel().find(name) != null) {
            this.getCommandModel().remove(name);
            return true;
        }
        return false;
    }

    @Override
    public NCustomCmd findCommand(String name, NId forId, NId forOwner) {
        return this.getCommandModel().find(name, forId, forOwner);
    }

    @Override
    public NCustomCmd findCommand(String name) {
        return this.getCommandModel().find(name);
    }

    @Override
    public List<NCustomCmd> findAllCommands() {
        return this.getCommandModel().findAll();
    }

    @Override
    public List<NCustomCmd> findCommandsByOwner(NId id) {
        return this.getCommandModel().findByOwner(id);
    }

    public DefaultNBootModel getBootModel() {
        return NWorkspaceExt.of().getModel().bootModel;
    }

    @Override
    public boolean isFirstBoot() {
        return this.getBootModel().isFirstBoot();
    }

    @Override
    public NOptional<NLiteral> getCustomBootOption(String ... names) {
        return this.getBootModel().getCustomBootOption(names);
    }

    @Override
    public NBootOptions getBootOptions() {
        return this.getBootModel().getBootEffectiveOptions();
    }

    @Override
    public ClassLoader getBootClassLoader() {
        return this.getConfigModel().getBootClassLoader();
    }

    @Override
    public List<URL> getBootClassWorldURLs() {
        return Collections.unmodifiableList(this.getConfigModel().getBootClassWorldURLs());
    }

    @Override
    public List<String> getBootRepositories() {
        return this.getConfigModel().getBootRepositories();
    }

    @Override
    public Instant getCreationStartTime() {
        return this.getConfigModel().getCreationStartTime();
    }

    @Override
    public Instant getCreationFinishTime() {
        return this.getConfigModel().getCreationFinishTime();
    }

    @Override
    public NDuration getCreationDuration() {
        return this.getConfigModel().getCreateDuration();
    }

    @Override
    public NClassLoaderNode getBootRuntimeClassLoaderNode() {
        return this.getBootModel().getBootUserOptions().getRuntimeBootDependencyNode().get();
    }

    @Override
    public List<NClassLoaderNode> getBootExtensionClassLoaderNode() {
        return this.getBootModel().getBootUserOptions().getExtensionBootDependencyNodes().orElseGet(Collections::emptyList);
    }

    @Override
    public NWorkspaceTerminalOptions getBootTerminal() {
        return this.getBootModel().getBootTerminal();
    }

    private static class InitWorkspaceData {
        NBootOptions initialBootOptions;
        NBootOptions effectiveBootOptions;
        List<String> bootRepositories;
        NTexts text;
        NElementFactory elems;
        boolean justInstalled;
        NWorkspaceArchetypeComponent justInstalledArchetype;
        NBootConfig cfg;
        NIO terminals;

        private InitWorkspaceData() {
        }
    }

    public static enum InstallStrategy0 implements NEnum
    {
        INSTALL,
        UPDATE,
        REQUIRE;

        private final String id = NNameFormat.ID_NAME.format(this.name());

        public static NOptional<InstallStrategy0> parse(String value) {
            return NEnumUtils.parseEnum(value, InstallStrategy0.class);
        }

        @Override
        public String id() {
            return this.id;
        }
    }
}

