/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.format;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NVersionFormat;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNVersionFormat
extends DefaultFormatBase<NVersionFormat>
implements NVersionFormat {
    private final Map<String, String> extraProperties = new LinkedHashMap<String, String>();
    private boolean all;
    private NVersion version;

    public DefaultNVersionFormat(NWorkspace workspace) {
        super("version");
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        boolean enabled = aa.isUncommented();
        switch (aa.key()) {
            case "-a": 
            case "--all": {
                cmdLine.matcher().matchFlag(v -> {
                    this.all = v.booleanValue();
                }).anyMatch();
                return true;
            }
            case "--add": {
                NArg aa2 = cmdLine.nextEntry().get();
                NArg r = NArg.of(aa2.getStringValue().get());
                if (enabled) {
                    this.all = true;
                    this.extraProperties.put(r.key(), r.getStringValue().get());
                }
                return true;
            }
        }
        return NSession.of().configureFirst(cmdLine);
    }

    @Override
    public NVersionFormat addProperty(String key, String value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
        return this;
    }

    @Override
    public NVersionFormat addProperties(Map<String, String> p) {
        if (p != null) {
            for (Map.Entry<String, String> entry : p.entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public NVersion getVersion() {
        return this.version;
    }

    @Override
    public NVersionFormat setVersion(NVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isWorkspaceVersion() {
        return this.version == null;
    }

    @Override
    public void print(NPrintStream out) {
        NSession session = NSession.of();
        if (!this.isNtf()) {
            out = out.setTerminalMode(NTerminalMode.FILTERED);
        }
        if (NOut.isPlain()) {
            if (this.isWorkspaceVersion()) {
                out.print(NMsg.ofC("%s/%s", session.getWorkspace().getApiVersion(), session.getWorkspace().getRuntimeId().getVersion()));
            } else {
                out.print(NText.ofStyled(this.getVersion().toString(), NTextStyle.version()));
            }
        } else if (this.isWorkspaceVersion()) {
            out.print(this.buildProps());
        } else {
            out.print(NText.ofStyled(this.getVersion().toString(), NTextStyle.version()));
        }
    }

    public Map<String, String> buildProps() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        TreeSet<Object> extraKeys = new TreeSet();
        if (this.extraProperties != null) {
            extraKeys = new TreeSet<String>(this.extraProperties.keySet());
        }
        NWorkspace workspace = NWorkspace.of();
        props.put("nuts-api-version", workspace.getApiVersion().toString());
        props.put("nuts-runtime-version", workspace.getRuntimeId().getVersion().toString());
        if (this.all) {
            props.put("java-version", System.getProperty("java.version"));
            props.put("os-version", workspace.getOs().getVersion().toString());
        }
        for (String string : extraKeys) {
            props.put(string, this.extraProperties.get(string));
        }
        return props;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

