/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.runtime.standalone.util.filters.NTypedFiltersParser;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterTrue;
import net.thevpc.nuts.spi.base.AbstractVersionFilter;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NVersionFilterParser
extends NTypedFiltersParser<NVersionFilter> {
    private NVersionComparator comparator;

    public NVersionFilterParser(String str, NVersionComparator comparator) {
        super(str);
        this.comparator = comparator;
    }

    protected NVersionFilters getTManager() {
        return NVersionFilters.of();
    }

    @Override
    protected NVersionFilter wordToPredicate(String word) {
        switch (word.toLowerCase()) {
            default: 
        }
        return (NVersionFilter)super.wordToPredicate(word);
    }

    private NVersion asVersion() {
        String s = this.str.getContent().trim();
        if (s.isEmpty()) {
            return null;
        }
        NVersion e = NVersion.get(s).orNull();
        if (e != null) {
            switch (e.getValue()) {
                case "true": 
                case "false": {
                    return null;
                }
            }
            return e;
        }
        return null;
    }

    @Override
    public NVersionFilter parse() {
        List<NVersionInterval> intervals;
        if (NBlankable.isBlank(this.str.getContent())) {
            return new NVersionFilterTrue();
        }
        NVersion v = this.asVersion();
        if (v != null && (intervals = v.intervals().orNull()) != null && intervals.size() > 0) {
            return new NVersionIntervalsVersionFilter(v, this.comparator);
        }
        return (NVersionFilter)super.parse();
    }

    private class NVersionIntervalsVersionFilter
    extends AbstractVersionFilter {
        private final NVersion version;
        private final NVersionComparator versionComparator;

        public NVersionIntervalsVersionFilter(NVersion version, NVersionComparator versionComparator) {
            super(NFilterOp.CUSTOM);
            this.version = version;
            this.versionComparator = versionComparator;
        }

        @Override
        public NVersionFilter simplify() {
            return this;
        }

        @Override
        public boolean acceptVersion(NVersion version) {
            for (NVersionInterval i : (List)version.intervals(this.versionComparator).orElse(new ArrayList())) {
                if (!i.acceptVersion(version)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            List intervals = this.version.intervals(this.versionComparator).orElse(new ArrayList());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < intervals.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(intervals.get(i));
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NVersionIntervalsVersionFilter that = (NVersionIntervalsVersionFilter)o;
            return Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.version);
        }
    }
}

