/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.id.filter.NExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.base.AbstractVersionFilter;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NVersionFilterNone
extends AbstractVersionFilter
implements NExprIdFilter {
    private NVersionFilter[] all;

    public NVersionFilterNone(NVersionFilter ... all) {
        super(NFilterOp.NOT);
        ArrayList<NVersionFilter> valid = new ArrayList<NVersionFilter>();
        if (all != null) {
            for (NVersionFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NVersionFilter[0]);
    }

    @Override
    public boolean acceptVersion(NVersion id) {
        if (this.all.length == 0) {
            return true;
        }
        for (NVersionFilter filter : this.all) {
            if (!filter.acceptVersion(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NVersionFilter simplify() {
        return CoreFilterUtils.simplifyFilterNone(NVersionFilter.class, this, this.all);
    }

    @Override
    public String toExpr() {
        StringBuilder sb = new StringBuilder();
        if (this.all.length == 0) {
            return "true";
        }
        if (this.all.length > 1) {
            sb.append("(");
        }
        for (NVersionFilter id : this.all) {
            String expr;
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            if (id instanceof NExprIdFilter) {
                NExprIdFilter b = (NExprIdFilter)((Object)id);
                expr = b.toExpr();
                if (NBlankable.isBlank(expr)) {
                    return null;
                }
            } else {
                return null;
            }
            sb.append("(").append(expr).append("')");
        }
        if (this.all.length > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NVersionFilterNone other = (NVersionFilterNone)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    public String toString() {
        return CoreStringUtils.trueOrNone(Arrays.stream(this.all).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.all);
    }
}

