/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIterable;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NUnexpectedException;

public class NStreamFromNIterable<T>
extends NStreamBase<T> {
    private final NIterable<T> o;

    public NStreamFromNIterable(String nutsBase, NIterable<T> o) {
        super(nutsBase);
        this.o = o;
    }

    @Override
    public List<T> toList() {
        Iterator source = this.iterator();
        ArrayList target = new ArrayList();
        source.forEachRemaining(target::add);
        return target;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.o.spliterator(), false);
    }

    @Override
    public NIterator<T> iterator() {
        return this.o.iterator();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.o);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NStreamFromNIterable other = (NStreamFromNIterable)obj;
        return Objects.equals(this.o, other.o);
    }

    public String toString() {
        return "IterableBasedResult@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public void close() {
        if (this.o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.o)).close();
            }
            catch (Exception e) {
                throw new NUnexpectedException(NMsg.ofC("unable to close iterator : %s", e));
            }
        }
        super.close();
    }
}

