/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.internal.rpi.NCollectionsRPI;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamEmpty;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromCollection;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromJavaStream;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromList;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromNIterable;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromNIterator;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NIterable;
import net.thevpc.nuts.util.NIterableFromJavaIterable;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBaseFromJavaIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

@NComponentScope(value=NScopeType.SESSION)
public class DefaultNCollectionsRPI
implements NCollectionsRPI {
    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public <T> NStream<T> arrayToStream(T[] str) {
        String name = null;
        if (str == null) {
            return new NStreamEmpty(name);
        }
        return (NStream)this.iterableToStream(Arrays.asList(str)).redescribe(() -> NElement.ofString("array"));
    }

    @Override
    public <T> NStream<T> iterableToStream(Iterable<T> str) {
        String name = null;
        if (str == null) {
            return new NStreamEmpty(name);
        }
        if (str instanceof List) {
            return new NStreamFromList(name, (List)str);
        }
        if (str instanceof Collection) {
            return new NStreamFromCollection(name, (Collection)str);
        }
        return new NStreamFromNIterable<T>(name, NIterable.of(str));
    }

    @Override
    public <T> NStream<T> iteratorToStream(Iterator<T> str) {
        return new NStreamFromNIterator<T>(null, NIterator.of(str));
    }

    @Override
    public <T> NStream<T> toStream(Stream<T> str) {
        return new NStreamFromJavaStream<T>(null, str);
    }

    @Override
    public <T> NStream<T> emptyStream() {
        return new NStreamEmpty(null);
    }

    @Override
    public <T> NIterator<T> emptyIterator() {
        return NIteratorBuilder.emptyIterator();
    }

    @Override
    public <T> NIterator<T> toIterator(Iterator<T> str) {
        if (str == null) {
            return null;
        }
        if (str instanceof NIterator) {
            return (NIterator)str;
        }
        return new NIteratorBaseFromJavaIterator<T>(str);
    }

    @Override
    public <T> NIterable<T> toIterable(Iterable<T> o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NIterable) {
            return (NIterable)o;
        }
        return new NIterableFromJavaIterable<T>(o);
    }

    @Override
    public <T> NStream<T> optionalToStream(Optional<T> item) {
        if (item == null || !item.isPresent()) {
            return this.emptyStream();
        }
        return NStream.ofArray(item.get());
    }

    @Override
    public <T> NStream<T> optionalToStream(NOptional<T> item) {
        if (item == null || !item.isPresent() || item.isError()) {
            return this.emptyStream();
        }
        return NStream.ofArray(item.get());
    }
}

