/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.jclass;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPom;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassByteCode;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.runtime.standalone.xtra.execentries.DefaultNExecutionEntry;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NStringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaJarUtils {
    public static NVersion[] parseJarClassVersions(InputStream jarStream) {
        if (!(jarStream instanceof BufferedInputStream)) {
            jarStream = new BufferedInputStream(jarStream);
        }
        final HashSet classes = new HashSet();
        ZipUtils.visitZipStream(jarStream, (path, inputStream) -> {
            if (path.endsWith(".class")) {
                JavaClassByteCode.Visitor cl = new JavaClassByteCode.Visitor(){

                    @Override
                    public NVisitResult visitVersion(int major, int minor) {
                        classes.add(JavaClassUtils.classVersionToSourceVersion(major, minor));
                        return NVisitResult.TERMINATE;
                    }
                };
                JavaClassByteCode javaClassByteCode = new JavaClassByteCode(new BufferedInputStream(inputStream), cl);
            }
            return NVisitResult.CONTINUE;
        });
        return (NVersion[])classes.stream().map(x -> NVersion.get(x).get()).toArray(NVersion[]::new);
    }

    public static NVersion parseJarClassVersion(InputStream jarStream) {
        NVersion[] all = JavaJarUtils.parseJarClassVersions(jarStream);
        if (all.length == 0) {
            return null;
        }
        NVersion nb = all[0];
        for (int i = 1; i < all.length; ++i) {
            if (nb.compareTo(all[i]) >= 0) continue;
            nb = all[i];
        }
        return nb;
    }

    public static List<NExecutionEntry> parseJarExecutionEntries(InputStream jarStream) {
        if (!(jarStream instanceof BufferedInputStream)) {
            jarStream = new BufferedInputStream(jarStream);
        }
        LinkedHashSet classes = new LinkedHashSet();
        ZipUtils.visitZipStream(jarStream, (path, inputStream) -> {
            if (path.endsWith(".class")) {
                NExecutionEntry mainClass = JavaClassUtils.parseClassExecutionEntry(inputStream, path);
                if (mainClass != null) {
                    classes.add(mainClass);
                }
            } else if (path.equals("META-INF/MANIFEST.MF")) {
                String v;
                Manifest manifest = new Manifest(inputStream);
                Attributes a = manifest.getMainAttributes();
                if (a != null && !NBlankable.isBlank(v = a.getValue("Main-Class"))) {
                    v = NStringUtils.trim(v);
                    classes.add(new DefaultNExecutionEntry(v, true, false));
                }
            } else if (path.startsWith("META-INF/maven/") && path.endsWith("/pom.xml")) {
                String springStartClass;
                NPom pom = new NPomXmlParser().parse(inputStream);
                Element ee = pom.getXml().getDocumentElement();
                if (pom.getParent() != null && pom.getParent().getArtifactId().equals("spring-boot-starter-parent") && (springStartClass = NStringUtils.trim(pom.getProperties().get("start-class"))).length() > 0) {
                    classes.add(new DefaultNExecutionEntry(springStartClass, true, false));
                }
                XmlUtils.visitNode(ee, x -> {
                    String npath = XmlUtils.nodePath(x);
                    if (x instanceof Element) {
                        String s;
                        Node plugin;
                        NId pluginId;
                        Element e = (Element)x;
                        if (XmlUtils.isNode(e, "build", "plugins", "plugin", "configuration", "archive", "manifest", "mainClass")) {
                            String s2;
                            Node plugin2 = e.getParentNode().getParentNode().getParentNode().getParentNode();
                            NId pluginId2 = JavaJarUtils.parseMavenPluginElement(plugin2);
                            if ((pluginId2.getShortName().equals("org.apache.maven.plugins:maven-assembly-plugin") || pluginId2.getShortName().equals("org.apache.maven.plugins:maven-jar-plugin")) && (s2 = NStringUtils.trim(e.getTextContent())).length() > 0) {
                                s2 = JavaJarUtils.resolveMainClassString(s2, pom);
                                classes.add(new DefaultNExecutionEntry(s2, true, false));
                            }
                        } else if (XmlUtils.isNode(e, "build", "plugins", "plugin", "executions", "execution", "configuration", "mainClass")) {
                            String s3;
                            Node plugin3 = e.getParentNode().getParentNode().getParentNode().getParentNode();
                            NId pluginId3 = JavaJarUtils.parseMavenPluginElement(plugin3);
                            if ((pluginId3.getArtifactId().equals("onejar-maven-plugin") || pluginId3.getShortName().equals("org.springframework.boot:spring-boot-maven-plugin") || pluginId3.getShortName().equals("org.openjfx:javafx-maven-plugin")) && (s3 = NStringUtils.trim(e.getTextContent())).length() > 0) {
                                s3 = JavaJarUtils.resolveMainClassString(s3, pom);
                                classes.add(new DefaultNExecutionEntry(s3, true, false));
                            }
                        } else if (XmlUtils.isNode(e, "build", "plugins", "plugin", "configuration", "mainClass")) {
                            String s4;
                            Node plugin4 = e.getParentNode().getParentNode();
                            NId pluginId4 = JavaJarUtils.parseMavenPluginElement(plugin4);
                            if (pluginId4.getShortName().equals("org.springframework.boot:spring-boot-maven-plugin") && (s4 = NStringUtils.trim(e.getTextContent())).length() > 0) {
                                s4 = JavaJarUtils.resolveMainClassString(s4, pom);
                                classes.add(new DefaultNExecutionEntry(s4, true, false));
                            }
                        } else if (XmlUtils.isNode(e, "build", "plugins", "plugin", "executions", "execution", "configuration", "transformers", "transformer", "mainClass") && (pluginId = JavaJarUtils.parseMavenPluginElement(plugin = e.getParentNode().getParentNode().getParentNode().getParentNode().getParentNode().getParentNode())).getShortName().equals("org.apache.maven.plugins:maven-shade-plugin") && (s = NStringUtils.trim(e.getTextContent())).length() > 0) {
                            s = JavaJarUtils.resolveMainClassString(s, pom);
                            classes.add(new DefaultNExecutionEntry(s, true, false));
                        }
                        return true;
                    }
                    return true;
                });
            } else if (path.startsWith("META-INF/nuts/") && path.endsWith("/nuts.json") || path.equals("META-INF/nuts.json")) {
                String s;
                NDescriptorProperty mc;
                NDescriptor descriptor = NDescriptorParser.of().parse(inputStream).get();
                NArtifactCall executor = descriptor.getExecutor();
                if (executor != null) {
                    List<String> arguments = executor.getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        String a = arguments.get(i);
                        if (a == null) continue;
                        if (a.startsWith("--main-class=")) {
                            classes.add(new DefaultNExecutionEntry(a.substring("--main-class=".length()), true, false));
                            continue;
                        }
                        if (!a.equals("--main-class") || i + 1 >= arguments.size()) continue;
                        ++i;
                        classes.add(new DefaultNExecutionEntry(a, true, false));
                    }
                }
                if ((mc = descriptor.getProperty("nuts.mainClass").orNull()) != null && !(s = NStringUtils.trim(mc.getValue().asString().get())).isEmpty()) {
                    s = JavaJarUtils.resolveMainClassString(s, descriptor);
                    classes.add(new DefaultNExecutionEntry(s, true, false));
                }
            }
            return NVisitResult.CONTINUE;
        });
        LinkedHashMap<String, NExecutionEntry> found = new LinkedHashMap<String, NExecutionEntry>();
        for (NExecutionEntry entry : classes) {
            String cn = entry.getName();
            NExecutionEntry a = (NExecutionEntry)found.get(cn);
            if (a == null) {
                found.put(cn, entry);
                continue;
            }
            if (a.equals(entry)) continue;
            DefaultNExecutionEntry e2 = new DefaultNExecutionEntry(cn, entry.isDefaultEntry() || a.isDefaultEntry(), entry.isApp() || a.isApp());
            found.put(cn, e2);
        }
        ArrayList<NExecutionEntry> ee = new ArrayList<NExecutionEntry>(found.values());
        ee.sort(new Comparator<NExecutionEntry>(){

            @Override
            public int compare(NExecutionEntry o1, NExecutionEntry o2) {
                int x = (o1.isDefaultEntry() ? 0 : 1) - (o2.isDefaultEntry() ? 0 : 1);
                if (x != 0) {
                    return x;
                }
                x = (o1.isApp() ? 0 : 1) - (o2.isApp() ? 0 : 1);
                if (x != 0) {
                    return x;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return ee;
    }

    private static String resolveMainClassString(String nameOrVar, NPom pom) {
        String e;
        if (nameOrVar.startsWith("${") && nameOrVar.endsWith("}") && (e = pom.getProperties().get(nameOrVar.substring(2, nameOrVar.length() - 1))) != null) {
            return e;
        }
        return nameOrVar;
    }

    private static String resolveMainClassString(String nameOrVar, NDescriptor pom) {
        String e;
        if (nameOrVar.startsWith("${") && nameOrVar.endsWith("}") && (e = (String)pom.getPropertyValue(nameOrVar.substring(2, nameOrVar.length() - 1)).flatMap(NLiteral::asString).orNull()) != null) {
            return e;
        }
        return nameOrVar;
    }

    public static NId parseMavenPluginElement(Node plugin) {
        NIdBuilder ib = NIdBuilder.of();
        for (Node node : XmlUtils.iterable(plugin)) {
            Element ne = XmlUtils.asElement(node);
            if (ne == null) continue;
            switch (ne.getNodeName()) {
                case "groupId": {
                    ib.setGroupId(NStringUtils.trim(ne.getTextContent()));
                    break;
                }
                case "artifactId": {
                    ib.setArtifactId(NStringUtils.trim(ne.getTextContent()));
                    break;
                }
                case "version": {
                    ib.setVersion(NStringUtils.trim(ne.getTextContent()));
                }
            }
        }
        return ib.build();
    }

    public static NVersion parseJarClassVersion(NPath path) {
        NVersion nVersion;
        block8: {
            InputStream is = path.getInputStream();
            try {
                nVersion = JavaJarUtils.parseJarClassVersion(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return nVersion;
    }

    public static String parseDefaultModuleName(NPath jarStream) {
        String string;
        block8: {
            InputStream is = jarStream.getInputStream();
            try {
                string = JavaJarUtils.parseDefaultModuleName(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }

    public static String parseDefaultModuleName(InputStream jarStream) {
        NRef automaticModuleName = NRef.ofNull();
        ZipUtils.visitZipStream(jarStream, (path, inputStream) -> {
            if ("META-INF/MANIFEST.MF".equals(path)) {
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attrs = manifest.getMainAttributes();
                    for (Object o : attrs.keySet()) {
                        Attributes.Name attrName = (Attributes.Name)o;
                        if (!"Automatic-Module-Name".equals(attrName.toString())) continue;
                        automaticModuleName.setNonNull(NStringUtils.trimToNull(attrs.getValue(attrName)));
                        NVisitResult nVisitResult = NVisitResult.TERMINATE;
                        return nVisitResult;
                    }
                }
                finally {
                    inputStream.close();
                }
                return NVisitResult.TERMINATE;
            }
            return NVisitResult.CONTINUE;
        });
        return (String)automaticModuleName.get();
    }

    public static JavaClassByteCode.ModuleInfo parseModuleInfo(NPath jar) {
        JavaClassByteCode.ModuleInfo moduleInfo;
        block8: {
            InputStream is = jar.getInputStream();
            try {
                moduleInfo = JavaJarUtils.parseModuleInfo(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return moduleInfo;
    }

    public static JavaClassByteCode.ModuleInfo parseModuleInfo(InputStream jarStream) {
        if (!(jarStream instanceof BufferedInputStream)) {
            jarStream = new BufferedInputStream(jarStream);
        }
        final NRef ref = NRef.ofNull();
        ZipUtils.visitZipStream(jarStream, (path, inputStream) -> {
            if (path.equals("module-info.class")) {
                JavaClassByteCode s = new JavaClassByteCode(inputStream, new JavaClassByteCode.Visitor(){

                    @Override
                    public NVisitResult visitClassAttributeModule(JavaClassByteCode.ModuleInfo mi) {
                        ref.set(mi);
                        return NVisitResult.CONTINUE;
                    }
                });
                return NVisitResult.TERMINATE;
            }
            return NVisitResult.CONTINUE;
        });
        return (JavaClassByteCode.ModuleInfo)ref.get();
    }
}

