/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.jclass;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassByteCode;
import net.thevpc.nuts.runtime.standalone.util.jclass.MainClassType;
import net.thevpc.nuts.runtime.standalone.xtra.execentries.DefaultNExecutionEntry;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NRef;

public class JavaClassUtils {
    public static Class unwrapCGLib(Class clazz) {
        if (JavaClassUtils.isCGLib(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static List<URL> resolveURLs(Class clazz) {
        ArrayList<URL> all = new ArrayList<URL>();
        try {
            String n = clazz.getName().replace('.', '/').concat(".class");
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                return null;
            }
            Enumeration<URL> r = classLoader.getResources(n);
            ArrayList<URL> list = Collections.list(r);
            for (URL url : list) {
                String s = url.toString();
                if (!s.endsWith(n)) continue;
                String substring = s.substring(0, s.length() - n.length());
                if (substring.startsWith("jar:") && substring.endsWith("!/")) {
                    substring = substring.substring("jar:".length(), substring.length() - "!/".length());
                }
                all.add(CoreIOUtils.urlOf(substring));
            }
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
        return all;
    }

    public static boolean isCGLib(Class clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.contains("$$EnhancerBySpringCGLIB$$") || simpleName.contains("$$CGLIB$$") || simpleName.contains("$$SpringCGLIB$$");
    }

    public static MainClassType getMainClassType(InputStream stream, NWorkspace workspace) {
        final NRef mainClass = NRef.ofNull();
        final NRef nutsApp = NRef.ofNull();
        final NRef nutsAppVer = NRef.ofNull();
        final NRef className = NRef.ofNull();
        JavaClassByteCode.Visitor cl = new JavaClassByteCode.Visitor(){

            @Override
            public NVisitResult visitClassDeclaration(int access, String name, String superName, String[] interfaces) {
                if (superName != null && superName.equals("net/thevpc/nuts/NApplication")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.8.4");
                } else if (superName != null && superName.equals("net/thevpc/nuts/NutsApplication")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.8.0");
                } else if (superName != null && superName.equals("net/vpc/app/nuts/NutsApplication")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.7.0");
                }
                if (interfaces != null) {
                    for (String anInterface : interfaces) {
                        if (anInterface == null || !anInterface.equals("net/thevpc/nuts/NutsApplication")) continue;
                        nutsApp.set(true);
                        nutsAppVer.set("0.8.1");
                    }
                }
                className.set(name.replace('/', '.'));
                return NVisitResult.CONTINUE;
            }

            @Override
            public NVisitResult visitClassAnnotation(JavaClassByteCode.AnnotationInfo annotationInfo) {
                if (annotationInfo.name.equals("net/thevpc/nuts/NAppDefinition")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.8.7");
                }
                return NVisitResult.CONTINUE;
            }

            @Override
            public NVisitResult visitMethod(int access, String name, String desc) {
                if (name.equals("main") && desc.equals("([Ljava/lang/String;)V") && Modifier.isPublic(access) && Modifier.isStatic(access)) {
                    mainClass.set(true);
                }
                return NVisitResult.CONTINUE;
            }
        };
        JavaClassByteCode classReader = new JavaClassByteCode(new BufferedInputStream(stream), cl);
        if (mainClass.isSet()) {
            return new MainClassType((String)className.get(), mainClass.isSet(), nutsApp.isSet());
        }
        return null;
    }

    public static NExecutionEntry parseClassExecutionEntry(InputStream classStream, String sourceName) {
        MainClassType mainClass = null;
        try {
            mainClass = JavaClassUtils.getMainClassType(classStream, NWorkspace.of());
        }
        catch (Exception ex) {
            NLog.of(CorePlatformUtils.class).log(NMsg.ofC("invalid java class file format %s", sourceName).asFineFail(ex));
        }
        if (mainClass != null) {
            return new DefaultNExecutionEntry(mainClass.getName(), false, mainClass.isApp());
        }
        return null;
    }

    public static String classVersionToSourceVersion(String classVersion) {
        int minor;
        int major;
        int i = classVersion.indexOf(46);
        if (i > 0) {
            major = Integer.parseInt(classVersion.substring(0, i));
            minor = Integer.parseInt(classVersion.substring(i + 1));
        } else {
            major = Integer.parseInt(classVersion);
            minor = 0;
        }
        return JavaClassUtils.classVersionToSourceVersion(major, minor);
    }

    public static String classVersionToSourceVersion(int major, int minor) {
        if (major < 45) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid classVersion %s.%s", major, minor));
        }
        if (major == 45) {
            if (minor <= 3) {
                return "1.0.2";
            }
            return "1.1";
        }
        int v = major - 46 + 2;
        if (v <= 8) {
            return "1." + v;
        }
        return String.valueOf(v);
    }

    public static String sourceVersionToClassVersion(String sourceVersion) {
        NVersion v = NVersion.get(sourceVersion).get();
        int major = v.getIntegerAt(0).orElse(0);
        int minor = v.getIntegerAt(1).orElse(-1);
        if (major < 1) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid sourceVersion %s", sourceVersion));
        }
        if (major == 1) {
            switch (minor) {
                case 0: {
                    return "45.0";
                }
                case 1: {
                    return "45.4";
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return String.valueOf(46 - minor - 2);
                }
            }
            throw new NIllegalArgumentException(NMsg.ofC("invalid sourceVersion %s", sourceVersion));
        }
        return String.valueOf(46 - major - 2);
    }
}

