/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NIdFilters;
import net.thevpc.nuts.artifact.NTypedFilters;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterNone;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterNone;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterNone;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterNone;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterNone;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNFilterModel {
    private NWorkspace workspace;
    private Map<String, Object> shared = new HashMap<String, Object>();

    public DefaultNFilterModel(NWorkspace ws) {
        this.workspace = ws;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public <T> T getShared(Class<T> clz, Supplier<T> s) {
        return (T)this.shared.computeIfAbsent(clz.getName(), t -> s.get());
    }

    public <T extends NFilter> T nonnull(Class<T> type, NFilter filter) {
        if (filter == null) {
            return this.always(type);
        }
        return filter.to(type);
    }

    public NTypedFilters resolveNutsTypedFilters(Class type) {
        if (type == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("unable to detected Filter type"));
        }
        switch (type.getName()) {
            case "net.thevpc.nuts.artifact.NDependencyFilter": {
                return NDependencyFilters.of();
            }
            case "net.thevpc.nuts.artifact.NDefinitionFilter": {
                return NDefinitionFilters.of();
            }
            case "net.thevpc.nuts.core.NRepositoryFilter": {
                return NRepositoryFilters.of();
            }
            case "net.thevpc.nuts.artifact.NIdFilter": {
                return NIdFilters.of();
            }
            case "net.thevpc.nuts.artifact.NVersionFilter": {
                return NVersionFilters.of();
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported filter type: %s", type));
    }

    public <T extends NFilter> T always(Class<T> type) {
        return this.resolveNutsTypedFilters(type).always();
    }

    public <T extends NFilter> T never(Class<T> type) {
        return this.resolveNutsTypedFilters(type).never();
    }

    public <T extends NFilter> T all(Class<T> type, NFilter[] others) {
        others = this.expandAll(others).toArray(new NFilter[0]);
        if (type == null || type.equals(NFilter.class)) {
            ArrayList<NFilter> all = new ArrayList<NFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NFilter[0]));
            if (type == null) {
                throw new NIllegalArgumentException(NMsg.ofPlain("unable to detected Filter type"));
            }
        }
        return this.resolveNutsTypedFilters(type).all(others);
    }

    public <T extends NFilter> T all(NFilter[] others) {
        return this.all(null, others);
    }

    public <T extends NFilter> T any(Class<T> type, NFilter[] others) {
        others = this.expandAny(others).toArray(new NFilter[0]);
        if (type == null || type.equals(NFilter.class)) {
            ArrayList<NFilter> all = new ArrayList<NFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NFilter[0]));
            if (type == null) {
                throw new NIllegalArgumentException(NMsg.ofPlain("unable to detected Filter type"));
            }
        }
        return this.resolveNutsTypedFilters(type).any(others);
    }

    public <T extends NFilter> T not(NFilter other) {
        return this.not(null, other);
    }

    public <T extends NFilter> T not(Class<T> type, NFilter other) {
        if ((type == null || type.equals(NFilter.class)) && (type = this.detectType(other)) == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("unable to detected Filter type"));
        }
        return this.resolveNutsTypedFilters(type).not(other);
    }

    public <T extends NFilter> T any(NFilter[] others) {
        return this.any(null, others);
    }

    public <T extends NFilter> T none(Class<T> type, NFilter[] others) {
        others = this.expandAll(others).toArray(new NFilter[0]);
        if (type == null || type.equals(NFilter.class)) {
            ArrayList<NFilter> all = new ArrayList<NFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NFilter[0]));
            if (type == null) {
                throw new NIllegalArgumentException(NMsg.ofPlain("unable to detected Filter type"));
            }
        }
        switch (type.getName()) {
            case "net.thevpc.nuts.artifact.NDependencyFilter": {
                ArrayList<NDependencyFilter> all = new ArrayList<NDependencyFilter>();
                for (NFilter other : others) {
                    NDependencyFilter a = (NDependencyFilter)NDependencyFilters.of().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type);
                }
                return (T)new NDependencyFilterNone(all.toArray(new NDependencyFilter[0]));
            }
            case "net.thevpc.nuts.core.NRepositoryFilter": {
                ArrayList<NRepositoryFilter> all = new ArrayList<NRepositoryFilter>();
                for (NFilter other : others) {
                    NRepositoryFilter a = (NRepositoryFilter)NRepositoryFilters.of().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type);
                }
                return (T)new NRepositoryFilterNone(all.toArray(new NRepositoryFilter[0]));
            }
            case "net.thevpc.nuts.artifact.NIdFilter": {
                ArrayList<NIdFilter> all = new ArrayList<NIdFilter>();
                for (NFilter other : others) {
                    NIdFilter a = (NIdFilter)NIdFilters.of().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type);
                }
                return (T)new NIdFilterNone(all.toArray(new NIdFilter[0]));
            }
            case "net.thevpc.nuts.artifact.NVersionFilter": {
                ArrayList<NVersionFilter> all = new ArrayList<NVersionFilter>();
                for (NFilter other : others) {
                    NVersionFilter a = (NVersionFilter)NVersionFilters.of().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type);
                }
                return (T)new NVersionFilterNone(all.toArray(new NVersionFilter[0]));
            }
            case "net.thevpc.nuts.artifact.NDefinitionFilter": {
                ArrayList<NDefinitionFilter> all = new ArrayList<NDefinitionFilter>();
                for (NFilter other : others) {
                    NDefinitionFilter a = (NDefinitionFilter)NDefinitionFilters.of().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type);
                }
                return (T)new NDefinitionFilterNone(all.toArray(new NDefinitionFilter[0]));
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported filter type: %s", type));
    }

    public <T extends NFilter> T none(NFilter[] others) {
        return this.none(null, others);
    }

    public <T extends NFilter> T to(Class<T> toFilterInterface, NFilter filter) {
        return this.resolveNutsTypedFilters(toFilterInterface).from(filter);
    }

    public <T extends NFilter> T as(Class<T> toFilterInterface, NFilter filter) {
        return this.resolveNutsTypedFilters(toFilterInterface).as(filter);
    }

    public Class<? extends NFilter> detectType(NFilter nFilter) {
        if (nFilter == null) {
            return null;
        }
        return this.detectType(nFilter.getClass());
    }

    private Collection<NFilter> expandAny(NFilter ... others) {
        ArrayList<NFilter> ok = new ArrayList<NFilter>();
        if (others != null) {
            for (NFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NFilterOp.OR) {
                    ok.addAll(other.getSubFilters());
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    private Collection<NFilter> expandAll(NFilter ... others) {
        ArrayList<NFilter> ok = new ArrayList<NFilter>();
        if (others != null) {
            for (NFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NFilterOp.AND) {
                    ok.addAll(other.getSubFilters());
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    private Collection<NFilter> expandNone(NFilter ... others) {
        ArrayList<NFilter> ok = new ArrayList<NFilter>();
        if (others != null) {
            for (NFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NFilterOp.NOT) {
                    ok.addAll(other.getSubFilters());
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    public <T extends NFilter> Class<T> detectType(NFilter[] others) {
        Class<T> c = null;
        for (NFilter other : others) {
            if (other == null) continue;
            c = c == null ? this.detectType(other.getClass()) : this.detectType(c, other.getClass());
        }
        if (c == null) {
            return null;
        }
        return c;
    }

    public <T extends NFilter> Class<T> detectType(Class<? extends NFilter> c1) {
        if (c1 == null) {
            return null;
        }
        if (NVersionFilter.class.isAssignableFrom(c1)) {
            return NVersionFilter.class;
        }
        if (NIdFilter.class.isAssignableFrom(c1)) {
            return NIdFilter.class;
        }
        if (NDefinitionFilter.class.isAssignableFrom(c1)) {
            return NDefinitionFilter.class;
        }
        if (NRepositoryFilter.class.isAssignableFrom(c1)) {
            return NRepositoryFilter.class;
        }
        if (NDependencyFilter.class.isAssignableFrom(c1)) {
            return NDependencyFilter.class;
        }
        throw new NIllegalArgumentException(NMsg.ofC("cannot detect filter type for %s", c1));
    }

    public <T extends NFilter> Class<T> detectType(Class<? extends NFilter> c1, Class<? extends NFilter> c2) {
        if (NVersionFilter.class.isAssignableFrom(c1)) {
            if (NVersionFilter.class.isAssignableFrom(c2)) {
                return NVersionFilter.class;
            }
            if (NIdFilter.class.isAssignableFrom(c2)) {
                return NIdFilter.class;
            }
            if (NDefinitionFilter.class.isAssignableFrom(c2)) {
                return NDefinitionFilter.class;
            }
            throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
        }
        if (NIdFilter.class.isAssignableFrom(c1)) {
            if (NVersionFilter.class.isAssignableFrom(c2)) {
                return NIdFilter.class;
            }
            if (NIdFilter.class.isAssignableFrom(c2)) {
                return NIdFilter.class;
            }
            if (NDefinitionFilter.class.isAssignableFrom(c2)) {
                return NDefinitionFilter.class;
            }
            throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
        }
        if (NDefinitionFilter.class.isAssignableFrom(c1)) {
            if (NVersionFilter.class.isAssignableFrom(c2)) {
                return NDefinitionFilter.class;
            }
            if (NIdFilter.class.isAssignableFrom(c2)) {
                return NDefinitionFilter.class;
            }
            if (NDefinitionFilter.class.isAssignableFrom(c2)) {
                return NDefinitionFilter.class;
            }
            throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
        }
        if (NDependencyFilter.class.isAssignableFrom(c1)) {
            if (NDependencyFilter.class.isAssignableFrom(c2)) {
                return NDependencyFilter.class;
            }
            throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
        }
        if (NRepositoryFilter.class.isAssignableFrom(c1)) {
            if (NRepositoryFilter.class.isAssignableFrom(c2)) {
                return NRepositoryFilter.class;
            }
            throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
        }
        throw new NIllegalArgumentException(NMsg.ofC("cannot detect common type for %s and %s", c1, c2));
    }
}

