/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.text.NMsg;

public class XmlEscaper {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&[a-zA-Z]+;");
    private static final Map<String, String> atToSharp = new HashMap<String, String>();
    private static final Map<String, String> atToUnicode = new HashMap<String, String>();

    private static void install(String at, String sharp, String unicode) {
        atToSharp.put(at, sharp);
        atToUnicode.put(at, unicode);
    }

    public static String escapeToCode(String any) {
        Matcher m = ENTITY_PATTERN.matcher(any);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            String z = atToSharp.get(g);
            if (z != null) {
                m.appendReplacement(sb, z);
                continue;
            }
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("unsupported  xml entity declaration : %s", g).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            m.appendReplacement(sb, g);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String escapeToUnicode(String any) {
        Matcher m = ENTITY_PATTERN.matcher(any);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            String z = atToUnicode.get(g);
            if (z != null) {
                m.appendReplacement(sb, z);
                continue;
            }
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("unsupported  xml entity declaration : %s", g).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            m.appendReplacement(sb, g);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        XmlEscaper.install("&Oslash;", "&#216;", "\u00d8");
        XmlEscaper.install("&oslash;", "&#248;", "\u00f8");
        XmlEscaper.install("&AElig;", "&#198;", "\u00c6");
        XmlEscaper.install("&aelig;", "&#230;", "\u00e6");
        XmlEscaper.install("&Auml;", "&#196;", "\u00c4");
        XmlEscaper.install("&auml;", "&#228;", "\u00e4");
        XmlEscaper.install("&OElig;", "&#338;", "\u0152");
        XmlEscaper.install("&oelig;", "&#339;", "\u0153");
        XmlEscaper.install("&lt;", "&#60;", "<");
        XmlEscaper.install("&gt;", "&#62;", ">");
        XmlEscaper.install("&amp;", "&#38;", "&");
        XmlEscaper.install("&quot;", "&#34;", "\"");
        XmlEscaper.install("&euro;", "&#8364;", "\u20ac");
        XmlEscaper.install("&circ;", "&#710;", "\u02c6");
        XmlEscaper.install("&tilde;", "&#732;", "\u223c");
        XmlEscaper.install("&ndash;", "&#45;", "\u2013");
        XmlEscaper.install("&copy;", "&#169;", "\u00a9");
        XmlEscaper.install("&nbsp;", "&#32;", " ");
        XmlEscaper.install("&apos;", "&#39;", "'");
    }
}

