/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class TimePeriod {
    private static Pattern PATTERN = Pattern.compile("(<?val>[-+]?[0-9]+)[ ]*(<?unit>([a-zA-Z]+))?");
    private long count;
    private TimeUnit unit;

    public TimePeriod(long count, TimeUnit unit) {
        this.count = count;
        this.unit = unit;
    }

    public static NOptional<TimePeriod> parse(String str, TimeUnit defaultUnit) {
        Matcher matcher;
        if (NBlankable.isBlank(str)) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain(TimePeriod.class.getSimpleName() + " is empty"));
        }
        if (defaultUnit == null) {
            defaultUnit = TimeUnit.MILLISECONDS;
        }
        if ((matcher = PATTERN.matcher(str)).find()) {
            long unitCount = 0L;
            try {
                unitCount = Long.parseLong(matcher.group("val"));
            }
            catch (Exception ex) {
                return NOptional.ofError(() -> NMsg.ofC(TimePeriod.class.getSimpleName() + " invalid value : %s", str), (Throwable)ex);
            }
            String u = matcher.group("unit");
            if (u == null) {
                u = "ms";
            }
            TimeUnit unit = defaultUnit;
            switch (u.toLowerCase()) {
                case "ns": 
                case "nanos": 
                case "nano": 
                case "nanosecond": 
                case "nanoseconds": {
                    unit = TimeUnit.NANOSECONDS;
                    break;
                }
                case "ms": 
                case "milli": 
                case "millis": 
                case "millisecond": 
                case "milliseconds": {
                    unit = TimeUnit.MILLISECONDS;
                    break;
                }
                case "s": 
                case "sec": 
                case "secs": 
                case "second": 
                case "seconds": {
                    unit = TimeUnit.SECONDS;
                    break;
                }
                case "mn": 
                case "min": 
                case "mins": 
                case "minute": 
                case "minutes": {
                    unit = TimeUnit.MINUTES;
                    break;
                }
                case "h": 
                case "hour": 
                case "hours": {
                    unit = TimeUnit.HOURS;
                    break;
                }
                case "d": 
                case "day": 
                case "days": {
                    unit = TimeUnit.DAYS;
                    break;
                }
                default: {
                    return null;
                }
            }
            return NOptional.of(new TimePeriod(unitCount, unit));
        }
        return NOptional.ofError(() -> NMsg.ofC(TimePeriod.class.getSimpleName() + " invalid value : %s", str));
    }

    public long getCount() {
        return this.count;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.count, this.unit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        return this.count == that.count && this.unit == that.unit;
    }

    public String toString() {
        return this.count + this.unit.name().toLowerCase();
    }
}

