/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class NMapWithAlias<K, V> {
    private final Map<K, V> base = new LinkedHashMap();
    private final Map<K, K> aliasToBase = new LinkedHashMap<K, K>();
    private final Map<K, Set<K>> baseToAliases = new LinkedHashMap<K, Set<K>>();

    public NMapWithAlias<K, V> alias(K key, K value) {
        this.aliasToBase.put(key, value);
        this.baseToAliases.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
        return this;
    }

    public Set<K> keySet() {
        return new LinkedHashSet<K>(this.base.keySet());
    }

    public Set<K> keySetWithAlias() {
        LinkedHashSet<K> u = new LinkedHashSet<K>(this.base.keySet());
        u.addAll(this.aliasToBase.keySet());
        return u;
    }

    public V put(K key, V value) {
        V u = this.base.put(key, value);
        return u;
    }

    public Set<K> keySetWithAlias(K name) {
        Set<K> a = this.baseToAliases.get(name);
        if (a != null) {
            return Collections.unmodifiableSet(a);
        }
        K base = this.aliasToBase.get(name);
        if (base != null && (a = this.baseToAliases.get(base)) != null) {
            return Collections.unmodifiableSet(a);
        }
        return Collections.singleton(name);
    }

    public V get(K key) {
        if (this.base.containsKey(key)) {
            return this.base.get(key);
        }
        K u = this.aliasToBase.get(key);
        if (u != null) {
            return this.base.get(u);
        }
        return null;
    }
}

