/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.util.NAnyFormattedExceptionBase;
import net.thevpc.nuts.util.NStreamTokenizer;
import net.thevpc.nuts.util.NStringUtils;

public final class CoreStringUtils {
    private static final Pattern PATTERN_ALL = Pattern.compile(".*");

    public static String generateIndexedName(String name, Predicate<String> exists) {
        int x = 1;
        String a;
        while (exists.test(a = name + (x == 1 ? "" : " " + x))) {
            ++x;
        }
        return a;
    }

    public static String escapeQuoteStrings(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '\'': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeReplacementStrings(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '$': 
                case '\\': 
                case '{': 
                case '}': {
                    sb.append("\\");
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean containsVars(String value) {
        return value != null && value.contains("${");
    }

    public static boolean containsTopWord(String word, String line) {
        NStreamTokenizer tokenizer = new NStreamTokenizer(new StringReader(line));
        int last_ttype = -1;
        try {
            while (tokenizer.nextToken() != -1) {
                switch (tokenizer.ttype) {
                    case -3: {
                        if (!word.equals(tokenizer.sval) || last_ttype == 46) break;
                        return true;
                    }
                }
                last_ttype = tokenizer.ttype;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static char[] strToChr(String s) {
        if (s == null) {
            return null;
        }
        return s.toCharArray();
    }

    public static String chrToStr(char[] s) {
        if (s == null) {
            return null;
        }
        return new String(s);
    }

    public static StringBuilder clear(StringBuilder c) {
        return c.delete(0, c.length());
    }

    public static String exceptionToString(Throwable ex) {
        return CoreStringUtils.exceptionToString(ex, false);
    }

    public static String exceptionToString(Throwable ex, boolean inner) {
        String msg = null;
        if (ex instanceof NArtifactNotFoundException || ex instanceof UncheckedIOException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToString(ex2, true);
            } else {
                msg = ex.getMessage();
            }
        } else {
            String msg2 = ex.toString();
            if (msg2.startsWith(ex.getClass().getName() + ":")) {
                msg = inner ? msg2.substring(ex.getClass().getName().length() + 1).trim() : ex.getClass().getSimpleName() + ": " + msg2.substring(ex.getClass().getName().length() + 1).trim();
            } else {
                for (Class aClass : new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, UnsupportedOperationException.class, ReflectiveOperationException.class, Error.class}) {
                    if (!aClass.isInstance(ex)) continue;
                    return ex.toString();
                }
                msg = ex.getMessage();
                if (msg == null) {
                    msg = ex.toString();
                }
            }
        }
        return msg;
    }

    public static NMsg exceptionToMessage(Throwable ex) {
        return CoreStringUtils.exceptionToMessage(ex, false);
    }

    public static NMsg exceptionToMessage(Throwable ex, boolean inner) {
        NMsg msg = null;
        if (ex instanceof UncheckedIOException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToMessage(ex2, true);
            } else {
                msg = NMsg.ofPlain(ex.getMessage());
            }
        } else if (ex instanceof NArtifactNotFoundException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToMessage(ex2, true);
            } else {
                msg = ((NArtifactNotFoundException)ex).getFormattedMessage();
            }
        } else if (ex instanceof NAnyFormattedExceptionBase) {
            msg = ((NAnyFormattedExceptionBase)((Object)ex)).getFormattedMessage();
        } else {
            String msg2 = ex.toString();
            if (msg2.startsWith(ex.getClass().getName() + ":")) {
                msg = inner ? NMsg.ofPlain(msg2.substring(ex.getClass().getName().length() + 1).trim()) : NMsg.ofPlain(ex.getClass().getSimpleName() + ": " + msg2.substring(ex.getClass().getName().length() + 1).trim());
            } else {
                for (Class aClass : new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, UnsupportedOperationException.class, ReflectiveOperationException.class, Error.class}) {
                    if (!aClass.isInstance(ex)) continue;
                    return NMsg.ofPlain(ex.toString());
                }
                NMsg nMsg = msg = ex.getMessage() == null ? null : NMsg.ofPlain(ex.getMessage());
                if (msg == null) {
                    msg = NMsg.ofPlain(ex.toString());
                }
            }
        }
        return msg;
    }

    public static String fillString(char x, int width) {
        if (width <= 0) {
            return "";
        }
        char[] cc = new char[width];
        Arrays.fill(cc, x);
        return new String(cc);
    }

    public static String fillString(String x, int width) {
        if (width <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        CoreStringUtils.fillString(x, width, sb);
        return sb.toString();
    }

    public static void fillString(char x, int width, StringBuilder sb) {
        if (width <= 0) {
            return;
        }
        sb.ensureCapacity(sb.length() + width);
        for (int i = 0; i < width; ++i) {
            sb.append(x);
        }
    }

    public static void fillString(char x, int width, NTextBuilder sb) {
        if (width <= 0) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            sb.append(Character.valueOf(x));
        }
    }

    public static void fillString(String x, int width, StringBuilder sb) {
        if (width <= 0) {
            return;
        }
        sb.ensureCapacity(sb.length() + width * x.length());
        for (int i = 0; i < width; ++i) {
            sb.append(x);
        }
    }

    public static void fillString(String x, int width, NTextBuilder sb) {
        if (width <= 0) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            sb.append(x);
        }
    }

    public static String indexToString(int x) {
        if (x < 0) {
            return "-" + CoreStringUtils.indexToString(-x);
        }
        StringBuilder sb = new StringBuilder();
        while (x > 0) {
            int y = x % 10;
            if (y == 0) {
                sb.insert(0, '0');
            } else {
                sb.insert(0, (char)(65 + (y - 1)));
            }
            x /= 10;
        }
        if (sb.length() == 0) {
            return "A";
        }
        return sb.toString();
    }

    public static List<String> parseAndTrimToDistinctReadOnlyList(String s) {
        return Collections.unmodifiableList(CoreStringUtils.parseAndTrimToDistinctList(s));
    }

    public static List<String> parseAndTrimToDistinctList(String s) {
        return Arrays.asList(CoreStringUtils.parseAndTrimToDistinctArray(s));
    }

    public static String[] parseAndTrimToDistinctArray(String s) {
        if (s == null) {
            return new String[0];
        }
        return (String[])StringTokenizerUtils.splitDefault(s).stream().map(String::trim).filter(x -> x.length() > 0).distinct().toArray(String[]::new);
    }

    public static String joinAndTrimToNull(List<String> args) {
        return NStringUtils.trimToNull(String.join((CharSequence)",", args));
    }

    public static String prefixLinesPortableNL(String str, String prefix) {
        return CoreStringUtils.prefixLines(str, prefix, "\n");
    }

    public static String prefixLinesOsNL(String str, String prefix) {
        return CoreStringUtils.prefixLines(str, prefix, System.getProperty("line.separator"));
    }

    public static String prefixLines(String str, String prefix, String nl) {
        BufferedReader br = new BufferedReader(new StringReader(str == null ? "" : str));
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (nl == null && (nl = System.getProperty("line.separator")) == null) {
            nl = "\n";
        }
        while (true) {
            String line;
            try {
                line = br.readLine();
                if (line == null) {
                }
            }
            catch (IOException e) {}
            break;
            if (first) {
                first = false;
            } else {
                sb.append(nl);
            }
            sb.append(prefix);
            sb.append(line);
        }
        return sb.toString();
    }

    public static String coalesce(String a, String b) {
        return a == null ? b : a;
    }

    public static List<String> splitOnNewlines(String line) {
        char[] text = line.toCharArray();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tb = new ArrayList<String>();
        block4: for (int i = 0; i < text.length; ++i) {
            switch (text[i]) {
                case '\r': {
                    if (sb.length() > 0) {
                        tb.add(sb.toString());
                        sb.setLength(0);
                    }
                    if (i + 1 < text.length && text[i + 1] == '\n') {
                        tb.add("\r\n");
                        ++i;
                        continue block4;
                    }
                    tb.add("\r");
                    continue block4;
                }
                case '\n': {
                    if (sb.length() > 0) {
                        tb.add(sb.toString());
                        sb.setLength(0);
                    }
                    tb.add("\n");
                    continue block4;
                }
                default: {
                    sb.append(text[i]);
                }
            }
        }
        if (sb.length() > 0) {
            tb.add(sb.toString());
            sb.setLength(0);
        }
        return tb;
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isEnum()) {
            return CoreEnumUtils.getEnumString((Enum)o);
        }
        if (o instanceof Instant) {
            return CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o);
        }
        if (o instanceof Date) {
            return CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant());
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Object[] a = c.toArray();
            if (a.length == 0) {
                return "";
            }
            if (a.length == 1) {
                return CoreStringUtils.stringValue(a[0]);
            }
            return "[" + String.join((CharSequence)", ", c.stream().map(x -> CoreStringUtils.stringValue(x)).collect(Collectors.toList())) + "]";
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return "";
            }
            if (len == 1) {
                return CoreStringUtils.stringValue(Array.get(o, 0));
            }
            ArrayList<String> all = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                all.add(CoreStringUtils.stringValue(Array.get(o, i)).toString());
            }
            return "[" + String.join((CharSequence)", ", all) + "]";
        }
        return o.toString();
    }

    public static String trueOrEqOrIn(String name, List<String> values) {
        if (values.isEmpty()) {
            return "true";
        }
        if (values.size() == 1) {
            return name + " = " + values.get(0);
        }
        return name + " in (" + String.join((CharSequence)", ", values) + ")";
    }

    public static String trueOrOr(List<String> values) {
        if (values.isEmpty()) {
            return "true";
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(" | "));
    }

    public static String trueOrAnd(List<String> values) {
        if (values.isEmpty()) {
            return "true";
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(" & "));
    }

    public static String trueOrNone(List<String> values) {
        if (values.isEmpty()) {
            return "true";
        }
        if (values.size() == 1) {
            return "!" + values.get(0);
        }
        return "!(" + values.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(" & ")) + ")";
    }
}

