/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCopiable;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class CoreNUtils {
    public static final int DEFAULT_UUID_LENGTH = 25;
    public static final int DEFAULT_DATE_TIME_FORMATTER_LENGTH = 23;
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final int LOCK_TIME = 3;
    public static final TimeUnit LOCK_TIME_UNIT = TimeUnit.SECONDS;
    public static final NDefaultThreadFactory N_DEFAULT_THREAD_FACTORY = new NDefaultThreadFactory("nuts-pool", true);
    private static final Map<String, String> _QUERY_EMPTY_ENV = new HashMap<String, String>();
    public static final Map<String, String> QUERY_EMPTY_ENV = Collections.unmodifiableMap(_QUERY_EMPTY_ENV);
    public static Comparator<NId> NUTS_ID_COMPARATOR = new Comparator<NId>(){

        @Override
        public int compare(NId o1, NId o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static Comparator<NDefinition> NUTS_FILE_COMPARATOR = new Comparator<NDefinition>(){

        @Override
        public int compare(NDefinition o1, NDefinition o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return NUTS_ID_COMPARATOR.compare(o1.getId(), o2.getId());
        }
    };

    private CoreNUtils() {
    }

    public static final boolean isDevVerbose() {
        return Boolean.getBoolean("nuts.dev.verbose");
    }

    public static String repeat(char txt, int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(txt);
        }
        return sb.toString();
    }

    public static NId findNutsIdBySimpleName(NId id, Collection<NId> all) {
        if (all != null) {
            for (NId nutsId : all) {
                if (nutsId == null || !nutsId.equalsShortId(id)) continue;
                return nutsId;
            }
        }
        return null;
    }

    public static String formatImport(List<String> imports) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (String s : imports) {
            if ((s = s.trim()).length() <= 0 || all.contains(s)) continue;
            all.add(s);
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean isEffectiveValue(String value) {
        return !NBlankable.isBlank(value) && !CoreStringUtils.containsVars(value);
    }

    public static boolean isEffectiveId(NId id) {
        return CoreNUtils.isEffectiveValue(id.getGroupId()) && CoreNUtils.isEffectiveValue(id.getArtifactId()) && CoreNUtils.isEffectiveValue(id.getVersion().getValue());
    }

    public static boolean containsVars(NId id) {
        return CoreStringUtils.containsVars(id.getGroupId()) && CoreStringUtils.containsVars(id.getArtifactId()) && CoreStringUtils.containsVars(id.getVersion().getValue());
    }

    public static List<String> applyStringPropertiesList(List<String> child, Function<String, String> properties) {
        return new ArrayList<String>(Arrays.asList(CoreNUtils.applyStringProperties(child.toArray(new String[0]), properties)));
    }

    public static List<String> applyStringProperties(List<String> child, Function<String, String> properties) {
        return new ArrayList<String>(Arrays.asList(CoreNUtils.applyStringProperties(child.toArray(new String[0]), properties)));
    }

    public static String[] applyStringProperties(String[] child, Function<String, String> properties) {
        String[] vals = new String[child.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = CoreNUtils.applyStringProperties(child[i], properties);
        }
        return vals;
    }

    public static Map<String, String> applyMapProperties(Map<String, String> child, Function<String, String> properties) {
        LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : child.entrySet()) {
            m2.put(CoreNUtils.applyStringProperties(entry.getKey(), properties), CoreNUtils.applyStringProperties(entry.getValue(), properties));
        }
        return m2;
    }

    public static NVersion applyStringProperties(NVersion child, Function<String, String> properties) {
        if (child == null) {
            return child;
        }
        String s = child.getValue();
        if (NBlankable.isBlank(s)) {
            return NVersion.BLANK;
        }
        String s2 = CoreNUtils.applyStringProperties(s, properties);
        if (!NStringUtils.trim(s2).equals(s)) {
            return NVersion.get(s2).orElse(NVersion.BLANK);
        }
        return child;
    }

    public static String applyStringProperties(String child, Function<String, String> properties) {
        if (child == null) {
            return null;
        }
        return StringPlaceHolderParser.replaceDollarPlaceHolders(child, properties);
    }

    public static String applyStringInheritance(String child, String parent) {
        child = NStringUtils.trimToNull(child);
        parent = NStringUtils.trimToNull(parent);
        if (child == null) {
            return parent;
        }
        return child;
    }

    public static NId applyNutsIdInheritance(NId child, NId parent) {
        if (parent != null) {
            Map<String, String> parentFaceMap;
            boolean modified = false;
            String repository = child.getRepository();
            String group = child.getGroupId();
            String name = child.getArtifactId();
            String version = child.getVersion().getValue();
            Map<String, String> props = child.getProperties();
            if (NBlankable.isBlank(repository)) {
                modified = true;
                repository = parent.getRepository();
            }
            if (NBlankable.isBlank(group)) {
                modified = true;
                group = parent.getGroupId();
            }
            if (NBlankable.isBlank(name)) {
                modified = true;
                name = parent.getArtifactId();
            }
            if (NBlankable.isBlank(version)) {
                modified = true;
                version = parent.getVersion().getValue();
            }
            if (!(parentFaceMap = parent.getProperties()).isEmpty()) {
                modified = true;
                props.putAll(parentFaceMap);
            }
            if (modified) {
                return NIdBuilder.of().setRepository(repository).setGroupId(group).setArtifactId(name).setVersion(version).setProperties(props).build();
            }
        }
        return child;
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i]) || c[i] == '-') continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> traceJsonNutsDefinition(NDefinition def) {
        LinkedHashMap<String, Object> x = new LinkedHashMap<String, Object>();
        x.put("id", def.getId());
        if (def.getContent().isPresent()) {
            x.put("path", def.getContent().get());
            x.put("cached", def.getContent().get().isUserCache());
            x.put("temporary", def.getContent().get().isUserTemporary());
        }
        if (def.getInstallInformation().isPresent()) {
            NInstallInformation nInstallInformation = def.getInstallInformation().get();
            if (nInstallInformation.getInstallFolder() != null) {
                x.put("install-folder", nInstallInformation.getInstallFolder());
            }
            x.put("install-status", nInstallInformation.getInstallStatus().toString());
            x.put("was-installed", nInstallInformation.isWasInstalled());
            x.put("was-required", nInstallInformation.isWasRequired());
        }
        if (def.getRepositoryName() != null) {
            x.put("repository-name", def.getRepositoryName());
        }
        if (def.getRepositoryUuid() != null) {
            x.put("repository-uuid", def.getRepositoryUuid());
        }
        if (def.getDescriptor() != null) {
            x.put("descriptor", NDescriptorFormat.of(def.getDescriptor()).format());
            x.put("effective-descriptor", NDescriptorFormat.of(def.getEffectiveDescriptor().orElseGet(() -> NWorkspace.of().resolveEffectiveDescriptor(def.getDescriptor(), new NDescriptorEffectiveConfig().setIgnoreCurrentEnvironment(true)))).format());
        }
        return x;
    }

    public static String[] nullArray_Locations(String[] a) {
        return CoreNUtils.nullArray(a, NStoreType.values().length);
    }

    public static String[] nullArray_LocationsAndOses(String[] a) {
        return CoreNUtils.nullArray(a, NStoreType.values().length * NOsFamily.values().length);
    }

    public static String[] nullArray(String[] a, int size) {
        if (a == null) {
            return null;
        }
        boolean ok = false;
        for (String string : a) {
            if (string == null) continue;
            ok = true;
            break;
        }
        if (ok) {
            if (a.length == size) {
                return a;
            }
            String[] aa = new String[size];
            System.arraycopy(a, 0, aa, 0, size);
            return aa;
        }
        return null;
    }

    public static String getArrItem(String[] a, int index) {
        return a == null || a.length <= index ? null : a[index];
    }

    public static String[] nonNullArray_Locations(String[] a) {
        return CoreNUtils.nonNullArray(a, NStoreType.values().length);
    }

    public static String[] nonNullArray_LocationsAndOses(String[] a) {
        return CoreNUtils.nonNullArray(a, NStoreType.values().length * NOsFamily.values().length);
    }

    public static String[] nonNullArray(String[] a, int size) {
        if (a == null) {
            return new String[size];
        }
        if (a.length == size) {
            return a;
        }
        String[] aa = new String[size];
        System.arraycopy(a, 0, aa, 0, size);
        return aa;
    }

    public static int getApiVersionOrdinalNumber(NVersion ss) {
        try {
            String s = ss.getValue();
            int qualifierIndex = s.indexOf(45);
            if (qualifierIndex >= 0) {
                s = s.substring(0, qualifierIndex);
            }
            int a = 0;
            for (String part : s.split("\\.")) {
                a = a * 100 + NLiteral.of(part).asInt().orElse(0);
            }
            return a;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static boolean isValidWorkspaceName(String workspace) {
        if (NBlankable.isBlank(workspace)) {
            return true;
        }
        String workspaceName = workspace.trim();
        return workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..");
    }

    public static String resolveValidWorkspaceName(String workspace) {
        if (NBlankable.isBlank(workspace)) {
            return "default-workspace";
        }
        String workspaceName = workspace.trim();
        if (workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..")) {
            return workspaceName;
        }
        String p = null;
        try {
            p = new File(workspaceName).getCanonicalFile().getName();
        }
        catch (IOException ex) {
            p = new File(workspaceName).getAbsoluteFile().getName();
        }
        if (p.isEmpty() || p.equals(".") || p.equals("..")) {
            return "unknown";
        }
        return p;
    }

    public static Properties copyOfNonNull(Properties p) {
        if (p == null) {
            return new Properties();
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static Properties copyOfOrNull(Properties p) {
        if (p == null) {
            return null;
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static boolean isUnsupportedFetchModeException(Throwable ex) {
        Object msg = null;
        if (ex instanceof NFetchModeNotSupportedException) {
            return true;
        }
        if (ex instanceof NArtifactNotFoundException && ex.getCause() != null) {
            Throwable ex2 = ex.getCause();
            return ex2 instanceof NFetchModeNotSupportedException;
        }
        return false;
    }

    public static NIdType detectIdType(NId depId) {
        switch (depId.getShortName()) {
            case "net.thevpc.nuts:nuts": {
                return NIdType.API;
            }
            case "net.thevpc.nuts:nuts-runtime": {
                return NIdType.RUNTIME;
            }
        }
        String rt = NWorkspace.of().getRuntimeId().getShortName();
        if (rt.equals(depId.getShortName())) {
            return NIdType.RUNTIME;
        }
        for (NClassLoaderNode n : NWorkspace.of().getBootExtensionClassLoaderNode()) {
            if (n.getId() == null || !n.getId().equalsShortId(depId)) continue;
            return NIdType.EXTENSION;
        }
        return NIdType.REGULAR;
    }

    public static List<NId> resolveNutsApiIdsFromId(NId id) {
        List<NDependency> deps = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition().getDependencies().get().transitive().toList();
        return CoreNUtils.resolveNutsApiIdsFromDependencyList(deps);
    }

    public static List<NId> resolveNutsApiIdsFromDefinition(NDefinition def) {
        return CoreNUtils.resolveNutsApiFromFromDependencies(def.getDependencies().get());
    }

    public static List<NId> resolveNutsApiFromFromDependencies(NDependencies deps) {
        return CoreNUtils.resolveNutsApiIdsFromDependencyList(deps.transitiveWithSource().toList());
    }

    public static List<NId> resolveNutsApiIdsFromDependencyList(List<NDependency> deps) {
        return deps.stream().map(NDependency::toId).filter(x -> NId.getApi("").get().equalsShortId((NId)x)).distinct().collect(Collectors.toList());
    }

    public static List<NId> resolveNutsApiIdsFromIdList(List<NId> deps) {
        return deps.stream().filter(x -> NId.getApi("").get().equalsShortId((NId)x)).distinct().collect(Collectors.toList());
    }

    public static void formatAndHorizontalAlign(NTextBuilder sb, NPositionType a, int columns) {
        switch (a) {
            case FIRST: {
                int length;
                for (length = sb.length(); length < columns; ++length) {
                    sb.append(NText.ofSpace());
                }
                break;
            }
            case LAST: {
                int length;
                while (length < columns) {
                    sb.insert(0, NText.ofSpace());
                    ++length;
                }
                break;
            }
            case CENTER: {
                int length;
                boolean after = true;
                while (length < columns) {
                    if (after) {
                        sb.append(NText.ofSpace());
                    } else {
                        sb.insert(0, NText.ofSpace());
                    }
                    after = !after;
                    ++length;
                }
                break;
            }
            case HEADER: {
                int length;
                boolean after = true;
                int maxBefore = 10;
                while (length < columns) {
                    if (after || maxBefore <= 0) {
                        sb.append(NText.ofSpace());
                    } else {
                        sb.insert(0, NText.ofSpace());
                        --maxBefore;
                    }
                    after = !after;
                    ++length;
                }
                break;
            }
            default: {
                throw new NUnsupportedArgumentException(NMsg.ofC("unsupported position type %s", a));
            }
        }
    }

    public static boolean isCustomTrue(String name) {
        return NWorkspace.of().getCustomBootOption(name).ifEmpty(NLiteral.of("true")).flatMap(NLiteral::asBoolean).orElse(false);
    }

    public static boolean isCustomFalse(String name) {
        return NWorkspace.of().getCustomBootOption(name).flatMap(NLiteral::asBoolean).orElse(false);
    }

    public static RuntimeException toUncheckedException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static boolean isShowCommand() {
        return NWorkspace.of().getCustomBootOption("---show-command").flatMap(NLiteral::asBoolean).orElse(false);
    }

    public static Object checkCopiableValue(Object value) {
        if (!CoreNUtils.isCopiableValue(value)) {
            throw new IllegalArgumentException("value is not copiable : " + value);
        }
        return value;
    }

    public static boolean isImmutableValue(Object value) {
        if (value == null) {
            return true;
        }
        switch (value.getClass().getName()) {
            case "java.lang.Boolean": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": 
            case "java.lang.Byte": 
            case "java.lang.Character": 
            case "java.lang.String": {
                return true;
            }
        }
        return value instanceof NImmutable;
    }

    public static boolean isCopiableValue(Object value) {
        if (CoreNUtils.isImmutableValue(value)) {
            return true;
        }
        return value instanceof NCopiable;
    }

    public static Object copyValue(Object value) {
        if (CoreNUtils.isImmutableValue(value)) {
            return value;
        }
        if (value instanceof NCopiable) {
            return ((NCopiable)value).copy();
        }
        throw new IllegalArgumentException("value is not copiable : " + value);
    }

    static {
        _QUERY_EMPTY_ENV.put("arch", null);
        _QUERY_EMPTY_ENV.put("os", null);
        _QUERY_EMPTY_ENV.put("osdist", null);
        _QUERY_EMPTY_ENV.put("platform", null);
        _QUERY_EMPTY_ENV.put("desktop", null);
    }

    public static class NDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean daemon;

        NDefaultThreadFactory(String namePattern, boolean daemon) {
            this.daemon = daemon;
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = namePattern + "-" + CoreStringUtils.indexToString(poolNumber.getAndIncrement()) + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

