/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.util;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultUnitFormat {
    private static int[] ALL_POWS = new int[]{-12, -9, -6, -3, -2, -1, 0, 1, 2, 3, 6, 9, 12};
    boolean leadingZeros = false;
    boolean intermediateZeros = true;
    private boolean fixedLength = false;
    private boolean decimal = false;
    private int high = 6;
    private int low = -2;
    private int fractionDigits = 3;
    private int integerDigits = 3;
    private DecimalFormat decimalFormat = null;
    private int[] validPows = new int[0];
    private Set<Integer> excludedPows = new HashSet<Integer>();
    private String mainUnitName;

    public DefaultUnitFormat(String mainUnitName, boolean leadingZeros, boolean intermediateZeros, boolean fixedLength, int high, int low, boolean decimal) {
        this.mainUnitName = mainUnitName;
        this.leadingZeros = leadingZeros;
        this.intermediateZeros = intermediateZeros;
        this.fixedLength = fixedLength;
        this.high = high;
        this.low = low;
        this.decimal = decimal;
    }

    public DefaultUnitFormat(String format) {
        int e;
        if (format == null) {
            format = "";
        }
        if ((e = (format = format.trim()).indexOf(32)) < 0) {
            this.mainUnitName = format.trim();
            format = "";
        } else {
            this.mainUnitName = format.substring(0, e);
            format = format.substring(e + 1).trim();
        }
        if (this.mainUnitName.isEmpty()) {
            throw new IllegalArgumentException("expected unit name");
        }
        if (format.isEmpty()) {
            format = "M-3 M3 I2 D2";
        }
        this.leadingZeros = false;
        this.intermediateZeros = false;
        int low = Integer.MIN_VALUE;
        int high = Integer.MAX_VALUE;
        if (format != null) {
            boolean startInterval = true;
            char[] charArray = format.toCharArray();
            block9: for (int i = 0; i < charArray.length; ++i) {
                char c = Character.toUpperCase(charArray[i]);
                switch (c) {
                    case ' ': {
                        continue block9;
                    }
                    case 'X': {
                        ValAndI t = DefaultUnitFormat.readInt(charArray, i);
                        i = t.i;
                        this.requireValidMultiplier(t);
                        this.excludedPows.add(t.v);
                        continue block9;
                    }
                    case 'M': {
                        ValAndI t = DefaultUnitFormat.readInt(charArray, i);
                        i = t.i;
                        this.requireValidMultiplier(t);
                        if (startInterval) {
                            startInterval = false;
                            low = t.v;
                            continue block9;
                        }
                        high = t.v;
                        continue block9;
                    }
                    case 'D': {
                        this.decimal = true;
                        if (i + 1 >= charArray.length || !Character.isDigit(charArray[i + 1])) continue block9;
                        this.fractionDigits = charArray[++i] - 48;
                        continue block9;
                    }
                    case 'F': {
                        this.fixedLength = true;
                        continue block9;
                    }
                    case 'I': {
                        if (i + 1 >= charArray.length || !Character.isDigit(charArray[i + 1])) continue block9;
                        this.integerDigits = charArray[++i] - 48;
                        continue block9;
                    }
                    case '0': {
                        if (i == 0) {
                            this.leadingZeros = true;
                            continue block9;
                        }
                        this.intermediateZeros = true;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported " + c);
                    }
                }
            }
        }
        this.validPows = IntStream.of(ALL_POWS).mapToObj(x -> x).filter(x -> !this.excludedPows.contains(x)).mapToInt(x -> x).toArray();
        if (this.validPows.length == 0) {
            throw new IllegalArgumentException("invalid powers");
        }
        if (low == Integer.MIN_VALUE) {
            low = this.validPows[0];
        }
        if (high == Integer.MAX_VALUE) {
            high = this.validPows[this.validPows.length - 1];
        }
        this.low = low;
        this.high = high;
        if (this.high < this.low) {
            int t = this.low;
            this.low = this.high;
            this.high = t;
        }
        this.decimal = true;
        this.decimalFormat = this.fixedLength ? new DecimalFormat("0." + NStringUtils.repeat('0', this.integerDigits)) : new DecimalFormat("0.0");
    }

    private void requireValidMultiplier(ValAndI t) {
        if (!this.isValidGenPow(t.v)) {
            throw new IllegalArgumentException("Invalid Power " + t.v);
        }
    }

    private boolean isValidGenPow(int cc) {
        for (int pow : ALL_POWS) {
            if (pow != cc) continue;
            return true;
        }
        return false;
    }

    public String toPattern() {
        StringBuilder sb = new StringBuilder();
        if (this.leadingZeros) {
            sb.append('0');
        }
        sb.append(' ').append('M').append(this.low);
        sb.append(' ').append('M').append(this.high);
        if (this.decimal) {
            sb.append('D').append(this.fractionDigits);
        }
        sb.append('I').append(this.integerDigits);
        if (this.fixedLength) {
            sb.append('F');
        }
        if (this.intermediateZeros) {
            sb.append(' ');
            sb.append('0');
        }
        return sb.toString();
    }

    private String formatLeftPow(double number, int pow) {
        return this.formatLeft(number * 1.0 / Math.pow(10.0, pow));
    }

    private String formatLeft(double number) {
        String s = this.decimal ? this.formatLeft(number, this.integerDigits + 1 + this.fractionDigits) : this.formatLeft(number, this.integerDigits);
        return s;
    }

    private String formatLeft(Object number, int size) {
        if (!this.decimal) {
            if (this.fixedLength) {
                return NStringUtils.alignLeft(String.valueOf(number), size);
            }
            return String.valueOf(number);
        }
        String s = this.decimalFormat.format(number);
        if (this.fixedLength) {
            return NStringUtils.alignLeft(s, size);
        }
        return s;
    }

    public NText formatDouble(double value) {
        return this.format(value);
    }

    private int evalInv(String pow) {
        if (pow.endsWith(this.mainUnitName)) {
            pow = pow.substring(0, pow.length() - this.mainUnitName.length());
        }
        switch (pow) {
            case "p": {
                return -12;
            }
            case "n": {
                return -9;
            }
            case "u": {
                return -6;
            }
            case "m": {
                return -3;
            }
            case "c": {
                return -2;
            }
            case "d": {
                return -1;
            }
            case "": {
                return 0;
            }
            case "da": {
                return 1;
            }
            case "h": {
                return 2;
            }
            case "k": {
                return 3;
            }
            case "M": {
                return 6;
            }
            case "G": {
                return 9;
            }
            case "T": {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private String strUnit(int pow) {
        switch (pow) {
            case -12: {
                return "p" + this.mainUnitName;
            }
            case -9: {
                return "n" + this.mainUnitName;
            }
            case -6: {
                return "u" + this.mainUnitName;
            }
            case -3: {
                return "m" + this.mainUnitName;
            }
            case -2: {
                return "c" + this.mainUnitName;
            }
            case -1: {
                return "d" + this.mainUnitName;
            }
            case 0: {
                return this.mainUnitName;
            }
            case 1: {
                return "da" + this.mainUnitName;
            }
            case 2: {
                return "h" + this.mainUnitName;
            }
            case 3: {
                return "k" + this.mainUnitName;
            }
            case 6: {
                return "M" + this.mainUnitName;
            }
            case 9: {
                return "G" + this.mainUnitName;
            }
            case 12: {
                return "T" + this.mainUnitName;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    public NText format(double value) {
        double v;
        NTextBuilder sb = NTextBuilder.of();
        boolean neg = value < 0.0;
        int sign = neg ? -1 : 1;
        double r = v = value < 0.0 ? -value : value;
        if (this.decimal) {
            if (v == 0.0) {
                sb.append((Object)this.formatLeft(0.0), NTextStyle.number());
                sb.append((Object)this.strUnit(this.low), NTextStyle.info());
            } else if (v < Math.pow(10.0, this.low)) {
                sb.append((Object)this.formatLeftPow(v * (double)sign, this.low), NTextStyle.number());
                sb.append((Object)this.strUnit(this.low), NTextStyle.info());
            } else if (v >= Math.pow(10.0, this.high)) {
                sb.append((Object)this.formatLeftPow(v * (double)sign, this.high), NTextStyle.number()).append((Object)this.strUnit(this.high), NTextStyle.info());
            } else {
                boolean ok = false;
                for (int i = this.validPows.length - 1; i >= 0; --i) {
                    double b = Math.pow(10.0, this.validPows[i]);
                    if (!(v >= b)) continue;
                    sb.append((Object)this.formatLeftPow(v * (double)sign, this.validPows[i]), NTextStyle.number()).append((Object)this.strUnit(this.validPows[i]), NTextStyle.info());
                    ok = true;
                    break;
                }
                if (!ok) {
                    sb.append((Object)this.formatLeftPow(v * (double)sign, this.validPows[0]), NTextStyle.number()).append((Object)this.strUnit(this.validPows[0]), NTextStyle.info());
                }
            }
            return sb.build();
        }
        throw new NIllegalArgumentException(NMsg.ofPlain("Not supported yet"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ValAndI readInt(char[] charArray, int i) {
        int v = 0;
        if (i + 1 >= charArray.length) throw new IllegalArgumentException("Invalid");
        boolean nn = false;
        if (charArray[++i] == '-') {
            nn = true;
            ++i;
        }
        int r = 0;
        if (i >= charArray.length || !Character.isDigit(charArray[i])) throw new IllegalArgumentException("Invalid");
        r = r * 10 + (charArray[i] - 48);
        while (i + 1 < charArray.length && Character.isDigit(charArray[i + 1])) {
            r = r * 10 + (charArray[++i] - 48);
        }
        v = nn ? -r : r;
        return new ValAndI(v, i);
    }

    private static class ValAndI {
        int v;
        int i;

        public ValAndI(int v, int i) {
            this.v = v;
            this.i = i;
        }
    }
}

