/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.util;

import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.time.NDurationFormatMode;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDurationFormat2 {
    private NDurationFormatMode mode;
    private static DecimalFormat F2 = new DecimalFormat("00");
    private static DecimalFormat F3 = new DecimalFormat("000");
    private static DecimalFormat F9 = new DecimalFormat("000000000");
    private static DecimalFormat F6 = new DecimalFormat("000000");

    public DefaultNDurationFormat2(NDurationFormatMode mode) {
        this.mode = mode == null ? NDurationFormatMode.DEFAULT : mode;
    }

    public DefaultNDurationFormat2(String pattern) {
        if (NBlankable.isBlank(pattern)) {
            this.mode = NDurationFormatMode.DEFAULT;
        } else {
            switch (pattern.toLowerCase().trim()) {
                case "clock": {
                    this.mode = NDurationFormatMode.CLOCK;
                    break;
                }
                case "fixed": {
                    this.mode = NDurationFormatMode.FIXED;
                    break;
                }
                default: {
                    this.mode = NDurationFormatMode.DEFAULT;
                }
            }
        }
    }

    public NText formatMillis(long millis) {
        return this.format(millis, 0);
    }

    public NText formatNanos(long nanos) {
        return this.format(nanos / 1000000L, (int)(nanos % 1000000L));
    }

    public NText format(long millis, int nanos) {
        if (millis < 0L) {
            throw new IllegalArgumentException("invalid millis " + millis);
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("invalid nanos " + millis);
        }
        return this.format(NDuration.ofMillisAndNanos(millis, nanos));
    }

    public NText format(Duration duration) {
        return this.format(NDuration.ofDuration(duration));
    }

    public void formatUnit(NDuration duration, ChronoUnit unit, Set<ChronoUnit> processed, NTextBuilder out) {
        int uordinal = unit.ordinal();
        long unitValue = duration.get(unit);
        ChronoUnit[] chronoValues = ChronoUnit.values();
        boolean nextIsZero = uordinal > 0 && duration.isZeroDown(chronoValues[uordinal - 1]);
        boolean empty = processed.isEmpty();
        if (unitValue == 0L && this.mode == NDurationFormatMode.DEFAULT) {
            boolean canSkip = true;
            if (!empty && nextIsZero) {
                canSkip = false;
            }
            if (canSkip) {
                return;
            }
        }
        if (uordinal > duration.getLargestUnit().ordinal() || uordinal < duration.getSmallestUnit().ordinal()) {
            return;
        }
        switch (unit) {
            case YEARS: 
            case MONTHS: 
            case WEEKS: 
            case DAYS: {
                if (!this.accept(unit, duration)) break;
                if (!empty) {
                    out.append(" ");
                }
                out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                out.append((Object)this.unitString(unit), NTextStyle.info());
                processed.add(unit);
                break;
            }
            case HOURS: {
                if (this.mode == NDurationFormatMode.CLOCK) {
                    if (!empty) {
                        out.append(" ");
                    }
                    out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                    processed.add(unit);
                    break;
                }
                if (!this.accept(unit, duration)) break;
                if (!empty) {
                    out.append(" ");
                }
                out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                out.append((Object)this.unitString(unit), NTextStyle.info());
                processed.add(unit);
                break;
            }
            case MINUTES: 
            case SECONDS: {
                if (this.mode == NDurationFormatMode.CLOCK) {
                    if (processed.contains(chronoValues[unit.ordinal() + 1])) {
                        out.append((Object)Character.valueOf(':'), NTextStyle.separator());
                    }
                    out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                    processed.add(unit);
                    break;
                }
                if (!this.accept(unit, duration)) break;
                if (!empty) {
                    out.append(Character.valueOf(' '));
                }
                out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                out.append((Object)this.unitString(unit), NTextStyle.info());
                processed.add(unit);
                break;
            }
            case MILLIS: {
                if (this.mode == NDurationFormatMode.CLOCK) {
                    if (!processed.contains(ChronoUnit.SECONDS)) {
                        out.append((Object)"00.", NTextStyle.number());
                    } else {
                        out.append((Object)Character.valueOf('.'), NTextStyle.number());
                    }
                    out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                    processed.add(unit);
                    break;
                }
                if (!this.accept(unit, duration)) break;
                if (!processed.isEmpty()) {
                    out.append(" ");
                }
                out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                out.append((Object)this.unitString(unit), NTextStyle.info());
                processed.add(unit);
                break;
            }
            case MICROS: 
            case NANOS: {
                if (this.mode == NDurationFormatMode.CLOCK) {
                    out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                    processed.add(unit);
                    break;
                }
                if (!this.accept(unit, duration)) break;
                if (!processed.isEmpty()) {
                    out.append(" ");
                }
                out.append((Object)this.formatNumber(unitValue, unit), NTextStyle.number());
                out.append((Object)this.unitString(unit), NTextStyle.info());
                processed.add(unit);
            }
        }
    }

    private boolean accept(ChronoUnit c, NDuration duration) {
        if (c.ordinal() < duration.getSmallestUnit().ordinal()) {
            return false;
        }
        switch (this.mode) {
            case DEFAULT: {
                return duration.get(c) != 0L;
            }
            case CLOCK: {
                return true;
            }
        }
        return true;
    }

    public NText format(NDuration duration) {
        NTextBuilder sb = NTextBuilder.of();
        this.print(duration, sb);
        return sb.build();
    }

    public NText format(NDuration duration, NTexts texts) {
        NTextBuilder sb = texts.ofBuilder();
        this.print(duration, sb);
        return sb.build();
    }

    public void print(NDuration duration, NTextBuilder out) {
        HashSet<ChronoUnit> processed = new HashSet<ChronoUnit>();
        for (ChronoUnit chronoUnit : new ChronoUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.WEEKS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.MILLIS, ChronoUnit.MICROS, ChronoUnit.NANOS}) {
            this.formatUnit(duration, chronoUnit, processed, out);
        }
        if (processed.isEmpty()) {
            out.append((Object)this.formatNumber(0L, duration.getSmallestUnit()), NTextStyle.number());
            out.append((Object)this.unitString(duration.getSmallestUnit()), NTextStyle.info());
        } else if (this.mode == NDurationFormatMode.CLOCK) {
            if (processed.contains(ChronoUnit.MILLIS)) {
                processed.add(ChronoUnit.SECONDS);
                processed.remove(ChronoUnit.MILLIS);
            }
            if (processed.contains(ChronoUnit.MICROS)) {
                processed.add(ChronoUnit.SECONDS);
                processed.remove(ChronoUnit.MICROS);
            }
            if (processed.contains(ChronoUnit.NANOS)) {
                processed.add(ChronoUnit.SECONDS);
                processed.remove(ChronoUnit.NANOS);
            }
            if (processed.size() == 1) {
                for (ChronoUnit chronoUnit : processed) {
                    if (chronoUnit.ordinal() > ChronoUnit.HOURS.ordinal()) continue;
                    out.append((Object)this.unitString(chronoUnit), NTextStyle.info());
                }
            }
        }
    }

    private int sizeOf(ChronoUnit unit) {
        switch (unit) {
            case MILLIS: 
            case MICROS: 
            case NANOS: {
                return 3;
            }
        }
        return 2;
    }

    private String formatNumber(long number, ChronoUnit unit) {
        int size = this.sizeOf(unit);
        switch (this.mode) {
            case DEFAULT: {
                return String.valueOf(number);
            }
            case FIXED: {
                return NStringUtils.formatAlign("" + number, size, NPositionType.LAST);
            }
            case CLOCK: {
                switch (unit) {
                    case HOURS: 
                    case MINUTES: 
                    case SECONDS: 
                    case MILLIS: 
                    case MICROS: 
                    case NANOS: {
                        switch (size) {
                            case 2: {
                                return F2.format(number);
                            }
                            case 3: {
                                return F3.format(number);
                            }
                            case 6: {
                                return F6.format(number);
                            }
                            case 9: {
                                return F9.format(number);
                            }
                        }
                    }
                }
                return NStringUtils.formatAlign("" + number, size, NPositionType.LAST);
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    public NDurationFormatMode getMode() {
        return this.mode;
    }

    public String unitString(ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return "y";
            }
            case MONTHS: {
                return "m";
            }
            case WEEKS: {
                return "w";
            }
            case DAYS: {
                return "d";
            }
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "mn";
            }
            case SECONDS: {
                return "s";
            }
            case MILLIS: {
                return "ms";
            }
            case MICROS: {
                return "us";
            }
            case NANOS: {
                return "ns";
            }
        }
        return "";
    }
}

