/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thevpc.nuts.runtime.standalone.text.AbstractNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextVisitor;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NCharQueue;
import net.thevpc.nuts.util.NMatchType;
import net.thevpc.nuts.util.NMultiPattern;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NStringMatchResult;

public class NTFParser2
extends AbstractNTextNodeParser {
    private StringBuffer buffer = new StringBuffer();
    private static String[] SHARPS = new String[]{"", "#", "##", "###", "####", "#####", "######", "#######", "########", "#########", "##########", "###########", "############", "#############", "##############", "###############"};
    private final NCharQueue q = new NCharQueue();
    private NTexts txt;
    private boolean wasNewLine = true;
    private Stack<Embedded> stackedStyles = new Stack();

    public NTFParser2() {
        this.txt = new DefaultNTexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(char c) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            this.q.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eof(boolean c) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            this.q.eof(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(String c) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            this.q.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(char[] c) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            this.q.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(char[] c, int offset, int len) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            this.q.write(c, offset, len);
        }
    }

    private void resetBuffer() {
        this.buffer.delete(0, this.buffer.length());
    }

    @Override
    public NText read() {
        return this.read(false);
    }

    @Override
    public NText readFully() {
        return this.read(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NText read(boolean fully) {
        NCharQueue nCharQueue = this.q;
        synchronized (nCharQueue) {
            StepEnum mode;
            Embedded embedded;
            block29: while (this.q.hasNext()) {
                embedded = this.stackedStyles.isEmpty() ? null : this.stackedStyles.peek();
                mode = embedded == null ? StepEnum.TEXT : embedded.mode;
                switch (this.q.peek()) {
                    case '}': {
                        NText nText;
                        this.wasNewLine = false;
                        if (mode != StepEnum.COMPOSITE_STYLE) {
                            this.buffer.append(this.q.read());
                            continue block29;
                        }
                        NStringMatchResult n1 = this.q.peekString("}##", fully);
                        if (n1.mode() == NMatchType.FULL_MATCH) {
                            this.q.read(n1.count());
                            nText = this.pushUpCompositeStyle();
                            if (nText == null) continue block29;
                            return nText;
                        }
                        if (n1.mode() != NMatchType.NO_MATCH) {
                            return null;
                        }
                        this.buffer.append(this.q.read());
                        continue block29;
                    }
                    case '#': {
                        if (mode == StepEnum.CODE) {
                            this.buffer.append(this.q.read());
                            continue block29;
                        }
                        int simpleLvl = (embedded == null ? 0 : embedded.level) + 1;
                        NRef ret = NRef.ofNull();
                        this.q.doWithPattern(new NMultiPattern().setFully(fully).onFullMatch("##:(?<n>[!a-zA-Z0-9_,(')/%+-]+)[: ]", m -> {
                            String a = m.get();
                            String s = m.get("n");
                            this.wasNewLine = false;
                            NTextStyles ss = NTextStyles.parse(s).orNull();
                            this.q.read(m.count());
                            NText p = this.pushUp(this.consumeBuffer());
                            if (ss == null) {
                                this.buffer.append(a);
                            } else {
                                this.pushSimpleStyle(ss);
                            }
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onFullMatch("##\\{(?<n>[!a-zA-Z0-9_,(')/%+-]+)[: ]", m -> {
                            this.wasNewLine = false;
                            String a = m.get();
                            String s = m.get("n");
                            NTextStyles ss = NTextStyles.parse(s).orNull();
                            this.q.read(m.count());
                            NText p = this.pushUp(this.consumeBuffer());
                            if (ss == null) {
                                this.buffer.append(a);
                            } else {
                                this.pushCompositeStyle(ss);
                            }
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onFullMatch("#+[)]", this.wasNewLine && (mode == StepEnum.TEXT || mode == StepEnum.COMPOSITE_STYLE), m -> {
                            this.wasNewLine = false;
                            String s = m.get();
                            this.q.read(m.count());
                            if (this.q.hasNext() && this.q.peek() == ' ') {
                                this.q.read();
                            }
                            NText p = this.pushUp(this.consumeBuffer());
                            this.pushTitle(s.length() - 1);
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onFullMatch((simpleLvl < SHARPS.length ? SHARPS[simpleLvl] : "") + "($|[^#])", simpleLvl < SHARPS.length && mode == StepEnum.SIMPLE_STYLE, m -> {
                            this.wasNewLine = false;
                            this.q.read(SHARPS[simpleLvl].length());
                            NText p = this.pushUpSimpleStyle();
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onFullMatch("##{" + (simpleLvl + 1) + ",}", mode == StepEnum.SIMPLE_STYLE, m -> {
                            this.wasNewLine = false;
                            this.q.read(m.count());
                            NText p = this.pushUp(this.consumeBuffer());
                            this.pushSimpleStyle(m.count() - 1);
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onFullMatch("##+", mode != StepEnum.SIMPLE_STYLE, m -> {
                            int count = m.count();
                            this.q.read(count);
                            this.wasNewLine = false;
                            NText p = this.pushUp(this.consumeBuffer());
                            this.pushSimpleStyle(count - 1);
                            if (p != null) {
                                ret.set(p);
                            }
                        }).onNoMatch(() -> {
                            this.wasNewLine = false;
                            this.buffer.append(this.q.read());
                        }).onMatch(c -> ret.set(null)).onPartialMatch(c -> ret.set(null)));
                        if (!ret.isSet()) continue block29;
                        return (NText)ret.get();
                    }
                    case '\\': {
                        String s;
                        if (mode == StepEnum.CODE) {
                            s = this.q.peek(4);
                            if (s.length() == 4) {
                                this.wasNewLine = false;
                                if (s.equals("\\```")) {
                                    this.q.read();
                                    this.buffer.append(this.q.read());
                                    continue block29;
                                }
                                this.buffer.append(this.q.read(2));
                                continue block29;
                            }
                            if (!this.q.isEOF()) {
                                return null;
                            }
                            this.wasNewLine = false;
                            this.buffer.append(this.q.read());
                            continue block29;
                        }
                        s = this.q.peek(4);
                        if (s.equals("\\```")) {
                            this.q.read(4);
                            this.wasNewLine = false;
                            this.buffer.append("```");
                            continue block29;
                        }
                        s = this.q.peek(2);
                        if (s.length() == 2) {
                            switch (s.charAt(1)) {
                                case '\\': {
                                    this.wasNewLine = false;
                                    this.q.read(2);
                                    this.buffer.append("\\");
                                    continue block29;
                                }
                                case '#': {
                                    this.wasNewLine = false;
                                    this.q.read(2);
                                    this.buffer.append("#");
                                    continue block29;
                                }
                                case '\u001e': {
                                    this.wasNewLine = false;
                                    this.q.read(2);
                                    continue block29;
                                }
                            }
                            this.wasNewLine = false;
                            this.buffer.append(this.q.read(2));
                            continue block29;
                        }
                        if (!this.q.isEOF()) {
                            return null;
                        }
                        this.wasNewLine = false;
                        this.buffer.append(this.q.read());
                        continue block29;
                    }
                    case '\u001e': {
                        if (mode == StepEnum.CODE) {
                            this.wasNewLine = false;
                            this.buffer.append(this.q.read());
                            continue block29;
                        }
                        this.wasNewLine = false;
                        this.q.read();
                        continue block29;
                    }
                    case '\n': 
                    case '\r': {
                        String s;
                        if (mode == StepEnum.CODE) {
                            this.wasNewLine = false;
                            this.buffer.append(this.q.read());
                            continue block29;
                        }
                        if (mode == StepEnum.TITLE) {
                            s = this.q.readNewLine(true);
                            if (s != null) {
                                this.wasNewLine = true;
                                return this.pushUpTitle();
                            }
                            this.wasNewLine = false;
                            return null;
                        }
                        s = this.q.readNewLine(fully);
                        if (s == null) {
                            return null;
                        }
                        this.wasNewLine = true;
                        this.buffer.append(s);
                        continue block29;
                    }
                    case '`': {
                        NText nText;
                        NStringMatchResult n = this.q.peekPattern("```", fully);
                        if (mode == StepEnum.CODE) {
                            switch (n.mode()) {
                                case FULL_MATCH: {
                                    this.wasNewLine = false;
                                    this.q.read(3);
                                    nText = this.pushUpCode();
                                    if (nText == null) continue block29;
                                    return nText;
                                }
                                case NO_MATCH: {
                                    this.wasNewLine = false;
                                    this.buffer.append(this.q.read());
                                    continue block29;
                                }
                            }
                            return null;
                        }
                        switch (n.mode()) {
                            case FULL_MATCH: {
                                this.q.read(3);
                                NText p = this.pushUp(this.consumeBuffer());
                                this.pushCode();
                                if (p == null) continue block29;
                                this.wasNewLine = false;
                                return p;
                            }
                            case NO_MATCH: {
                                this.wasNewLine = false;
                                this.buffer.append(this.q.read());
                                continue block29;
                            }
                        }
                        return null;
                    }
                }
                this.wasNewLine = false;
                this.buffer.append(this.q.read());
            }
            if (fully) {
                while (!this.stackedStyles.isEmpty()) {
                    Embedded e = this.stackedStyles.peek();
                    switch (e.mode.ordinal()) {
                        case 3: {
                            NText p = this.pushUpSimpleStyle();
                            if (p == null) break;
                            return p;
                        }
                        case 4: {
                            NText p = this.pushUpCompositeStyle();
                            if (p == null) break;
                            return p;
                        }
                        case 0: {
                            NText p = this.pushUpCode();
                            if (p == null) break;
                            return p;
                        }
                        case 2: {
                            NText p = this.pushUpTitle();
                            if (p == null) break;
                            return p;
                        }
                    }
                }
            }
            embedded = this.stackedStyles.isEmpty() ? null : this.stackedStyles.peek();
            StepEnum stepEnum = mode = embedded == null ? StepEnum.TEXT : embedded.mode;
            if (mode == StepEnum.TEXT) {
                return this.pushUp(this.consumeBuffer());
            }
            return null;
        }
    }

    private NText pushUpCode() {
        Embedded embedded = this.stackedStyles.peek();
        String b = this.consumeBuffer();
        this.stackedStyles.pop();
        return this.pushUp(this.txt.ofCodeOrCommand(b));
    }

    private NText pushUpTitle() {
        Embedded embedded = this.stackedStyles.peek();
        this.pushUp(this.consumeBuffer());
        this.stackedStyles.pop();
        return this.pushUp(this.txt.ofTitle(this.txt.ofList(embedded.children), embedded.level));
    }

    private NText pushUpCompositeStyle() {
        Embedded embedded = this.stackedStyles.peek();
        this.pushUp(this.consumeBuffer());
        this.stackedStyles.pop();
        return this.pushUp(this.txt.ofStyled(this.txt.ofList(embedded.children).simplify(), embedded.style).simplify());
    }

    private NText pushUpSimpleStyle() {
        Embedded embedded = this.stackedStyles.peek();
        this.wasNewLine = false;
        this.pushUp(this.consumeBuffer());
        this.stackedStyles.pop();
        return this.pushUp(this.txt.ofStyled(this.txt.ofList(embedded.children).simplify(), embedded.style).simplify());
    }

    private void pushCompositeStyle(NTextStyles style) {
        this.stackedStyles.push(new Embedded(StepEnum.COMPOSITE_STYLE, style, 0));
    }

    private void pushCode() {
        this.stackedStyles.push(new Embedded(StepEnum.CODE, null, 0));
    }

    private void pushSimpleStyle(int level) {
        this.stackedStyles.push(new Embedded(StepEnum.SIMPLE_STYLE, NTextStyles.parse("p" + level).get(), level));
    }

    private void pushSimpleStyle(NTextStyles s) {
        this.stackedStyles.push(new Embedded(StepEnum.SIMPLE_STYLE, s, 1));
    }

    private void pushTitle(int level) {
        this.stackedStyles.push(new Embedded(StepEnum.TITLE, null, level));
    }

    private NText pushUp(NText t) {
        if (t == null) {
            return null;
        }
        if (!this.stackedStyles.isEmpty()) {
            this.stackedStyles.peek().children.add(t);
            return null;
        }
        return t;
    }

    private NText pushUp(String t) {
        if (t == null) {
            return null;
        }
        if (t.length() > 0) {
            return this.pushUp(this.txt.ofPlain(t));
        }
        return null;
    }

    private String consumeBuffer() {
        String s = this.buffer.toString();
        this.resetBuffer();
        return s;
    }

    @Override
    public void reset() {
        this.q.clear();
        this.stackedStyles.clear();
    }

    @Override
    public long parseRemaining(NTextVisitor visitor) {
        NText n;
        long b = 0L;
        while ((n = this.readFully()) != null) {
            ++b;
            visitor.visit(n);
        }
        if (this.q.hasNext()) {
            n = this.readFully();
            if (n != null) {
                visitor.visit(n);
            } else {
                throw new IllegalArgumentException("parseRemaining failed because readFull returns null whereas the stream is not empty?");
            }
        }
        return b;
    }

    @Override
    public long parseIncremental(char[] buf, int off, int len, NTextVisitor visitor) {
        NText n;
        this.offer(buf, off, len);
        long b = 0L;
        while ((n = this.read()) != null) {
            ++b;
            visitor.visit(n);
        }
        return b;
    }

    @Override
    public boolean isIncomplete() {
        return this.q.length() > 0 || this.buffer.length() > 0 || !this.stackedStyles.isEmpty();
    }

    private static boolean containsNewline(char[] all) {
        for (char c : all) {
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    private static class Embedded {
        NTextStyles style;
        int level;
        StepEnum mode;
        List<NText> children = new ArrayList<NText>();

        public Embedded(StepEnum mode, NTextStyles style, int level) {
            this.style = style;
            this.mode = mode;
            this.level = level;
        }
    }

    static enum StepEnum {
        CODE,
        TEXT,
        TITLE,
        SIMPLE_STYLE,
        COMPOSITE_STYLE;

    }
}

