/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.DefaultNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.ParserStep;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NStringUtils;

public class TitleParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();
    List<ParserStep> children = new ArrayList<ParserStep>();

    public TitleParserStep(String c) {
        this.start.append(c);
    }

    @Override
    public void consume(char c, DefaultNTextNodeParser.State p, boolean wasNewLine) {
        if (c == ' ' && this.children.isEmpty()) {
            this.start.append(c);
        } else if (c == '\n' || c == '\r') {
            p.applyPopReplay(this, c);
        } else {
            p.applyPush(c, false, false, false);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        this.children.add(tt);
    }

    @Override
    public NText toText() {
        String s = this.start.toString();
        DefaultNTexts factory0 = (DefaultNTexts)NTexts.of();
        String s0 = s.trim();
        NText child = null;
        if (this.children.size() == 1) {
            child = this.children.get(0).toText();
        } else {
            ArrayList<NText> all = new ArrayList<NText>();
            for (ParserStep a : this.children) {
                all.add(a.toText());
            }
            child = NText.ofList(all).simplify();
        }
        return factory0.createTitle(s, s0.length() - 1, child, this.isComplete());
    }

    @Override
    public void end(DefaultNTextNodeParser.State p) {
        p.applyPop(this);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Title(" + NStringUtils.formatStringLiteral(this.start.toString(), NElementType.DOUBLE_QUOTED_STRING));
        for (ParserStep parserStep : this.children) {
            sb.append(",");
            sb.append(parserStep.toString());
        }
        return sb.append(")").toString();
    }
}

