/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import java.util.ArrayList;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.text.NTextStyles;

public class StyledParserStepCmdParser {
    public boolean isCommandEnd(char c) {
        return c == ' ' || c == ':';
    }

    public boolean isCommandPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '/' || c == '_' || c == '+' || c == '!' || c == '-' || c == '%';
    }

    public NTextStyles parse(String atStr) {
        StringReaderExt r = new StringReaderExt(atStr);
        ArrayList<NTextStyle> parsedStyles = new ArrayList<NTextStyle>();
        if (r.hasNext() && r.peekChar() == ':') {
            r.readChar();
            while (!this.readEnd(r)) {
                NTextStyles s = this.readNextStyles(r);
                if (s == null) {
                    return null;
                }
                for (NTextStyle ss : s) {
                    parsedStyles.add(ss);
                }
            }
        } else {
            return null;
        }
        return NTextStyles.PLAIN.append(parsedStyles.toArray(new NTextStyle[0]));
    }

    private boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private boolean isDigitChar(char c) {
        return c >= '0' && c <= '9';
    }

    private String peekInt(StringReaderExt r, int from, int maxChars) {
        char c;
        int x = 0;
        StringBuilder s = new StringBuilder();
        while (r.hasNext(from + x) && this.isDigitChar(c = r.peekChar(from + x))) {
            s.append(c);
            if (++x != maxChars) continue;
            break;
        }
        if (!(x <= 0 || r.hasNext(from + x) && this.isDigitChar(r.peekChar(from + x)))) {
            try {
                Integer.parseInt(s.toString());
                return s.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean readEnd(StringReaderExt r) {
        if (!r.hasNext()) {
            return true;
        }
        if (r.peekChar() == ' ' || r.peekChar() == ':') {
            if (r.hasNext(1)) {
                return false;
            }
            r.nextChars(1);
            return true;
        }
        return false;
    }

    public NTextStyles parseSimpleNutsTextStyles(String str) {
        StringReaderExt e = new StringReaderExt(str);
        NTextStyles a = this.readNextStyles(e);
        if (a == null) {
            return null;
        }
        if (e.hasNext()) {
            return null;
        }
        return a;
    }

    private Integer readNextPrefixedInt8(String prefix, StringReaderExt r) {
        String s;
        int len = prefix.length();
        String ss = r.peekChars(len);
        if (ss.equalsIgnoreCase(prefix) && (s = this.peekInt(r, len, len + 3)) != null && s.length() > 0) {
            r.nextChars(len);
            r.nextChars(s.length());
            return Integer.parseInt(s, 10);
        }
        return null;
    }

    private Integer readNextPrefixedHexString(String prefix, StringReaderExt r) {
        int len = prefix.length();
        String ss = r.peekChars(len);
        if (ss.equalsIgnoreCase(prefix) && r.hasNext(len + 5) && this.isHexChar(r.peekChar(len + 0)) && this.isHexChar(r.peekChar(len + 1)) && this.isHexChar(r.peekChar(len + 2)) && this.isHexChar(r.peekChar(len + 3)) && this.isHexChar(r.peekChar(len + 4)) && this.isHexChar(r.peekChar(len + 5))) {
            String s = r.nextChars(len);
            s = r.nextChars(8);
            return Integer.parseInt(s, 16);
        }
        return null;
    }

    private NTextStyles readNextStyles(StringReaderExt r) {
        ArrayList<NTextStyle> all = new ArrayList<NTextStyle>();
        NTextStyle s = this.readNextStyle(r);
        if (s != null) {
            all.add(s);
            while (s != null && r.hasNext()) {
                if (',' == r.peekChar()) {
                    r.readChar();
                }
                s = this.readNextStyle(r);
            }
        }
        if (all.isEmpty()) {
            return null;
        }
        return NTextStyles.of(all.toArray(all.toArray(new NTextStyle[0])));
    }

    private NTextStyle readNextStyle(StringReaderExt r) {
        if (r.hasNext()) {
            char c = r.peekChar();
            switch (c) {
                case 'F': 
                case 'f': {
                    Integer ii = this.readNextPrefixedHexString("fx", r);
                    if (ii != null) {
                        return NTextStyle.foregroundTrueColor(ii);
                    }
                    ii = this.readNextPrefixedHexString("foregroundx", r);
                    if (ii != null) {
                        return NTextStyle.foregroundTrueColor(ii);
                    }
                    ii = this.readNextPrefixedInt8("f", r);
                    if (ii != null) {
                        return NTextStyle.foregroundColor(ii);
                    }
                    ii = this.readNextPrefixedInt8("foreground", r);
                    if (ii == null) break;
                    return NTextStyle.foregroundColor(ii);
                }
                case 'B': 
                case 'b': {
                    Integer ii = this.readNextPrefixedHexString("bx", r);
                    if (ii != null) {
                        return NTextStyle.backgroundTrueColor(ii);
                    }
                    ii = this.readNextPrefixedHexString("backgroundx", r);
                    if (ii != null) {
                        return NTextStyle.backgroundTrueColor(ii);
                    }
                    ii = this.readNextPrefixedInt8("b", r);
                    if (ii != null) {
                        return NTextStyle.backgroundColor(ii);
                    }
                    ii = this.readNextPrefixedInt8("background", r);
                    if (ii == null) break;
                    return NTextStyle.backgroundColor(ii);
                }
                case '/': {
                    r.readChar();
                    return NTextStyle.italic();
                }
                case '+': {
                    r.readChar();
                    return NTextStyle.bold();
                }
                case '%': {
                    r.readChar();
                    return NTextStyle.blink();
                }
                case '_': {
                    r.readChar();
                    return NTextStyle.underlined();
                }
                case '-': {
                    r.readChar();
                    return NTextStyle.striked();
                }
                case '!': {
                    r.readChar();
                    return NTextStyle.reversed();
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String s = this.peekInt(r, 0, 3);
                    if (s == null) break;
                    r.nextChars(s.length());
                    return NTextStyle.primary(Integer.parseInt(s));
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                String s;
                int x = 0;
                StringBuilder n = new StringBuilder();
                boolean expectN = false;
                while (r.hasNext(x)) {
                    char c2 = r.peekChar(x);
                    if (this.isDigitChar(c2)) {
                        expectN = true;
                        break;
                    }
                    if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_') && c2 != '-') break;
                    n.append(c2);
                    ++x;
                }
                String variantString = "";
                if (expectN && (s = this.peekInt(r, x, 3)) != null) {
                    variantString = s;
                }
                int variant = variantString.isEmpty() ? 0 : Integer.parseInt(variantString);
                int totLen = n.toString().length() + variantString.length();
                switch (n.toString().toLowerCase()) {
                    case "kw": {
                        r.nextChars(totLen);
                        return NTextStyle.keyword(variant);
                    }
                    case "p": {
                        r.nextChars(totLen);
                        return NTextStyle.primary(variant);
                    }
                    case "s": {
                        r.nextChars(totLen);
                        return NTextStyle.secondary(variant);
                    }
                    case "bool": {
                        r.nextChars(totLen);
                        return NTextStyle.bool(variant);
                    }
                }
                String sb2 = n.toString().toUpperCase();
                sb2 = sb2.replace('-', '_');
                NTextStyleType st = NTextStyleType.parse(sb2).orElse(NTextStyleType.ERROR);
                r.nextChars(totLen);
                return NTextStyle.of(st, variant);
            }
        }
        return null;
    }
}

