/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NErr;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.DefaultNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.ParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.StyledParserStepCmdParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.TitleParserStep;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NDebugString;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NEvictingCharQueue;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class StyledParserStep
extends ParserStep {
    public static final IntPredicate EXIT_ON_CLOSE_ACCOLADES = cc -> cc == 125 || cc == 35;
    private static Pattern NAME_AND_NUMBER = Pattern.compile("^(?<n>[a-zA-Z_-]+)(?<d>[0-9]*)$");
    int sharpsStartCount = 0;
    int sharpsEndCount = 0;
    CurState curState = CurState.EMPTY;
    List<NText> children = new ArrayList<NText>();
    NStringBuilder name = new NStringBuilder();
    NStringBuilder content = new NStringBuilder();
    boolean lineStart;
    int maxSize = 10;
    private NEvictingCharQueue charQueue = new NEvictingCharQueue(5);
    private DefaultNTextNodeParser.State state;
    private StyledParserStepCmdParser parseHelper = new StyledParserStepCmdParser();
    private boolean wasEscape;
    private boolean exitOnBrace;

    public StyledParserStep(char c, boolean lineStart, DefaultNTextNodeParser.State state, boolean exitOnBrace) {
        switch (c) {
            case '#': {
                this.curState = CurState.SHARP;
                this.sharpsStartCount = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid");
            }
        }
        this.lineStart = lineStart;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    public StyledParserStep(String c, boolean lineStart, DefaultNTextNodeParser.State state, boolean exitOnBrace) {
        if (c.charAt(0) == '#') {
            this.curState = CurState.SHARP;
            this.sharpsStartCount = 1;
            for (int i = 1; i < c.length(); ++i) {
                this.consume(c.charAt(i), state, false);
            }
        } else {
            throw new IllegalArgumentException("unsupported");
        }
        this.lineStart = lineStart;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    @Override
    public void consume(char c, DefaultNTextNodeParser.State state, boolean wasNewLine) {
        this.charQueue.add(c);
        NTexts text = NTexts.of();
        block0 : switch (this.curState.ordinal()) {
            case 0: {
                throw new IllegalArgumentException("unexpected");
            }
            case 1: {
                switch (c) {
                    case '\\': {
                        this.wasEscape = true;
                        if (this.sharpsStartCount == 1) {
                            this.beforeChangingStep();
                            state.applyDropReplacePreParsedPlain(this, "#", this.exitOnBrace);
                            break block0;
                        }
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsStartCount;
                        break block0;
                    }
                    case ')': {
                        this.beforeChangingStep();
                        state.applyDropReplace(this, new TitleParserStep(CoreStringUtils.fillString("#", this.sharpsStartCount) + ")"));
                        break block0;
                    }
                    case '\u001e': {
                        this.beforeChangingStep();
                        state.applyDropReplacePreParsedPlain(this, CoreStringUtils.fillString("#", this.sharpsStartCount), this.exitOnBrace);
                        break block0;
                    }
                    case ':': {
                        if (this.sharpsStartCount == 2) {
                            this.curState = CurState.SHARP2_COL_NAME;
                            break block0;
                        }
                        this.content.append(c);
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                    case '{': {
                        if (this.sharpsStartCount == 2) {
                            this.curState = CurState.SHARP2_OBRACE_NAME;
                            break block0;
                        }
                        this.content.append(c);
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                }
                if (c == '}' && this.exitOnBrace) {
                    state.applyDropReplacePreParsedPlain(this, CoreStringUtils.fillString("#", this.sharpsStartCount), false);
                    state.applyPop(this);
                    state.applyNextChar(c);
                    break;
                }
                if (this.sharpsStartCount == 1) {
                    this.beforeChangingStep();
                    state.applyDropReplacePreParsedPlain(this, CoreStringUtils.fillString("#", this.sharpsStartCount), this.exitOnBrace);
                    state.applyNextChar(c);
                    break;
                }
                this.content.append(c);
                this.curState = CurState.SHARP_CONTENT;
                break;
            }
            case 2: 
            case 6: {
                switch (c) {
                    case '\\': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        this.wasEscape = true;
                        break;
                    }
                    case '#': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add(text.ofPlain(this.content.removeAll()));
                        }
                        if (this.curState == CurState.SHARP_CONTENT) {
                            this.curState = CurState.SHARP_CONTENT_SHARP;
                        } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP;
                        } else {
                            throw new IllegalArgumentException("unexpected");
                        }
                        this.sharpsEndCount = 1;
                        break;
                    }
                    case '`': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add(text.ofPlain(this.content.removeAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break;
                    }
                    case '\u001e': {
                        if (!this.wasEscape) break block0;
                        this.wasEscape = false;
                        this.content.append(c);
                        break;
                    }
                    default: {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append('\\');
                            this.content.append(c);
                            break;
                        }
                        this.content.append(c);
                        break;
                    }
                }
                break;
            }
            case 3: 
            case 7: {
                switch (c) {
                    case '\\': {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(this, c);
                        } else {
                            this.content.append(CoreStringUtils.fillString("#", this.sharpsEndCount));
                            this.sharpsEndCount = 0;
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }
                            this.wasEscape = true;
                        }
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        break;
                    }
                    case '\u001e': {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPop(this);
                            break;
                        }
                        this.logErr("expected " + CoreStringUtils.fillString("#", this.sharpsStartCount) + "<END>");
                        this.sharpsEndCount = 0;
                        this.children.add(text.ofPlain(CoreStringUtils.fillString("#", this.sharpsStartCount)));
                        if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                            this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            break;
                        }
                        if (this.curState != CurState.SHARP2_COL_NAME_CONTENT_SHARP) break block0;
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                        break;
                    }
                    default: {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(this, c);
                            break;
                        }
                        if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                            this.curState = CurState.SHARP_CONTENT;
                        } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        }
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, state, false));
                        for (int i = 0; i < this.sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyNextChar(c);
                        break;
                    }
                }
                break;
            }
            case 5: 
            case 11: {
                switch (c) {
                    case '\\': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.name.append(c);
                            break block0;
                        }
                        this.wasEscape = true;
                        break block0;
                    }
                    case ':': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.name.append(c);
                            break block0;
                        }
                        if (this.curState == CurState.SHARP2_COL_NAME) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            break block0;
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                    case '\u001e': 
                    case '#': 
                    case '(': 
                    case ')': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            if (c == '\u001e') {
                                this.name.append(c);
                                break block0;
                            }
                            this.name.append('\\');
                            this.name.append(c);
                            break block0;
                        }
                        this.logErr("expected ':'");
                        if (this.curState == CurState.SHARP2_COL_NAME) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            break block0;
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                if (this.wasEscape) {
                    if (c <= ' ' || c == ':' || c == '#') {
                        this.name.append(c);
                    } else {
                        this.name.append('\\');
                        this.name.append(c);
                    }
                    this.wasEscape = false;
                    break;
                }
                if (c <= ' ') {
                    if (this.name.isEmpty()) break;
                    if (this.curState == CurState.SHARP2_COL_NAME) {
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        break;
                    }
                    this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                    break;
                }
                this.name.append(c);
                break;
            }
            case 12: {
                switch (c) {
                    case '#': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add(text.ofPlain(this.content.removeAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, state, true));
                        break;
                    }
                    case '}': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add(text.ofPlain(this.content.removeAll()));
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE;
                        break;
                    }
                    case '\u001e': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (this.content.isEmpty()) break block0;
                        this.children.add(text.ofPlain(this.content.removeAll()));
                        break;
                    }
                    case '`': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add(text.ofPlain(this.content.removeAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break;
                    }
                    default: {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append('\\');
                            this.content.append(c);
                            break;
                        }
                        this.content.append(c);
                        break;
                    }
                }
                break;
            }
            case 13: {
                switch (c) {
                    case '\\': {
                        this.content.append('{');
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.wasEscape = true;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP;
                        break block0;
                    }
                    case '`': {
                        this.children.add(text.ofPlain("}"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break block0;
                    }
                    case '\u001e': {
                        this.children.add(text.ofPlain("}"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                this.content.append(c);
                break;
            }
            case 14: {
                switch (c) {
                    case '\\': {
                        this.sharpsEndCount = 0;
                        this.content.append('{');
                        this.content.append('#');
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.wasEscape = true;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END;
                        state.applyPop(this);
                        break block0;
                    }
                    case '`': {
                        this.sharpsEndCount = 0;
                        this.children.add(text.ofPlain("}#"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break block0;
                    }
                    case '\u001e': {
                        this.sharpsEndCount = 0;
                        this.children.add(text.ofPlain("}#"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                this.sharpsEndCount = 0;
                this.children.add(text.ofPlain("}#"));
                this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                this.content.append(c);
                break;
            }
            case 4: {
                switch (c) {
                    case '#': {
                        this.curState = CurState.SHARP_CONTENT;
                        int _sharpsEndCount = this.sharpsEndCount;
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, state, false));
                        for (int i = 0; i < _sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(this, c);
                        break block0;
                    }
                }
                if (!this.content.isEmpty()) {
                    this.children.add(text.ofPlain(this.content.removeAll()));
                }
                state.applyPopReplay(this, c);
                break;
            }
            case 8: {
                switch (c) {
                    case '#': {
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        int _sharpsEndCount = this.sharpsEndCount;
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, state, false));
                        for (int i = 0; i < _sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(this, c);
                        break block0;
                    }
                }
                if (!this.content.isEmpty()) {
                    this.children.add(text.ofPlain(this.content.removeAll()));
                }
                state.applyPopReplay(this, c);
                break;
            }
            case 15: {
                if (!this.content.isEmpty()) {
                    this.children.add(text.ofPlain(this.content.removeAll()));
                }
                state.applyPopReplay(this, c);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected " + (Object)((Object)this.curState));
            }
        }
    }

    private void beforeChangingStep() {
        this.charQueue.clear();
    }

    @Override
    public void appendChild(ParserStep tt) {
        NText n = tt.toText();
        if (n instanceof NTextPlain && !this.children.isEmpty() && this.children.get(this.children.size() - 1) instanceof NTextPlain) {
            NTextPlain p1 = (NTextPlain)this.children.remove(this.children.size() - 1);
            NTextPlain p2 = (NTextPlain)n;
            this.children.add(new DefaultNTextPlain(p1.getValue() + p2.getValue()));
        } else {
            this.children.add(n);
        }
    }

    @Override
    public NText toText() {
        NText a;
        ArrayList<NText> childrenTextNodes2 = new ArrayList<NText>(this.children);
        NTexts text = NTexts.of();
        if (!this.content.isEmpty()) {
            childrenTextNodes2.add(text.ofPlain(this.content.toString()));
        }
        if ((a = text.ofList(childrenTextNodes2.toArray(new NText[0])).simplify()) == null) {
            return NText.ofBlank();
        }
        switch (this.curState.ordinal()) {
            case 1: {
                return text.ofPlain("#");
            }
            case 0: {
                return NText.ofBlank();
            }
            case 2: 
            case 3: 
            case 4: {
                return text.ofStyled(a, NTextStyle.primary(this.sharpsStartCount));
            }
            case 11: {
                return text.ofPlain("##{" + this.name.toString());
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                NTextStyles s = this.parseHelper.parseSimpleNutsTextStyles(this.name.toString());
                if (s != null) {
                    return text.ofStyled(a, s);
                }
                throw new NIllegalArgumentException(NMsg.ofC("unable to resolve style from %s", this.name.toString()));
            }
        }
        throw new NUnsupportedEnumException(this.curState);
    }

    @Override
    public void end(DefaultNTextNodeParser.State p) {
        p.applyPop(this);
    }

    @Override
    public boolean isComplete() {
        switch (this.curState.ordinal()) {
            case 4: 
            case 8: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private void logErr(String s) {
        if (NDebugString.of(NWorkspace.of().getBootOptions().getDebug().orNull()).isEnabled()) {
            NErr.println(s);
        }
    }

    public String toString() {
        String contentString = this.children.stream().map(Object::toString).collect(Collectors.joining()) + this.content;
        switch (this.curState.ordinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount);
            }
            case 2: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + contentString;
            }
            case 3: 
            case 4: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + contentString + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
            case 5: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name;
            }
            case 9: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + "#";
            }
            case 10: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + "##";
            }
            case 6: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + ":" + contentString;
            }
            case 7: 
            case 8: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + ":" + contentString + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
            case 11: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name;
            }
            case 12: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + contentString;
            }
            case 13: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + this.content + "}";
            }
            case 14: 
            case 15: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + contentString + "}" + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
        }
        return "<unexpected>";
    }

    static enum CurState {
        EMPTY,
        SHARP,
        SHARP_CONTENT,
        SHARP_CONTENT_SHARP,
        SHARP_CONTENT_SHARP_END,
        SHARP2_COL_NAME,
        SHARP2_COL_NAME_CONTENT,
        SHARP2_COL_NAME_CONTENT_SHARP,
        SHARP2_COL_NAME_CONTENT_SHARP_END,
        SHARP2_COL_NAME_SHARP1,
        SHARP2_COL_NAME_SHARP2,
        SHARP2_OBRACE_NAME,
        SHARP2_OBRACE_NAME_COL_CONTENT,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END;

    }

    static enum StyleMode {
        SIMPLE,
        COLON,
        EMBEDDED;

    }
}

