/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import java.util.ArrayList;
import java.util.LinkedList;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.DefaultNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.ParserStep;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;

public class RootParserStep
extends ParserStep {
    boolean spreadLines;
    LinkedList<ParserStep> available = new LinkedList();

    public RootParserStep(boolean spreadLines) {
        this.spreadLines = spreadLines;
    }

    @Override
    public void consume(char c, DefaultNTextNodeParser.State p, boolean wasNewLine) {
        p.applyPush(c, this.spreadLines, wasNewLine, false);
    }

    public ParserStep pop() {
        return this.available.pop();
    }

    public ParserStep poll() {
        return this.available.poll();
    }

    public ParserStep peek() {
        return this.available.peek();
    }

    public boolean isEmpty() {
        return this.available.isEmpty();
    }

    public int size() {
        return this.available.size();
    }

    @Override
    public void appendChild(ParserStep n) {
        this.available.add(n);
    }

    @Override
    public NText toText() {
        if (this.available.size() == 1) {
            return this.available.get(0).toText();
        }
        ArrayList<NText> all = new ArrayList<NText>();
        boolean partial = false;
        for (ParserStep a : this.available) {
            NText n;
            if (!partial && !a.isComplete()) {
                partial = true;
            }
            if ((n = a.toText()) instanceof DefaultNTextPlain && !all.isEmpty() && all.get(all.size() - 1) instanceof DefaultNTextPlain) {
                NTextPlain p1 = (NTextPlain)n;
                NTextPlain p2 = (NTextPlain)all.remove(all.size() - 1);
                all.add(new DefaultNTextPlain(p1.getValue() + p2.getValue()));
                continue;
            }
            all.add(n);
        }
        return NText.ofList(all).simplify();
    }

    @Override
    public void end(DefaultNTextNodeParser.State p) {
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        return "Root(" + this.available + ')';
    }
}

