/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import java.util.Objects;
import java.util.Stack;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.text.AbstractNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.AntiQuote3ParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.NewLineParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.ParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.PlainParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.RootParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.StyledParserStep;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextVisitor;

public class DefaultNTextNodeParser
extends AbstractNTextNodeParser {
    private State state = new State();

    public DefaultNTextNodeParser(NWorkspace workspace) {
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    @Override
    public void offer(String c) {
        this.offer(c.toCharArray());
    }

    @Override
    public void offer(char[] str) {
        this.offer(str, 0, str.length);
    }

    @Override
    public void offer(char[] s, int offset, int len) {
        for (int i = offset; i < len; ++i) {
            this.offer(s[i]);
        }
    }

    @Override
    public void offer(char s) {
        this.state().onNewChar(s);
    }

    public State state() {
        return this.state;
    }

    @Override
    public long parseIncremental(char[] buf, int off, int len, NTextVisitor visitor) {
        if (len == 0) {
            return 0L;
        }
        this.offer(buf, off, len);
        return this.state().consumeNodes(false, visitor);
    }

    @Override
    public long parseRemaining(NTextVisitor visitor) {
        return this.state().consumeNodes(true, visitor);
    }

    @Override
    public boolean isIncomplete() {
        return this.state().isIncomplete();
    }

    public String toString() {
        return "NTextNodeParser{" + this.state() + "}";
    }

    @Override
    public NText read() {
        return this.state().consumeNode(null);
    }

    @Override
    public NText readFully() {
        return this.state().consumeNodeGreedy(null);
    }

    public class State {
        private Stack<ParserStep> statusStack = new Stack();
        private boolean lineMode = false;
        private boolean lineStart = true;

        public State() {
            this.statusStack.push(new RootParserStep(true));
        }

        public boolean isLineStart() {
            return this.lineStart;
        }

        public State setLineStart(boolean wasNewLine) {
            this.lineStart = wasNewLine;
            return this;
        }

        public boolean isSpreadLine() {
            return !this.lineStart;
        }

        public void applyPush(ParserStep r) {
            this._push(r);
        }

        private void onNewChar(char c) {
            ParserStep st = this.statusStack.peek();
            boolean wasNewLine = false;
            if (st instanceof RootParserStep) {
                wasNewLine = ((RootParserStep)st).isEmpty();
            }
            st.consume(c, this, wasNewLine);
        }

        public ParserStep applyDrop(ParserStep me) {
            return this._pop(me);
        }

        public NText consumeNodeGreedy(NTextVisitor visitor) {
            NText n = this.consumeNode(visitor);
            if (n != null) {
                return n;
            }
            this.forceEnding();
            return this.consumeNode(visitor);
        }

        public long consumeNodes(boolean greedy, NTextVisitor visitor) {
            long count = 0L;
            while (this.consumeNode(visitor) != null) {
                ++count;
            }
            if (greedy && this.forceEnding()) {
                while (this.consumeNode(visitor) != null) {
                    ++count;
                }
            }
            return count;
        }

        public synchronized ParserStep applyPop(ParserStep me) {
            if (this.statusStack.size() < 2) {
                System.err.println("problem");
            }
            ParserStep tt = this._pop(me);
            ParserStep parent = this.statusStack.peek();
            parent.appendChild(tt);
            return parent;
        }

        public void applyAppendSibling(ParserStep r) {
            int len = this.statusStack.size();
            ParserStep parent = (ParserStep)this.statusStack.elementAt(len - 2);
            parent.appendChild(r);
        }

        public void applyPopReplace(ParserStep me, ParserStep r) {
            this.applyPop(me);
            this._push(r);
        }

        public void applyDropReplacePreParsedPlain(ParserStep me, String text, boolean exitOnBrace) {
            this.applyDropReplace(me, new PlainParserStep(text, this.lineStart, false, DefaultNTextNodeParser.this.state, null, true, exitOnBrace));
        }

        public void applyDropReplace(ParserStep me, ParserStep r) {
            ParserStep tt = this._pop(me);
            this._push(r);
        }

        private void _push(ParserStep r) {
            if (this.statusStack.isEmpty()) {
                System.err.println("problem");
            } else if (this.statusStack.peek() instanceof PlainParserStep && r instanceof PlainParserStep) {
                System.err.println("problem");
            }
            this.statusStack.push(r);
        }

        private ParserStep _pop(ParserStep me) {
            ParserStep r;
            if (this.statusStack.size() < 2) {
                System.err.println("problem");
            }
            if (!Objects.equals(r = this.statusStack.peek(), me)) {
                System.err.println("problem");
            }
            return this.statusStack.pop();
        }

        public void applyNextChar(char c) {
            this.onNewChar(c);
        }

        public void applyPopReplay(ParserStep me, char rejected) {
            ParserStep tt = this.statusStack.peek();
            ParserStep p = this.applyPop(me);
            boolean wasNewLine = tt instanceof NewLineParserStep;
            p.consume(rejected, this, wasNewLine);
        }

        public void applyPush(String c, boolean spreadLines, boolean lineStart, boolean exitOnBrace) {
            if (c.length() > 0) {
                this.applyPush(c.charAt(0), spreadLines, lineStart, exitOnBrace);
                for (int i = 1; i < c.length(); ++i) {
                    this.onNewChar(c.charAt(i));
                }
            }
        }

        public void applyPush(char c, boolean spreadLines, boolean lineStart, boolean exitOnBrace) {
            switch (c) {
                case '`': {
                    this.applyPush(new AntiQuote3ParserStep(c, spreadLines, exitOnBrace));
                    break;
                }
                case '#': {
                    this.applyPush(new StyledParserStep(c, lineStart, DefaultNTextNodeParser.this.state(), exitOnBrace));
                    break;
                }
                case '\u001e': {
                    break;
                }
                case '\n': 
                case '\r': {
                    this.applyPush(new NewLineParserStep(c));
                    if (!this.lineMode) break;
                    this.forceEnding();
                    break;
                }
                default: {
                    State state = DefaultNTextNodeParser.this.state();
                    this.applyPush(new PlainParserStep(c, lineStart, state, null, exitOnBrace));
                }
            }
        }

        public boolean isIncomplete() {
            RootParserStep root = this.root();
            if (root == null) {
                return false;
            }
            if (root.isEmpty()) {
                return false;
            }
            ParserStep s = root.peek();
            if (s == null) {
                for (ParserStep parserStep : this.statusStack) {
                    if (parserStep.isComplete()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private RootParserStep root() {
            if (this.statusStack.isEmpty()) {
                return null;
            }
            return (RootParserStep)this.statusStack.get(0);
        }

        public int size() {
            RootParserStep root = this.root();
            return this.statusStack.size() + (root == null ? 0 : root.size());
        }

        public boolean isEmpty() {
            RootParserStep root = this.root();
            return this.statusStack.isEmpty() || root == null || root.isEmpty();
        }

        public NText consumeFDocNode() {
            RootParserStep root = this.root();
            if (root == null) {
                return null;
            }
            ParserStep s = root.poll();
            if (s == null) {
                return null;
            }
            return s.toText();
        }

        public NText consumeNode(NTextVisitor visitor) {
            RootParserStep root = this.root();
            if (root == null) {
                return null;
            }
            ParserStep s = root.poll();
            if (s == null) {
                ParserStep s2;
                while (!this.statusStack.isEmpty() && !((s2 = this.statusStack.peek()) instanceof RootParserStep)) {
                    if (s2 != null && s2.isComplete()) {
                        ParserStep tt = this._pop(s2);
                        ParserStep parent = this.statusStack.peek();
                        parent.appendChild(tt);
                        continue;
                    }
                    if (s2 != null) break;
                    ParserStep parserStep = this._pop(s2);
                }
                ParserStep parserStep = s = (root = this.root()) == null ? null : root.poll();
            }
            if (s == null) {
                return null;
            }
            NText n = s.toText();
            if (visitor != null) {
                visitor.visit(n);
            }
            return n;
        }

        public synchronized boolean forceEnding() {
            ParserStep s;
            boolean ok = false;
            while (!((s = this.statusStack.peek()) instanceof RootParserStep)) {
                if (s != null) {
                    s.end(this);
                }
                ok = true;
            }
            return ok;
        }

        public String toString() {
            return "State{" + (this.isIncomplete() ? "incomplete" : (this.isEmpty() ? "empty" : String.valueOf(this.size()))) + (this.lineMode ? ",lineMode" : "") + "," + this.statusStack + "}";
        }

        public synchronized void reset() {
            this.statusStack.clear();
            this.lineMode = false;
            this.lineStart = true;
            this.statusStack.push(new RootParserStep(true));
        }
    }
}

