/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;

public class NTextListSimplifier {
    private List<NText> values = new ArrayList<NText>();
    private boolean inlineLists = true;
    private boolean inlineBuilders = true;
    private boolean mergePlain = true;
    private boolean mergeStyled = true;

    public boolean isInlineLists() {
        return this.inlineLists;
    }

    public NTextListSimplifier setInlineLists(boolean inlineLists) {
        this.inlineLists = inlineLists;
        return this;
    }

    public boolean isInlineBuilders() {
        return this.inlineBuilders;
    }

    public NTextListSimplifier setInlineBuilders(boolean inlineBuilders) {
        this.inlineBuilders = inlineBuilders;
        return this;
    }

    public boolean isMergePlain() {
        return this.mergePlain;
    }

    public NTextListSimplifier setMergePlain(boolean mergePlain) {
        this.mergePlain = mergePlain;
        return this;
    }

    public boolean isMergeStyled() {
        return this.mergeStyled;
    }

    public NTextListSimplifier setMergeStyled(boolean mergeStyled) {
        this.mergeStyled = mergeStyled;
        return this;
    }

    public NTextListSimplifier addAll(NText[] a) {
        for (NText n : a) {
            this.add(n);
        }
        return this;
    }

    public NTextListSimplifier addAll(List<NText> a) {
        for (NText n : a) {
            this.add(n);
        }
        return this;
    }

    public NTextListSimplifier add(NText a) {
        if (a != null) {
            if (this.inlineLists && a instanceof NTextList) {
                for (NText child : ((NTextList)a).getChildren()) {
                    this.add(child.simplify());
                }
            } else if (this.inlineBuilders && a instanceof NTextBuilder) {
                for (NText child : ((NTextBuilder)a).getChildren()) {
                    this.add(child.simplify());
                }
            } else {
                NText last = null;
                if (!this.values.isEmpty()) {
                    last = this.values.get(this.values.size() - 1);
                }
                if (a instanceof NTextPlain) {
                    NTextPlain aa = (NTextPlain)a;
                    if (!((NTextPlain)a).getValue().isEmpty()) {
                        if (this.mergePlain && last instanceof NTextPlain) {
                            this.values.remove(this.values.size() - 1);
                            this.values.add(new DefaultNTextPlain(((NTextPlain)last).getValue() + aa.getValue()));
                        } else {
                            this.values.add(a);
                        }
                    }
                } else if (a instanceof NTextStyled) {
                    NTextStyled aa = (NTextStyled)a;
                    NTextStyles aas = aa.getStyles();
                    if (this.mergeStyled && last instanceof NTextStyled && Objects.equals(aa.getStyles(), ((NTextStyled)last).getStyles())) {
                        this.values.remove(this.values.size() - 1);
                        NText s = NText.ofList(((NTextStyled)last).getChild(), aa.getChild()).simplify();
                        if (!(s instanceof NTextPlain) || !((NTextPlain)s).getValue().isEmpty()) {
                            this.values.add(new DefaultNTextStyled(s, aas));
                        }
                    } else {
                        this.values.add(a);
                    }
                } else {
                    this.values.add(a);
                }
            }
        }
        return this;
    }

    public List<NText> toList() {
        return new ArrayList<NText>(this.values);
    }
}

