/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNText;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNTextPlain
extends AbstractNText
implements NTextPlain {
    public static final NTextPlain EMPTY = new DefaultNTextPlain("");
    private String text;

    public DefaultNTextPlain(String text) {
        this.text = text == null ? "" : text;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public NTextType type() {
        return NTextType.PLAIN;
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNTextPlain that = (DefaultNTextPlain)o;
        return Objects.equals(this.text, that.text);
    }

    @Override
    public NText immutable() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.text);
    }

    @Override
    public String filteredText() {
        return this.text == null ? "" : this.text;
    }

    @Override
    public int length() {
        return this.text == null ? 0 : this.text.length();
    }

    @Override
    public NText simplify() {
        if (this.equals(EMPTY)) {
            return EMPTY;
        }
        return this;
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        ArrayList<NPrimitiveText> all = new ArrayList<NPrimitiveText>();
        for (char c : this.text.toCharArray()) {
            all.add(new DefaultNTextPlain(String.valueOf(c)));
        }
        return all;
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return NStream.ofStream(this.text.codePoints().mapToObj(c -> new DefaultNTextPlain(new String(Character.toChars(c)))));
    }

    @Override
    public NText substring(int start, int end) {
        return new DefaultNTextPlain(this.getValue().substring(start, end));
    }

    @Override
    public List<NText> split(String separator, boolean returnSeparator) {
        StringTokenizer st = new StringTokenizer(this.getValue(), separator, returnSeparator);
        ArrayList<NText> all = new ArrayList<NText>();
        while (st.hasMoreElements()) {
            all.add(new DefaultNTextPlain(st.nextToken()));
        }
        return all;
    }

    @Override
    public boolean isWhitespace() {
        return !this.text.isEmpty() && this.text.trim().isEmpty();
    }

    @Override
    public NText trimLeft() {
        String c = NStringUtils.trimLeft(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextPlain(c);
    }

    @Override
    public NText trimRight() {
        String c = NStringUtils.trimRight(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextPlain(c);
    }

    @Override
    public NText trim() {
        String c = NStringUtils.trim(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextPlain(c);
    }
}

