/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.io.StringReader;
import java.util.ArrayList;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NEvictingQueue;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStreamTokenizer;
import net.thevpc.nuts.util.NStringUtils;

public class XmlCodeHighlighter
implements NCodeHighlighter {
    private final NWorkspace workspace;

    public XmlCodeHighlighter(NWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public String getId() {
        return "xml";
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "xml": 
            case "xsl": 
            case "application/xml": 
            case "text/xml": 
            case "text/html": 
            case "html": 
            case "sgml": {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public NText stringToText(String text, NTexts txt) {
        int s;
        NStreamTokenizer st = new NStreamTokenizer(new StringReader(text));
        st.xmlComments(true);
        st.parseNumbers(false);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        ArrayList<NText> nodes = new ArrayList<NText>();
        NEvictingQueue<String> last = new NEvictingQueue<String>(3);
        while ((s = st.nextToken()) != -1) {
            switch (s) {
                case -17: {
                    nodes.add(txt.ofPlain(st.image));
                    break;
                }
                case -16: {
                    nodes.add(txt.ofStyled(st.image, NTextStyle.comments()));
                    break;
                }
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: {
                    nodes.add(txt.ofStyled(st.image, NTextStyle.number()));
                    break;
                }
                case -3: {
                    if (last.size() > 0 && ((String)last.get(last.size() - 1)).equals("<")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("/")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("?")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    if (st.image.equals("true") || st.image.equals("false")) {
                        nodes.add(this.formatNodeName(st.image, txt));
                        break;
                    }
                    nodes.add(txt.ofPlain(st.image));
                    break;
                }
                case 39: {
                    nodes.add(this.formatNodeString(st.image, txt));
                    break;
                }
                case 34: {
                    nodes.add(this.formatNodeString(st.image, txt));
                    break;
                }
                case 38: 
                case 60: 
                case 61: 
                case 62: {
                    nodes.add(txt.ofStyled(st.image, NTextStyle.separator()));
                    break;
                }
                default: {
                    nodes.add(txt.ofStyled(st.image, NTextStyle.separator()));
                }
            }
            last.add(st.image == null ? "" : st.image);
        }
        return txt.ofList(nodes).simplify();
    }

    @Override
    public NText tokenToText(String text, String nodeType, NTexts txt) {
        switch (NStringUtils.trim(nodeType).toLowerCase()) {
            case "name": {
                return this.formatNodeName(text, txt);
            }
            case "attribute": {
                return this.formatNodeName(text, txt);
            }
            case "string": {
                return this.formatNodeString(text, txt);
            }
            case "<": 
            case "<?": 
            case "</": 
            case ">": 
            case "&": 
            case "=": 
            case "separator": {
                return this.formatNodeSeparator(text, txt);
            }
        }
        return txt.ofPlain(text);
    }

    public NText formatNodeName(String text, NTexts txt) {
        return txt.ofStyled(text, NTextStyle.keyword());
    }

    public NText formatNodeString(String text, NTexts txt) {
        return txt.ofStyled(text, NTextStyle.string());
    }

    public NText formatNodeSeparator(String text, NTexts txt) {
        return txt.ofStyled(text, NTextStyle.separator());
    }
}

