/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.runtime.standalone.text.highlighter.StringReaderExtUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NScorableContext;

public class TsonCodeHighlighter
implements NCodeHighlighter {
    @Override
    public String getId() {
        return "tson";
    }

    @Override
    public NText tokenToText(String text, String nodeType, NTexts txt) {
        return txt.ofPlain(text);
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "tson": 
            case "application/tson": 
            case "text/tson": {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public NText stringToText(String text, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        StringReaderExt ar = new StringReaderExt(text);
        block8: while (ar.hasNext()) {
            NText[] d;
            switch (ar.peekChar()) {
                case '(': 
                case ')': 
                case ':': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    all.addAll(Arrays.asList(this.parseRawString(txt, ar)));
                    continue block8;
                }
                case '\u00b6': {
                    all.addAll(Arrays.asList(this.parseOneLineString(txt, ar)));
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(TsonCodeHighlighter.readNumber(txt, ar)));
                    continue block8;
                }
                case '+': 
                case '-': 
                case '.': {
                    d = TsonCodeHighlighter.readNumber(txt, ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block8;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(ar)));
                        continue block8;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(ar)));
                        continue block8;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(ar)));
                continue;
            }
            d = this.readIdentifier(txt, ar);
            if (d != null) {
                if (d.length == 1 && d[0].type() == NTextType.PLAIN) {
                    String txt2 = ((NTextPlain)d[0]).getValue();
                    String s = ar.peekChars(10).replace("\n", " ");
                    String next = "";
                    if (s.matches(" *[(].*")) {
                        next = "(";
                    } else if (s.matches(" *[{].*")) {
                        next = "{";
                    } else if (s.matches(" *[\\[].*")) {
                        next = "[";
                    } else if (s.matches(" *[:].*")) {
                        next = ":";
                    }
                    NText last = all.isEmpty() ? null : (NText)all.get(all.size() - 1);
                    NTextStyles t = this.resolveTokenStyle(txt2, next, last);
                    if (t != null) {
                        d[0] = txt.ofStyled(d[0], t);
                    }
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
        }
        return txt.ofList(all.toArray(new NText[0]));
    }

    public static String readNumberStr(StringReaderExt ar) {
        ar.mark();
        StringBuilder sb = new StringBuilder();
        if (ar.readString("0u")) {
            sb.append("0u");
            char c = ar.readChar();
            int u = 1;
            switch (c) {
                case '1': 
                case '2': 
                case '4': 
                case '8': {
                    u = Integer.parseInt(String.valueOf(c));
                    sb.append(c);
                    break;
                }
                default: {
                    ar.reset();
                    ar.readChar();
                    return "0";
                }
            }
            c = ar.readChar();
            int radix = 10;
            switch (c) {
                case '_': {
                    sb.append(c);
                    sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '9' || cc == '_'));
                    break;
                }
                case 'x': {
                    radix = 16;
                    sb.append(c);
                    sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '9' || cc >= 'a' && cc <= 'f' || cc >= 'A' && cc <= 'F' || cc == '_'));
                    break;
                }
                case 'o': {
                    radix = 8;
                    sb.append(c);
                    sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '7' || cc == '_'));
                    break;
                }
                case 'b': {
                    radix = 2;
                    sb.append(c);
                    sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '1' || cc == '_'));
                    break;
                }
                default: {
                    if (ar.readString("Max")) {
                        sb.append("Max");
                        break;
                    }
                    if (ar.readString("Min")) {
                        sb.append("Min");
                        break;
                    }
                    if (ar.readString("Inf")) {
                        sb.append("Inf");
                        return sb.toString();
                    }
                    if (ar.readString("NaN")) {
                        sb.append("NaN");
                        break;
                    }
                    ar.reset();
                    ar.readChar();
                    return "0";
                }
            }
        } else if (ar.readString("0x")) {
            sb.append("0x");
            sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '9' || cc >= 'a' && cc <= 'f' || cc >= 'A' && cc <= 'F' || cc == '_'));
        } else if (ar.readString("0b")) {
            sb.append("0b");
            sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '1' || cc == '_'));
        } else if (ar.readString("0")) {
            sb.append("0");
            sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '7' || cc == '_'));
        } else {
            sb.append(ar.readWhile((cc, p) -> cc >= '0' && cc <= '9' || cc == '_' || cc == '-' || cc == '+' || cc == 'e' || cc == 'E' || cc == 'i' || cc == '^' || cc == '.'));
        }
        if (ar.readString("LL")) {
            sb.append("LL");
        } else if (ar.readString("L")) {
            sb.append("L");
        } else if (ar.readString("f")) {
            sb.append("f");
        } else if (ar.readString("F")) {
            sb.append("F");
        }
        if (ar.readString("%")) {
            sb.append("%");
            sb.append(ar.readWhile((cc, p) -> Character.isLetter(cc)));
        } else if (ar.readString("_")) {
            sb.append("_");
            sb.append(ar.readWhile((cc, p) -> Character.isLetter(cc)));
        } else if (sb.toString().matches(".*_[a-zA-Z]+")) {
            sb.append(ar.readWhile((cc, p) -> Character.isLetter(cc)));
        }
        return sb.toString();
    }

    public static NText[] readNumber(NTexts txt, StringReaderExt ar) {
        String s = TsonCodeHighlighter.readNumberStr(ar);
        if (s.length() > 0) {
            return new NText[]{txt.ofStyled(s, NTextStyle.number())};
        }
        return new NText[0];
    }

    protected NTextStyles resolveTokenStyle(String token, String next, NText last) {
        String s;
        if ("(".equals(next) || "{".equals(next)) {
            return NTextStyles.of(NTextStyle.primary1());
        }
        if (":".equals(next)) {
            return NTextStyles.of(NTextStyle.primary3());
        }
        if (last != null && (s = last.filteredText()).equals(":")) {
            return NTextStyles.of(NTextStyle.primary4());
        }
        switch (token) {
            case "true": 
            case "false": {
                return NTextStyles.of(NTextStyle.bool());
            }
        }
        return null;
    }

    protected boolean isIdentifierStart(char c) {
        switch (c) {
            case '$': {
                return true;
            }
        }
        return Character.isJavaIdentifierStart(c);
    }

    protected boolean isJavaIdentifierPart(char c) {
        switch (c) {
            case '$': 
            case '-': {
                return true;
            }
        }
        return Character.isJavaIdentifierPart(c);
    }

    private NText[] readIdentifier(NTexts txt, StringReaderExt ar) {
        ArrayList<NTextPlain> all = new ArrayList<NTextPlain>();
        StringBuilder sb = new StringBuilder();
        if (!ar.hasNext() || !this.isIdentifierStart(ar.peekChar())) {
            return null;
        }
        sb.append(ar.readChar());
        while (ar.hasNext()) {
            char c = ar.peekChar();
            if (c == '-') {
                String cc = ar.peekChars(2);
                if (cc.length() <= 1 || !this.isJavaIdentifierPart(cc.charAt(0))) break;
                sb.append(ar.readChar());
            }
            if (!this.isJavaIdentifierPart(c)) break;
            sb.append(ar.readChar());
        }
        all.add(txt.ofPlain(sb.toString()));
        return all.toArray(new NText[0]);
    }

    public NText[] parseOneLineString(NTexts txt, StringReaderExt chars) {
        ArrayList<NText> all = new ArrayList<NText>();
        StringBuilder sb = new StringBuilder();
        all.add(txt.ofStyled(String.valueOf(chars.readChar()), NTextStyle.string()));
        while (chars.hasNext()) {
            char c = chars.readChar();
            if (c == '\n') {
                if (sb.length() > 0) {
                    all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                    sb.setLength(0);
                }
                all.add(txt.ofPlain("\n"));
                return all.toArray(new NText[0]);
            }
            if (c == '\r') {
                if (sb.length() > 0) {
                    all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                    sb.setLength(0);
                }
                if (chars.hasNext()) {
                    char c2 = chars.peekChar();
                    if (c2 == '\n') {
                        chars.readChar();
                        all.add(txt.ofPlain("\r\n"));
                    } else {
                        all.add(txt.ofPlain("\r"));
                    }
                }
                return all.toArray(new NText[0]);
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
            sb.setLength(0);
        }
        return all.toArray(new NText[0]);
    }

    public NText[] parseRawString(NTexts txt, StringReaderExt chars) {
        ArrayList<NText> all = new ArrayList<NText>();
        for (String border : new String[]{"\"\"\"", "'''", "```", "\"", "'", "`"}) {
            if (!chars.readString(border)) continue;
            all.add(txt.ofStyled(border, NTextStyle.string()));
            StringBuilder sb = new StringBuilder();
            while (chars.hasNext()) {
                if (chars.readString("\\" + border)) {
                    if (sb.length() > 0) {
                        all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                        sb.setLength(0);
                    }
                    all.add(txt.ofStyled("\\" + border, NTextStyle.separator()));
                    continue;
                }
                if (chars.readString(border)) {
                    if (sb.length() > 0) {
                        all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                        sb.setLength(0);
                    }
                    all.add(txt.ofStyled(border, NTextStyle.string()));
                    break;
                }
                sb.append(chars.readChar());
            }
            if (sb.length() > 0) {
                all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                sb.setLength(0);
            }
            return all.toArray(new NText[0]);
        }
        return new NText[0];
    }
}

