/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultTableCellFormat;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultTableHeaderFormat;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegion;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegionImpl;
import net.thevpc.nuts.runtime.standalone.text.art.table.BorderInfos;
import net.thevpc.nuts.runtime.standalone.text.art.table.Borders;
import net.thevpc.nuts.runtime.standalone.text.art.table.Bounds;
import net.thevpc.nuts.runtime.standalone.text.art.table.DefaultCell;
import net.thevpc.nuts.runtime.standalone.text.art.table.NTableBordersFormatHelper;
import net.thevpc.nuts.runtime.standalone.text.art.table.TableColumn;
import net.thevpc.nuts.runtime.standalone.text.art.table.TableRow;
import net.thevpc.nuts.text.NTableBordersFormat;
import net.thevpc.nuts.text.NTableCellFormat;
import net.thevpc.nuts.text.NTableModel;
import net.thevpc.nuts.text.NTableSeparator;
import net.thevpc.nuts.text.NText;

class TableModelRenderHelper {
    TableRow[] tableRows;
    TableColumn[] tableColumns;
    private NTableModel model;
    List<Boolean> visibleColumns;
    boolean visibleHeader;
    int rows;
    int cols;
    private static final int NO_BORDER_TOP = 1;
    private static final int NO_BORDER_LEFT = 2;
    NTextRegion[][] grid;
    DefaultCell[][] gridc;
    int[][] noBorder;
    NTableBordersFormatHelper borderHelper;
    private NTableCellFormat defaultCellFormatter = DefaultTableCellFormat.INSTANCE;
    private NTableCellFormat defaultHeaderFormatter = DefaultTableHeaderFormat.INSTANCE;

    public TableModelRenderHelper(NTableModel model) {
        this.model = model;
    }

    public void prepare(List<Boolean> visibleColumns, boolean visibleHeader, NTableCellFormat defaultCellFormatter, NTableCellFormat defaultHeaderFormatter) {
        this.visibleHeader = visibleHeader;
        this.visibleColumns = visibleColumns;
        this.defaultCellFormatter = defaultCellFormatter;
        this.defaultHeaderFormatter = defaultHeaderFormatter;
        this.rebuild(this.model);
        if (this.tableRows.length == 0) {
            return;
        }
        this.computeColumns();
        for (TableRow row : this.tableRows) {
            for (DefaultCell cell : row.cells) {
                cell.renderedContent = cell.renderedContent.resize(this.charWidth(cell.x, cell.x + cell.colspan), this.charHeight(cell.y, cell.y + cell.rowspan), cell.hAlign, cell.vAlign);
            }
        }
        this.computeStartRowIndex();
    }

    public int charWidth(int fromColumn, int toColumnExcluded) {
        int w = 0;
        for (int i = fromColumn; i < toColumnExcluded; ++i) {
            w += this.tableColumns[i].charWidth;
        }
        return w;
    }

    public int charHeight(int fromRow, int toRowExcluded) {
        int h = 0;
        for (int i = fromRow; i < toRowExcluded; ++i) {
            h += this.tableRows[i].charHeight;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.tableRows.length == 0;
    }

    private void rebuild(NTableModel model) {
        DefaultCell c;
        int columnIndex2;
        ArrayList<TableRow> rows1 = new ArrayList<TableRow>();
        int columnsCount = model.getColumnsCount();
        int rowsCount = model.getRowsCount();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            TableRow r = new TableRow();
            r.index = rowIndex;
            rows1.add(r);
            for (columnIndex2 = 0; columnIndex2 < columnsCount; ++columnIndex2) {
                c = new DefaultCell(false);
                try {
                    c.content = model.getCellValue(rowIndex, columnIndex2);
                    c.colspan = model.getCellColSpan(rowIndex, columnIndex2);
                    c.rowspan = model.getCellRowSpan(rowIndex, columnIndex2);
                    r.cells.add(c);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ArrayList<TableRow> effectiveRows = new ArrayList<TableRow>();
        TableRow header = new TableRow();
        try {
            for (columnIndex2 = 0; columnIndex2 < columnsCount; ++columnIndex2) {
                c = new DefaultCell(true);
                try {
                    c.content = model.getHeaderValue(columnIndex2);
                    header.cells.add(c);
                    c.colspan = model.getHeaderColSpan(columnIndex2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (NoSuchElementException columnIndex2) {
            // empty catch block
        }
        if (header.cells.size() > 0 && this.visibleHeader) {
            effectiveRows.add(header);
        }
        boolean p = this.isVisibleColumnPositive();
        boolean n = this.isVisibleColumnNegative();
        for (int i = 0; i < rows1.size(); ++i) {
            TableRow row = (TableRow)rows1.get(i);
            TableRow r2 = new TableRow();
            List<DefaultCell> cells = row.cells;
            for (int i1 = 0; i1 < cells.size(); ++i1) {
                DefaultCell cell = cells.get(i1);
                if (!this.isVisibleColumn(i1, p, n)) continue;
                r2.cells.add(cell);
            }
            if (r2.cells.size() <= 0) continue;
            effectiveRows.add(r2);
        }
        TableRow[] effectiveRows0 = effectiveRows.toArray(new TableRow[0]);
        for (int j = 0; j < effectiveRows0.length; ++j) {
            TableRow tableRow = effectiveRows0[j];
            tableRow.index = j;
            for (DefaultCell cell : tableRow.cells) {
                if (cell.rowspan <= 1) continue;
                for (int i = 1; i < cell.rowspan; ++i) {
                    if (j + i < effectiveRows.size()) continue;
                    effectiveRows.add(new TableRow());
                }
            }
        }
        Bounds b = new Bounds();
        Bounds cb = new Bounds();
        int r = 0;
        int cr = 0;
        for (TableRow row : effectiveRows) {
            row.index = r;
            int c2 = 0;
            int cc = 0;
            b.setRowIntervalMinSize(r, r, 0);
            for (DefaultCell cell : row.cells) {
                int r0 = r;
                int c0 = c2;
                int cr0 = cr;
                int cc0 = cc;
                while (b.isReserved(c0, r0)) {
                    ++c0;
                }
                while (cb.isReserved(cc0, cr0)) {
                    ++cc0;
                }
                cell.x = c0;
                cell.y = r0;
                NTableCellFormat formatter = this.getTableCellFormat(cell);
                NText cvalue = cell.getContent();
                cell.vAlign = formatter.getVerticalAlign(r0, c0, cvalue);
                cell.hAlign = formatter.getHorizontalAlign(r0, c0, cvalue);
                cell.setRenderedContent(new NTextRegionImpl(formatter.format(r0, c0, cvalue)));
                b.setColumnIntervalMinSize(cell.x, cell.x + cell.colspan, cell.getRenderedContent().columns());
                b.setRowIntervalMinSize(cell.y, cell.y + cell.rowspan, cell.getRenderedContent().rows());
                for (int i = 0; i < cell.rowspan; ++i) {
                    for (int j = 0; j < cell.colspan; ++j) {
                        b.addReservation(c0 + j, r0 + i);
                    }
                }
                ++c2;
            }
            b.discardRow(r);
            ++r;
        }
        for (int k = 0; k < effectiveRows.size(); ++k) {
            TableRow row = (TableRow)effectiveRows.get(k);
            List<DefaultCell> cells = row.cells;
            for (int j = 0; j < cells.size(); ++j) {
                DefaultCell cell = cells.get(j);
                int e = (int)Math.ceil((double)cell.renderedContent.rows() * 1.0 / (double)Math.max(1, cell.rowspan));
                for (int i = 0; i < cell.rowspan; ++i) {
                    TableRow rr = (TableRow)effectiveRows.get(k + i);
                    rr.charHeight = Math.max(rr.charHeight, e);
                }
            }
        }
        this.tableRows = effectiveRows.toArray(new TableRow[0]);
    }

    private NTableCellFormat getTableCellFormat(DefaultCell dc) {
        return dc.isHeader() ? this.defaultHeaderFormatter : this.defaultCellFormatter;
    }

    private boolean isVisibleColumn(int col, boolean p, boolean n) {
        Boolean b = null;
        if (col >= 0 && col < this.visibleColumns.size()) {
            b = this.visibleColumns.get(col);
        }
        if (b == null) {
            if (!p && !n) {
                return true;
            }
            if (p && !n) {
                return false;
            }
            if (!p && n) {
                return true;
            }
            return !p || !n;
        }
        return true;
    }

    private boolean isVisibleColumnPositive() {
        for (Boolean visibleColumn : this.visibleColumns) {
            if (visibleColumn == null || !visibleColumn.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isVisibleColumnNegative() {
        for (Boolean visibleColumn : this.visibleColumns) {
            if (visibleColumn == null || visibleColumn.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void computeColumns() {
        int totalTableColumns = 0;
        for (TableRow row : this.tableRows) {
            for (DefaultCell cell : row.cells) {
                totalTableColumns = Math.max(totalTableColumns, cell.x + Math.max(1, cell.colspan));
            }
        }
        this.tableColumns = new TableColumn[totalTableColumns];
        for (int i = 0; i < totalTableColumns; ++i) {
            this.tableColumns[i] = new TableColumn();
            this.tableColumns[i].index = i;
        }
        for (TableRow row : this.tableRows) {
            for (DefaultCell cell : row.cells) {
                int e = (int)Math.ceil((double)cell.renderedContent.columns() * 1.0 / (double)Math.max(1, cell.colspan));
                for (int i = 0; i < cell.colspan; ++i) {
                    this.tableColumns[cell.x + i].charWidth = Math.max(this.tableColumns[cell.x + i].charWidth, e);
                }
            }
        }
    }

    private void computeStartRowIndex() {
        int r = 0;
        while (r < this.tableRows.length) {
            TableRow row = this.tableRows[r];
            row.index = r++;
        }
    }

    public void dump() {
        this.dump(System.out, "");
    }

    public void dump(PrintStream out, String prefix) {
        out.println(prefix + "tableColumns x tableRows = " + this.tableColumns.length + " x " + this.tableRows.length);
        out.println(prefix + "tableColumns  = ");
        for (TableColumn td : this.tableColumns) {
            td.dump(out, "   ");
        }
        out.println(prefix + "tableRows  = ");
        for (TableRow tr : this.tableRows) {
            tr.dump(out, "   ");
        }
        out.println(prefix + "tableCells  = ");
        for (DefaultCell cell : this.allCells()) {
            cell.dump(out, "   ");
        }
    }

    public DefaultCell[] allCells() {
        ArrayList<DefaultCell> list = new ArrayList<DefaultCell>();
        for (TableRow tr : this.tableRows) {
            for (DefaultCell cell : tr.cells) {
                list.add(cell);
            }
        }
        return list.toArray(new DefaultCell[0]);
    }

    public NTextRegion renderTable(NTableBordersFormat border) {
        this.borderHelper = new NTableBordersFormatHelper(border);
        this.rows = this.tableRows.length;
        this.cols = this.tableColumns.length;
        this.grid = new NTextRegion[this.rows][this.cols];
        this.gridc = new DefaultCell[this.rows][this.cols];
        this.noBorder = new int[this.rows][this.cols];
        for (DefaultCell cell : this.allCells()) {
            int w = 0;
            for (int i = 0; i < cell.colspan; ++i) {
                int xx = cell.x + i;
                w += this.tableColumns[xx].charWidth;
                if (i <= 0) continue;
                int[] nArray = this.noBorder[cell.y];
                int n = xx;
                nArray[n] = nArray[n] | 2;
            }
            int h = 0;
            for (int i = 0; i < cell.rowspan; ++i) {
                int yy = cell.y + i;
                h += this.tableRows[yy].charHeight;
                if (i <= 0) continue;
                int[] nArray = this.noBorder[yy];
                int n = cell.x;
                nArray[n] = nArray[n] | 1;
            }
            NTextRegion contentRegion = cell.renderedContent;
            this.grid[cell.y][cell.x] = contentRegion = contentRegion.resize(Math.max(w, contentRegion.columns()), Math.max(h, contentRegion.rows()), cell.hAlign, cell.vAlign);
            this.gridc[cell.y][cell.x] = cell;
        }
        for (int r = 0; r < this.grid.length; ++r) {
            for (int c = 0; c < this.grid[r].length; ++c) {
                NTextRegion contentRegion = this.grid[r][c];
                if (contentRegion != null) {
                    NTextRegion contentRegion2;
                    NTextRegion sr2;
                    NTextRegion sr1;
                    if (contentRegion.rows() > this.tableRows[r].charHeight && r + 1 < this.grid.length) {
                        sr1 = contentRegion.subRegion(0, 0, contentRegion.columns(), this.tableRows[r].charHeight);
                        sr2 = contentRegion.subRegion(0, this.tableRows[r].charHeight, contentRegion.columns(), contentRegion.rows());
                        contentRegion2 = this.grid[r + 1][c];
                        this.grid[r + 1][c] = contentRegion2 == null ? sr2 : sr2.concatVertically(contentRegion2);
                        this.grid[r][c] = sr1;
                    }
                    if (contentRegion.columns() <= this.tableColumns[c].charWidth || c + 1 >= this.grid[r].length) continue;
                    sr1 = contentRegion.subRegion(0, 0, this.tableColumns[c].charWidth, contentRegion.rows());
                    sr2 = contentRegion.subRegion(this.tableColumns[c].charWidth, 0, contentRegion.columns(), contentRegion.rows());
                    contentRegion2 = this.grid[r][c + 1];
                    this.grid[r][c + 1] = contentRegion2 == null ? sr2 : sr2.concatHorizontally(contentRegion2);
                    this.grid[r][c] = sr1;
                    continue;
                }
                this.grid[r][c] = NTextRegion.ofWhitespace(this.tableColumns[c].charWidth, this.tableRows[r].charHeight);
            }
        }
        NTextRegion[][] gridWithBorder = new NTextRegion[this.rows][this.cols];
        for (int r = 0; r < this.grid.length; ++r) {
            for (int c = 0; c < this.grid[r].length; ++c) {
                NTextRegion contentRegion;
                gridWithBorder[r][c] = contentRegion = this.applyBorder(c, r);
            }
        }
        NTextRegion table = null;
        for (int r = 0; r < this.rows; ++r) {
            NTextRegion rowRegion = null;
            for (int c = 0; c < this.cols; ++c) {
                rowRegion = rowRegion == null ? gridWithBorder[r][c] : rowRegion.concatHorizontally(gridWithBorder[r][c]);
            }
            table = table == null ? rowRegion : table.concatVertically(rowRegion);
        }
        return table.ensureColumns();
    }

    private NTextRegion applyBorder(int c, int r) {
        NTextRegion contentRegion = this.grid[r][c];
        Borders b = this.createBorders(c, r);
        NTextRegion rc = null;
        if (!this.isTopBorder(c, r) && !this.isLeftBorder(c, r)) {
            contentRegion = contentRegion.concatVertically(NTextRegion.ofWhitespace(contentRegion.columns(), b.startHorizontalBorderSize));
            contentRegion = contentRegion.concatHorizontally(NTextRegion.ofWhitespace(b.startVerticalBorderSize, contentRegion.rows()));
            if (b.middleRight != null) {
                contentRegion = contentRegion.concatHorizontally(b.middleRight);
            }
            if (b.bottomCenter != null) {
                if (b.bottomRight != null) {
                    rc = rc == null ? b.bottomRight : rc.concatHorizontally(b.bottomRight);
                }
                contentRegion = contentRegion.concatVertically(rc);
            }
        } else if (!this.isTopBorder(c, r)) {
            contentRegion = contentRegion.concatVertically(NTextRegion.ofWhitespace(contentRegion.columns(), b.startHorizontalBorderSize));
            if (b.middleLeft != null) {
                contentRegion = b.middleLeft.concatHorizontally(contentRegion);
            }
            if (b.middleRight != null) {
                contentRegion = contentRegion.concatHorizontally(b.middleRight);
            }
            if (rc != null) {
                contentRegion = rc.concatVertically(contentRegion);
            }
            if (b.bottomCenter != null) {
                if (b.bottomLeft != null) {
                    rc = b.bottomLeft.concatHorizontally(b.bottomCenter);
                }
                if (b.bottomRight != null) {
                    rc = rc == null ? b.bottomRight : rc.concatHorizontally(b.bottomRight);
                }
                contentRegion = contentRegion.concatVertically(rc);
            }
        } else if (!this.isLeftBorder(c, r)) {
            contentRegion = contentRegion.concatHorizontally(NTextRegion.ofWhitespace(b.startVerticalBorderSize, contentRegion.rows()));
            if (b.topCenter != null) {
                rc = rc == null ? b.topCenter : rc.concatHorizontally(b.topCenter);
                if (b.topRight != null) {
                    rc = rc.concatHorizontally(b.topRight);
                }
            }
            if (b.middleRight != null) {
                contentRegion = contentRegion.concatHorizontally(b.middleRight);
            }
            if (rc != null) {
                contentRegion = rc.concatVertically(contentRegion);
            }
            if (b.bottomCenter != null) {
                if (b.bottomLeft != null) {
                    rc = b.bottomLeft.concatHorizontally(b.bottomCenter);
                }
                if (b.bottomRight != null) {
                    rc = rc == null ? b.bottomRight : rc.concatHorizontally(b.bottomRight);
                }
                contentRegion = contentRegion.concatVertically(rc);
            }
        } else {
            if (b.topCenter != null) {
                if (b.topLeft != null) {
                    rc = b.topLeft.concatHorizontally(b.topCenter);
                }
                if (b.topRight != null) {
                    rc = rc == null ? b.topRight : rc.concatHorizontally(b.topRight);
                }
            }
            if (b.middleLeft != null) {
                contentRegion = b.middleLeft.concatHorizontally(contentRegion);
            }
            if (b.middleRight != null) {
                contentRegion = contentRegion.concatHorizontally(b.middleRight);
            }
            if (rc != null) {
                contentRegion = rc.concatVertically(contentRegion);
            }
            if (b.bottomCenter != null) {
                if (b.bottomLeft != null) {
                    rc = b.bottomLeft.concatHorizontally(b.bottomCenter);
                }
                if (b.bottomRight != null) {
                    rc = rc == null ? b.bottomRight : rc.concatHorizontally(b.bottomRight);
                }
                contentRegion = contentRegion.concatVertically(rc);
            }
        }
        return contentRegion;
    }

    private Borders createBorders(int c, int r) {
        Borders b = new Borders();
        b.startVerticalBorderSize = this.borderHelper.getStartVerticalBorderSize();
        b.startHorizontalBorderSize = this.borderHelper.getStartHorizontalBorderSize();
        int cColumns = this.tableColumns[c].charWidth;
        int cRows = this.tableRows[r].charHeight;
        BorderInfos bi = new BorderInfos();
        bi.lastRow = r == this.rows - 1;
        bi.lastColumn = c == this.cols - 1;
        bi.firstRow = r == 0;
        bi.firstColumn = c == 0;
        bi.previousColumnHasTopBorder = c > 0 && this.isTopBorder(c - 1, r);
        bi.previousRowHasLeftBorder = r > 0 && this.isLeftBorder(c, r - 1);
        bi.previousRowIsSpanned = r > 0 && this.gridc[r - 1][c] == null;
        bi.hasTopBorder = this.isTopBorder(c, r);
        bi.hasLeftBorder = this.isLeftBorder(c, r);
        if (bi.hasTopBorder) {
            b.topCenter = this.borderHelper.line(NTableSeparator.FIRST_ROW_LINE, cColumns + (bi.hasLeftBorder ? 0 : b.startVerticalBorderSize));
        }
        if (bi.hasLeftBorder) {
            b.middleLeft = this.borderHelper.column(NTableSeparator.ROW_START, cRows + (bi.hasTopBorder ? 0 : b.startHorizontalBorderSize));
        }
        if (bi.lastColumn) {
            b.middleRight = this.borderHelper.column(NTableSeparator.ROW_END, cRows);
        }
        if (bi.lastRow) {
            b.bottomCenter = this.borderHelper.line(NTableSeparator.LAST_ROW_LINE, cColumns);
        }
        b.topLeft = this.createTopLeftBorderCorner(bi);
        b.bottomLeft = this.createBottomLeftBorderCorner(bi);
        b.topRight = this.createTopRightBorderCorner(bi);
        b.bottomRight = this.createBottomRightBorderCorner(bi);
        return b;
    }

    private NTextRegion createBottomRightBorderCorner(BorderInfos bi) {
        if (bi.lastRow && bi.lastColumn) {
            return this.borderHelper.get(NTableSeparator.LAST_ROW_END);
        }
        return null;
    }

    private NTextRegion createTopRightBorderCorner(BorderInfos bi) {
        if (bi.hasTopBorder && bi.lastColumn) {
            if (bi.firstRow) {
                return this.borderHelper.get(NTableSeparator.FIRST_ROW_END);
            }
            return this.borderHelper.get(NTableSeparator.MIDDLE_ROW_END);
        }
        return null;
    }

    private NTextRegion createBottomLeftBorderCorner(BorderInfos bi) {
        if (bi.lastRow && bi.hasLeftBorder) {
            if (bi.firstColumn) {
                return this.borderHelper.get(NTableSeparator.LAST_ROW_START);
            }
            return this.borderHelper.get(NTableSeparator.LAST_ROW_SEP);
        }
        return null;
    }

    private NTextRegion createTopLeftBorderCorner(BorderInfos bi) {
        if (bi.hasTopBorder && bi.hasLeftBorder) {
            if (bi.firstRow && bi.firstColumn) {
                return this.borderHelper.get(NTableSeparator.FIRST_ROW_START);
            }
            if (bi.firstColumn) {
                if (!bi.previousRowHasLeftBorder) {
                    return this.borderHelper.get(NTableSeparator.FIRST_ROW_SEP);
                }
                return this.borderHelper.get(NTableSeparator.MIDDLE_ROW_START);
            }
            if (bi.firstRow) {
                return this.borderHelper.get(NTableSeparator.FIRST_ROW_SEP);
            }
            if (!bi.previousColumnHasTopBorder) {
                return this.borderHelper.get(NTableSeparator.MIDDLE_ROW_START);
            }
            if (bi.previousRowIsSpanned) {
                return this.borderHelper.get(NTableSeparator.FIRST_ROW_SEP);
            }
            return this.borderHelper.get(NTableSeparator.MIDDLE_ROW_SEP);
        }
        return null;
    }

    private boolean isLeftBorder(int c, int r) {
        return (this.noBorder[r][c] & 2) == 0;
    }

    private boolean isTopBorder(int c, int r) {
        return (this.noBorder[r][c] & 1) == 0;
    }
}

