/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegion;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegionImpl;
import net.thevpc.nuts.text.NTableBordersFormat;
import net.thevpc.nuts.text.NTableSeparator;

public class NTableBordersFormatHelper {
    private NTableBordersFormat base;
    private NTextRegion[] all;
    private int startHorizontalBorderSize;
    private int startVerticalBorderSize;

    public NTableBordersFormatHelper(NTableBordersFormat base) {
        NTextRegionImpl r;
        NTableSeparator value;
        int i;
        this.base = base;
        NTableSeparator[] values = NTableSeparator.values();
        this.all = new NTextRegion[values.length];
        block8: for (i = 0; i < values.length; ++i) {
            value = values[i];
            r = new NTextRegionImpl(base.format(value));
            this.all[i] = r;
            switch (value) {
                case FIRST_ROW_LINE: 
                case MIDDLE_ROW_LINE: 
                case LAST_ROW_LINE: {
                    this.startVerticalBorderSize = Math.max(1, r.rows());
                    continue block8;
                }
                case ROW_START: 
                case ROW_SEP: 
                case ROW_END: {
                    this.startHorizontalBorderSize = Math.max(1, r.columns());
                    continue block8;
                }
                default: {
                    this.startHorizontalBorderSize = Math.max(1, r.columns());
                    this.startVerticalBorderSize = Math.max(1, r.rows());
                }
            }
        }
        block9: for (i = 0; i < values.length; ++i) {
            value = values[i];
            r = new NTextRegionImpl(base.format(value));
            this.all[i] = r;
            switch (value) {
                case FIRST_ROW_LINE: 
                case MIDDLE_ROW_LINE: 
                case LAST_ROW_LINE: {
                    this.startVerticalBorderSize = Math.max(1, r.rows());
                    continue block9;
                }
                case ROW_START: 
                case ROW_SEP: 
                case ROW_END: {
                    this.startHorizontalBorderSize = Math.max(1, r.columns());
                    continue block9;
                }
                default: {
                    this.startHorizontalBorderSize = Math.max(1, r.columns());
                    this.startVerticalBorderSize = Math.max(1, r.rows());
                }
            }
        }
    }

    public NTextRegion get(NTableSeparator separator) {
        return this.all[separator.ordinal()];
    }

    public NTextRegion line(NTableSeparator separator, int count) {
        NTextRegion r = this.all[separator.ordinal()];
        if (r.columns() > count) {
            return r.subRegion(0, 0, count, r.rows());
        }
        for (int i = 1; i < count; ++i) {
            if ((r = r.concatHorizontally(r)).columns() <= count) continue;
            return r.subRegion(0, 0, count, r.rows());
        }
        return r;
    }

    public NTextRegion column(NTableSeparator separator, int count) {
        NTextRegion r = this.all[separator.ordinal()];
        if (r.rows() > count) {
            return r.subRegion(0, 0, r.columns(), count);
        }
        for (int i = 1; i < count; ++i) {
            if ((r = r.concatVertically(r)).rows() <= count) continue;
            return r.subRegion(0, 0, r.columns(), count);
        }
        return r;
    }

    public int getStartHorizontalBorderSize() {
        return this.startHorizontalBorderSize;
    }

    public int getStartVerticalBorderSize() {
        return this.startVerticalBorderSize;
    }
}

