/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultTableCellFormat;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultTableFormatBorders;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultTableHeaderFormat;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegion;
import net.thevpc.nuts.runtime.standalone.text.art.table.TableModelRenderHelper;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTableBordersFormat;
import net.thevpc.nuts.text.NTableCellFormat;
import net.thevpc.nuts.text.NTableModel;
import net.thevpc.nuts.text.NTableSeparator;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArtTableRenderer;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNTextArtTableRenderer
implements NTextArtTableRenderer,
NTextArtTextRenderer {
    private final List<Boolean> visibleColumns = new ArrayList<Boolean>();
    private boolean visibleHeader = true;
    private NTableCellFormat defaultCellFormatter = DefaultTableCellFormat.INSTANCE;
    private NTableCellFormat defaultHeaderFormatter = DefaultTableHeaderFormat.INSTANCE;
    public static DefaultTableFormatBorders NO_BORDER = new DefaultTableFormatBorders("none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
    public static DefaultTableFormatBorders UNICODE_BORDER = new DefaultTableFormatBorders("unicode", "\u256d", "\u2500", "\u252c", "\u256e", "\u2502", "\u2502", "\u2502", "\u251c", "\u2500", "\u253c", "\u2524", "\u2570", "\u2500", "\u2534", "\u256f");
    public static DefaultTableFormatBorders SIMPLE_BORDER = new DefaultTableFormatBorders("simple", "-", "-", "-", "-", "|", "|", "|", "|", "-", "+", "|", "-", "-", "-", "-");
    public static DefaultTableFormatBorders FANCY_ROWS_BORDER = new DefaultTableFormatBorders("rows", "", "", "", "", "", " ", "", "", "\u2500", "\u2500", "", "", "", "", "");
    public static DefaultTableFormatBorders SPACE_BORDER = new DefaultTableFormatBorders("spaces", "", "", "", "", "", " ", "", "", "", "", "", "", "", "", "");
    public static DefaultTableFormatBorders FANCY_COLUMNS_BORDER = new DefaultTableFormatBorders("columns", "", "", "", "", "", " \u2502 ", "", "", "", "", "", "", "", "", "");
    private static Map<String, NTableBordersFormat> AVAILABLE = new HashMap<String, NTableBordersFormat>();
    private NTableBordersFormat border = CorePlatformUtils.SUPPORTS_UTF_ENCODING ? UNICODE_BORDER : SIMPLE_BORDER;

    public static Set<String> getAvailableTableBorders() {
        return new HashSet<String>(Arrays.asList("default", "spaces", "simple", "columns", "rows", "none", "unicode"));
    }

    public static NTableBordersFormat parseTableBorders(String borderName) {
        switch (borderName) {
            case "default": {
                return CorePlatformUtils.SUPPORTS_UTF_ENCODING ? UNICODE_BORDER : SIMPLE_BORDER;
            }
        }
        return AVAILABLE.get(borderName);
    }

    public NTableBordersFormat getBorder() {
        return this.border;
    }

    public DefaultNTextArtTableRenderer setBorder(NTableBordersFormat border) {
        this.border = border;
        return this;
    }

    public DefaultNTextArtTableRenderer setBorder(String borderName) {
        NTableBordersFormat n = DefaultNTextArtTableRenderer.parseTableBorders(borderName);
        if (n == null) {
            throw new NIllegalArgumentException(NMsg.ofC("unsupported border '%s'. use one of : %s", borderName, DefaultNTextArtTableRenderer.getAvailableTableBorders()));
        }
        this.setBorder(n);
        return this;
    }

    public NText getSeparators(NTableSeparator ... id) {
        NTextBuilder b = NTextBuilder.of();
        for (NTableSeparator nText : id) {
            b.append(this.getSeparator(nText));
        }
        return b.build();
    }

    public NText getSeparator(NTableSeparator id) {
        NText s = this.border.format(id);
        if (s == null) {
            return NText.ofBlank();
        }
        return s;
    }

    @Override
    public String getName() {
        DefaultTableFormatBorders b = (DefaultTableFormatBorders)this.border;
        return b == null ? "none" : b.getName();
    }

    @Override
    public NText render(NText model) {
        return this.render(NTableModel.of().addRow(model));
    }

    @Override
    public NText render(NTableModel model) {
        NTextBuilder out = NTextBuilder.of();
        TableModelRenderHelper ctx = new TableModelRenderHelper(model);
        ctx.prepare(this.visibleColumns, this.visibleHeader, this.defaultHeaderFormatter, this.defaultHeaderFormatter);
        if (ctx.isEmpty()) {
            return NText.of("");
        }
        NTextRegion nTextRegion = ctx.renderTable(this.border);
        out.append(nTextRegion.toText());
        return out.build();
    }

    public DefaultNTextArtTableRenderer setVisibleColumn(int col, Boolean visible) {
        if (visible == null) {
            if (col >= 0 && col < this.visibleColumns.size()) {
                this.visibleColumns.set(col, null);
            }
        } else if (col >= 0) {
            while (col < this.visibleColumns.size()) {
                this.visibleColumns.add(null);
            }
            this.visibleColumns.set(col, visible);
        }
        return this;
    }

    public Boolean getVisibleColumn(int col) {
        if (col >= 0 && col < this.visibleColumns.size()) {
            return this.visibleColumns.get(col);
        }
        return null;
    }

    public boolean isVisibleHeader() {
        return this.visibleHeader;
    }

    public DefaultNTextArtTableRenderer setVisibleHeader(boolean visibleHeader) {
        this.visibleHeader = visibleHeader;
        return this;
    }

    public DefaultNTextArtTableRenderer setHeaderFormat(NTableCellFormat formatter) {
        this.defaultHeaderFormatter = formatter == null ? DefaultTableHeaderFormat.INSTANCE : formatter;
        return this;
    }

    public DefaultNTextArtTableRenderer setCellFormat(NTableCellFormat formatter) {
        this.defaultCellFormatter = formatter == null ? DefaultTableCellFormat.INSTANCE : formatter;
        return this;
    }

    public String toString() {
        return "DefaultNTextArtTableRenderer(" + this.getName() + ")";
    }

    static {
        AVAILABLE.put(NO_BORDER.getName(), NO_BORDER);
        AVAILABLE.put(UNICODE_BORDER.getName(), UNICODE_BORDER);
        AVAILABLE.put(SIMPLE_BORDER.getName(), SIMPLE_BORDER);
        AVAILABLE.put(FANCY_ROWS_BORDER.getName(), FANCY_ROWS_BORDER);
        AVAILABLE.put(SPACE_BORDER.getName(), SPACE_BORDER);
        AVAILABLE.put(FANCY_COLUMNS_BORDER.getName(), FANCY_COLUMNS_BORDER);
    }

    private static class CellRender {
        NText text;
        int span;

        private CellRender() {
        }
    }
}

