/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import java.io.PrintStream;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegion;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NTableCell;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultCell
implements NTableCell {
    int colspan = 1;
    int rowspan = 1;
    int x;
    int y;
    NPositionType vAlign;
    NPositionType hAlign;
    NText content;
    NTextRegion renderedContent;
    boolean header;

    public DefaultCell(boolean header) {
        this.header = header;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public NTextRegion getRenderedContent() {
        return this.renderedContent;
    }

    public void setRenderedContent(NTextRegion renderedContent) {
        this.renderedContent = renderedContent;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public DefaultCell setColspan(int colspan) {
        this.colspan = colspan <= 0 ? 1 : colspan;
        return this;
    }

    @Override
    public int getRowspan() {
        return this.rowspan;
    }

    @Override
    public DefaultCell setRowspan(int rowspan) {
        this.rowspan = rowspan <= 0 ? 1 : rowspan;
        return this;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public NText getContent() {
        return this.content;
    }

    @Override
    public DefaultCell setContent(NText content) {
        this.content = content;
        return this;
    }

    public String toString() {
        return "Cell{" + this.x + "->" + (this.x + this.colspan) + ", " + this.y + "->" + (this.y + this.rowspan) + ", " + this.content + '}';
    }

    public void dump(PrintStream out, String prefix) {
        out.println(prefix + "x,y  = " + this.x + "," + this.y);
        out.println(prefix + "  colspan,rowspan  = " + this.colspan + "," + this.rowspan);
        out.println(prefix + "  charColumns x charLines = " + this.renderedContent.columns() + " x " + this.renderedContent.rows());
        out.println(prefix + "  svalue  = " + NStringUtils.formatStringLiteral(this.content.filteredText()));
    }
}

