/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.figlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.stream.Stream;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.text.art.NTextArtImpl;
import net.thevpc.nuts.runtime.standalone.text.art.figlet.FigletNTextArtTextRenderer;
import net.thevpc.nuts.text.NTextArtRenderer;
import net.thevpc.nuts.text.NTextArtRendererFactory;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class FigletNTextArtRendererFactory
implements NTextArtRendererFactory {
    String rendererType = "figlet";

    @Override
    public NOptional<NTextArtRenderer> load(NInputSource path) {
        try {
            return NOptional.of(new FigletNTextArtTextRenderer(path));
        }
        catch (Exception e) {
            return NOptional.ofNamedEmpty(this.rendererType + " renderer");
        }
    }

    @Override
    public Stream<NTextArtRenderer> listRenderers(Class<? extends NTextArtRenderer> rendererType) {
        if (rendererType.isAssignableFrom(NTextArtTextRenderer.class)) {
            return this.listRenderers();
        }
        return Stream.empty();
    }

    @Override
    public NOptional<NTextArtRenderer> load(InputStream path) {
        try {
            return NOptional.of(new FigletNTextArtTextRenderer(path, null));
        }
        catch (Exception e) {
            return NOptional.ofNamedEmpty(this.rendererType + " renderer");
        }
    }

    @Override
    public Stream<NTextArtRenderer> listRenderers() {
        HashMap all = new HashMap();
        for (ClassLoader classLoader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), NTextArtImpl.class.getClassLoader()}) {
            try {
                Enumeration<URL> resources = classLoader.getResources("META-INF/textart/" + this.rendererType + ".lst");
                for (URL url : NCollections.list(resources)) {
                    for (String line : NPath.of(url).lines()) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        String id = this.rendererType + ":" + line;
                        this.getRenderer(id).ifPresent(x -> all.put(id, x));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return all.values().stream();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NOptional<NTextArtRenderer> getRenderer(String renderName) {
        if (renderName.startsWith(this.rendererType + ":")) {
            try {
                return FigletNTextArtTextRenderer.ofName(renderName.substring(this.rendererType.length() + 1)).instanceOf(NTextArtRenderer.class);
            }
            catch (Exception e) {
                return NOptional.ofNamedEmpty(renderName);
            }
        }
        return NOptional.ofNamedEmpty(renderName);
    }
}

