/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.cmdline.DefaultNCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.text.AbstractNTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextTitle;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextAnchor;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCmd;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyles;

public class NTextNodeWriterStringer
extends AbstractNTextNodeWriter {
    private OutputStream out;

    public NTextNodeWriterStringer(OutputStream out) {
        this.out = out;
    }

    public static String toString(NText n, NWorkspace workspace) {
        if (n == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new NTextNodeWriterStringer(bos).writeNode(n);
        return bos.toString();
    }

    @Override
    public void writeRaw(byte[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public boolean flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return true;
    }

    @Override
    public void writeNode(NText node) {
        if (node == null) {
            return;
        }
        switch (node.type()) {
            case PLAIN: {
                NTextPlain p = (NTextPlain)node;
                this.writeEscaped(p.getValue());
                break;
            }
            case LIST: {
                NTextList s = (NTextList)node;
                for (NText n : s) {
                    this.writeNode(n);
                }
                break;
            }
            case BUILDER: {
                NTextBuilder s = (NTextBuilder)node;
                for (NText n : s) {
                    this.writeNode(n);
                }
                break;
            }
            case STYLED: {
                DefaultNTextStyled s = (DefaultNTextStyled)node;
                NTextStyles styles = s.getStyles();
                this.writeRaw("##{" + styles.id() + ":");
                this.writeNode(s.getChild());
                this.writeRaw("}##");
                this.writeRaw('\u001e');
                break;
            }
            case TITLE: {
                DefaultNTextTitle s = (DefaultNTextTitle)node;
                this.writeRaw(CoreStringUtils.fillString('#', s.getLevel()) + ") ");
                this.writeNode(s.getChild());
                this.writeRaw("\n");
                break;
            }
            case COMMAND: {
                NTextCmd s = (NTextCmd)node;
                this.writeRaw("```!");
                DefaultNCmdLine cmd = new DefaultNCmdLine();
                cmd.add(s.getCommand().getName());
                cmd.addAll(s.getCommand().getArgs());
                this.writeEscapedSpecial(((Object)cmd).toString());
                this.writeRaw("```");
                break;
            }
            case ANCHOR: {
                NTextAnchor s = (NTextAnchor)node;
                this.writeRaw("```!anchor");
                this.writeRaw(s.getSeparator());
                this.writeEscapedSpecial(s.getValue());
                this.writeRaw("```");
                break;
            }
            case LINK: {
                NTextLink s = (NTextLink)node;
                this.writeRaw("```!link");
                this.writeRaw(s.getSeparator());
                this.writeEscaped(s.getValue());
                this.writeRaw("```");
                break;
            }
            case INCLUDE: {
                NTextInclude s = (NTextInclude)node;
                this.writeRaw("```!include");
                this.writeRaw(s.getSeparator());
                this.writeEscaped(s.getText());
                this.writeRaw("```");
                break;
            }
            case CODE: {
                NTextCode s = (NTextCode)node;
                this.writeRaw("```");
                this.writeRaw(s.getQualifier());
                this.writeRaw(s.getSeparator());
                this.writeEscapedSpecial(s.getValue());
                this.writeRaw("```");
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid node type : " + node.getClass().getSimpleName());
            }
        }
    }

    public final void writeEscapedSpecial(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cc.length; ++i) {
            if (i <= cc.length - 3 && cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                sb.append('\\');
            }
            sb.append(cc[i]);
        }
        this.writeRaw(sb.toString());
    }

    public final void writeEscaped(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < cc.length; ++i) {
            switch (cc[i]) {
                case '\u001e': 
                case '\\': {
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '`': {
                    if (i < cc.length - 2) {
                        if (cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            sb.append(cc[i + 1]);
                            sb.append(cc[i + 2]);
                            i += 2;
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    if (i < cc.length - 1) {
                        if (cc[i] == '`' && cc[i + 1] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '#': {
                    if (i < cc.length - 1 && cc[i + 1] != cc[i]) {
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                default: {
                    sb.append(cc[i]);
                }
            }
        }
        this.writeRaw(sb.toString());
    }

    public final void writeRaw(char rawChar) {
        this.writeRaw(String.valueOf(rawChar));
    }

    public final void writeRaw(String rawString) {
        try {
            this.out.write(rawString.getBytes());
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private void writeStyledStart(NTextStyles styles, boolean complex) {
        StringBuilder sb = new StringBuilder();
        if (complex) {
            sb.append("##{");
        } else {
            sb.append("##:");
        }
        sb.append(styles.id());
        sb.append(":");
        this.writeRaw(sb.toString());
    }
}

